
package eu.dnetlib.dhp.schema.dump.oaf.community;

import java.util.List;

import com.github.imifou.jsonschema.module.addon.annotation.JsonSchema;

import eu.dnetlib.dhp.schema.dump.oaf.Result;

/**
 * extends eu.dnetlib.dhp.schema.dump.oaf.Result with the following parameters: - projects of type
 * List<eu.dnetlib.dhp.schema.dump.oaf.community.Project> to store the list of projects related to the result. The
 * information is added after the result is mapped to the external model - context of type
 * List<eu.dnetlib.dhp.schema.dump.oaf.community.Context> to store information about the RC RI related to the result.
 * For each context in the result represented in the internal model one context in the external model is produced -
 * collectedfrom of type List<eu.dnetliv.dhp.schema.dump.oaf.KeyValue> to store information about the sources from which
 * the record has been collected. For each collectedfrom in the result represented in the internal model one
 * collectedfrom in the external model is produced - instance of type
 * List<eu.dnetlib.dhp.schema.dump.oaf.community.CommunityInstance> to store all the instances associated to the result.
 * It corresponds to the same parameter in the result represented in the internal model
 */
public class CommunityResult extends Result {

	@JsonSchema(description = "List of projects (i.e. grants) that (co-)funded the production ofn the research results")
	private List<Project> projects;

	@JsonSchema(description = "Reference to a relevant research infrastructure, initiative or community (RI/RC) among those collaborating with OpenAIRE. Please see https://connect.openaire.eu")
	private List<Context> context;

	@JsonSchema(description = "Information about the sources from which the record has been collected")
	protected List<CfHbKeyValue> collectedfrom;

	@JsonSchema(description = "Each instance is one specific materialisation or version of the result. For example, you can have one result with three instance: one is the pre-print, one is the post-print, one is te published version")
	private List<CommunityInstance> instance;

	public List<CommunityInstance> getInstance() {
		return instance;
	}

	public void setInstance(List<CommunityInstance> instance) {
		this.instance = instance;
	}

	public List<CfHbKeyValue> getCollectedfrom() {
		return collectedfrom;
	}

	public void setCollectedfrom(List<CfHbKeyValue> collectedfrom) {
		this.collectedfrom = collectedfrom;
	}

	public List<Project> getProjects() {
		return projects;
	}

	public void setProjects(List<Project> projects) {
		this.projects = projects;
	}

	public List<Context> getContext() {
		return context;
	}

	public void setContext(List<Context> context) {
		this.context = context;
	}

}


