package eu.dnetlib.dhp.schema.dump.oaf;

import java.io.Serializable;

import org.apache.commons.lang3.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.imifou.jsonschema.module.addon.annotation.JsonSchema;

public class Measure implements Serializable {
    @JsonSchema(description = "The measure (i.e. popularity)")
    private String key;

    @JsonSchema(description = "The value for that measure")
    private String value;

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static Measure newInstance(String key, String value) {
        Measure inst = new Measure();
        inst.key = key;
        inst.value = value;
        return inst;
    }

    @JsonIgnore
    public boolean isBlank() {
        return StringUtils.isBlank(key) && StringUtils.isBlank(value);
    }

}
