/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.schema.sx.api.model.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import eu.dnetlib.dhp.schema.sx.api.model.v2.ScholixCreatorType;
import eu.dnetlib.dhp.schema.sx.api.model.v2.ScholixIdentifierType;
import eu.dnetlib.dhp.schema.sx.api.model.v2.ScholixLinkProviderType;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixResource;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ScholixItemType {
    @JsonProperty(value="Identifier")
    private List<ScholixIdentifierType> identifier = new ArrayList<ScholixIdentifierType>();
    @JsonProperty(value="Title")
    private String title;
    @JsonProperty(value="Type")
    private String type;
    @JsonProperty(value="subType")
    private String subType;
    @JsonProperty(value="Creator")
    private List<ScholixCreatorType> creator = new ArrayList<ScholixCreatorType>();
    @JsonProperty(value="PublicationDate")
    private String publicationDate;
    @JsonProperty(value="Publisher")
    private List<ScholixLinkProviderType> publisher = new ArrayList<ScholixLinkProviderType>();

    public List<ScholixIdentifierType> getIdentifier() {
        return this.identifier;
    }

    public ScholixItemType setIdentifier(List<ScholixIdentifierType> identifier) {
        this.identifier = identifier;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public ScholixItemType setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getSubType() {
        return this.subType;
    }

    public ScholixItemType setSubType(String subType) {
        this.subType = subType;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public ScholixItemType setType(String type) {
        this.type = type;
        return this;
    }

    public List<ScholixCreatorType> getCreator() {
        return this.creator;
    }

    public ScholixItemType setCreator(List<ScholixCreatorType> creator) {
        this.creator = creator;
        return this;
    }

    public String getPublicationDate() {
        return this.publicationDate;
    }

    public ScholixItemType setPublicationDate(String publicationDate) {
        this.publicationDate = publicationDate;
        return this;
    }

    public List<ScholixLinkProviderType> getPublisher() {
        return this.publisher;
    }

    public ScholixItemType setPublisher(List<ScholixLinkProviderType> publisher) {
        this.publisher = publisher;
        return this;
    }

    public static ScholixItemType fromScholixResource(ScholixResource input) {
        if (input == null) {
            return null;
        }
        ScholixItemType instance = new ScholixItemType();
        instance.setType("publication".equalsIgnoreCase(input.getObjectType()) ? "literature" : "dataset");
        instance.setTitle(input.getTitle());
        if (input.getIdentifier() != null) {
            instance.setIdentifier(input.getIdentifier().stream().map(ScholixIdentifierType::fromScholixIdentifier).collect(Collectors.toList()));
        }
        if (input.getPublisher() != null) {
            instance.setPublisher(input.getPublisher().stream().map(ScholixLinkProviderType::fromScholixEntityId).collect(Collectors.toList()));
        }
        instance.setPublicationDate(input.getPublicationDate());
        if (input.getCreator() != null) {
            instance.setCreator(input.getCreator().stream().map(ScholixCreatorType::fromScholixEntityId).collect(Collectors.toList()));
        }
        return instance;
    }
}

