/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.schema.sx.api.model.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import eu.dnetlib.dhp.schema.sx.api.model.v1.ScholixIdentifier;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixEntityId;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.Valid;

public class ScholixProvider {
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="identifier")
    @Valid
    private List<ScholixIdentifier> identifier = null;

    public static ScholixProvider fromScholixEntityId(ScholixEntityId provider) {
        if (provider == null) {
            return null;
        }
        ScholixProvider instance = new ScholixProvider().setName(provider.getName());
        if (provider.getIdentifiers() != null && provider.getIdentifiers().size() > 0) {
            instance.setIdentifier(provider.getIdentifiers().stream().map(i -> new ScholixIdentifier().setIdentifier(i.getIdentifier()).setSchema(i.getSchema())).collect(Collectors.toList()));
        }
        return instance;
    }

    public ScholixProvider name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="The provider name")
    public String getName() {
        return this.name;
    }

    public ScholixProvider setName(String name) {
        this.name = name;
        return this;
    }

    public ScholixProvider identifier(List<ScholixIdentifier> identifier) {
        this.identifier = identifier;
        return this;
    }

    public ScholixProvider addIdentifierItem(ScholixIdentifier identifierItem) {
        if (this.identifier == null) {
            this.identifier = new ArrayList<ScholixIdentifier>();
        }
        this.identifier.add(identifierItem);
        return this;
    }

    @Schema(description="the identifiers of the provider")
    @Valid
    public List<ScholixIdentifier> getIdentifier() {
        return this.identifier;
    }

    public ScholixProvider setIdentifier(List<ScholixIdentifier> identifier) {
        this.identifier = identifier;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScholixProvider scholixProviderType = (ScholixProvider)o;
        return Objects.equals(this.name, scholixProviderType.name) && Objects.equals(this.identifier, scholixProviderType.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.identifier);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScholixProviderType {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    identifiers: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

