/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.schema.sx.scholix;

import eu.dnetlib.dhp.schema.sx.scholix.ScholixComparator;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixIdentifier;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ScholixEntityId
implements Serializable,
Comparable<ScholixEntityId> {
    private String name;
    private List<ScholixIdentifier> identifiers;

    public ScholixEntityId() {
    }

    public ScholixEntityId(String name, List<ScholixIdentifier> identifiers) {
        this.name = name;
        this.identifiers = identifiers;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<ScholixIdentifier> getIdentifiers() {
        return this.identifiers;
    }

    public void setIdentifiers(List<ScholixIdentifier> identifiers) {
        this.identifiers = identifiers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScholixEntityId that = (ScholixEntityId)o;
        return this.compareTo(that) == 0;
    }

    public int hashCode() {
        if (this.identifiers != null) {
            return Objects.hash(ScholixComparator.normalizeString(this.name), this.identifiers.stream().sorted().collect(Collectors.toList()));
        }
        return Objects.hash(ScholixComparator.normalizeString(this.name));
    }

    @Override
    public int compareTo(ScholixEntityId other) {
        if (other == null) {
            return -1;
        }
        int nameComp = StringUtils.compare((String)ScholixComparator.normalizeString(this.name), (String)ScholixComparator.normalizeString(other.getName()));
        if (nameComp != 0) {
            return nameComp;
        }
        return ScholixComparator.compareList(this.identifiers, other.getIdentifiers());
    }
}

