/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.schema.oaf;

import com.fasterxml.jackson.annotation.JsonProperty;
import eu.dnetlib.dhp.schema.common.AccessRightComparator;
import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.Context;
import eu.dnetlib.dhp.schema.oaf.Country;
import eu.dnetlib.dhp.schema.oaf.EoscIfGuidelines;
import eu.dnetlib.dhp.schema.oaf.ExternalReference;
import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.OpenAccessColor;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.schema.oaf.Subject;
import eu.dnetlib.dhp.schema.oaf.utils.CleaningFunctions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class Result
extends OafEntity
implements Serializable {
    private Field<String> processingchargeamount;
    private Field<String> processingchargecurrency;
    private List<Author> author;
    private Qualifier resulttype;
    private Qualifier metaResourceType;
    private Qualifier language;
    private List<Country> country;
    private List<Subject> subject;
    private List<StructuredProperty> title;
    private List<StructuredProperty> relevantdate;
    private List<Field<String>> description;
    private Field<String> dateofacceptance;
    private Field<String> publisher;
    private Field<String> embargoenddate;
    private List<Field<String>> source;
    private List<Field<String>> fulltext;
    private List<Field<String>> format;
    private List<Field<String>> contributor;
    private Qualifier resourcetype;
    private List<Field<String>> coverage;
    private Qualifier bestaccessright;
    private List<Context> context;
    private List<ExternalReference> externalReference;
    private List<Instance> instance;
    private List<EoscIfGuidelines> eoscifguidelines;
    @JsonProperty(value="isGreen")
    private Boolean isGreen;
    private OpenAccessColor openAccessColor;
    @JsonProperty(value="isInDiamondJournal")
    private Boolean isInDiamondJournal;
    private Boolean publiclyFunded;

    public Field<String> getProcessingchargeamount() {
        return this.processingchargeamount;
    }

    public void setProcessingchargeamount(Field<String> processingchargeamount) {
        this.processingchargeamount = processingchargeamount;
    }

    public Field<String> getProcessingchargecurrency() {
        return this.processingchargecurrency;
    }

    public void setProcessingchargecurrency(Field<String> processingchargecurrency) {
        this.processingchargecurrency = processingchargecurrency;
    }

    public List<Author> getAuthor() {
        return this.author;
    }

    public void setAuthor(List<Author> author) {
        this.author = author;
    }

    public Qualifier getResulttype() {
        return this.resulttype;
    }

    public void setResulttype(Qualifier resulttype) {
        this.resulttype = resulttype;
    }

    public Qualifier getMetaResourceType() {
        return this.metaResourceType;
    }

    public void setMetaResourceType(Qualifier metaResourceType) {
        this.metaResourceType = metaResourceType;
    }

    public Qualifier getLanguage() {
        return this.language;
    }

    public void setLanguage(Qualifier language) {
        this.language = language;
    }

    public List<Country> getCountry() {
        return this.country;
    }

    public void setCountry(List<Country> country) {
        this.country = country;
    }

    public List<Subject> getSubject() {
        return this.subject;
    }

    public void setSubject(List<Subject> subject) {
        this.subject = subject;
    }

    public List<StructuredProperty> getTitle() {
        return this.title;
    }

    public void setTitle(List<StructuredProperty> title) {
        this.title = title;
    }

    public List<StructuredProperty> getRelevantdate() {
        return this.relevantdate;
    }

    public void setRelevantdate(List<StructuredProperty> relevantdate) {
        this.relevantdate = relevantdate;
    }

    public List<Field<String>> getDescription() {
        return this.description;
    }

    public void setDescription(List<Field<String>> description) {
        this.description = description;
    }

    public Field<String> getDateofacceptance() {
        return this.dateofacceptance;
    }

    public void setDateofacceptance(Field<String> dateofacceptance) {
        this.dateofacceptance = dateofacceptance;
    }

    public Field<String> getPublisher() {
        return this.publisher;
    }

    public void setPublisher(Field<String> publisher) {
        this.publisher = publisher;
    }

    public Field<String> getEmbargoenddate() {
        return this.embargoenddate;
    }

    public void setEmbargoenddate(Field<String> embargoenddate) {
        this.embargoenddate = embargoenddate;
    }

    public List<Field<String>> getSource() {
        return this.source;
    }

    public void setSource(List<Field<String>> source) {
        this.source = source;
    }

    public List<Field<String>> getFulltext() {
        return this.fulltext;
    }

    public void setFulltext(List<Field<String>> fulltext) {
        this.fulltext = fulltext;
    }

    public List<Field<String>> getFormat() {
        return this.format;
    }

    public void setFormat(List<Field<String>> format) {
        this.format = format;
    }

    public List<Field<String>> getContributor() {
        return this.contributor;
    }

    public void setContributor(List<Field<String>> contributor) {
        this.contributor = contributor;
    }

    public Qualifier getResourcetype() {
        return this.resourcetype;
    }

    public void setResourcetype(Qualifier resourcetype) {
        this.resourcetype = resourcetype;
    }

    public List<Field<String>> getCoverage() {
        return this.coverage;
    }

    public void setCoverage(List<Field<String>> coverage) {
        this.coverage = coverage;
    }

    public Qualifier getBestaccessright() {
        return this.bestaccessright;
    }

    public void setBestaccessright(Qualifier bestaccessright) {
        this.bestaccessright = bestaccessright;
    }

    public List<Context> getContext() {
        return this.context;
    }

    public void setContext(List<Context> context) {
        this.context = context;
    }

    public List<ExternalReference> getExternalReference() {
        return this.externalReference;
    }

    public void setExternalReference(List<ExternalReference> externalReference) {
        this.externalReference = externalReference;
    }

    public List<Instance> getInstance() {
        return this.instance;
    }

    public void setInstance(List<Instance> instance) {
        this.instance = instance;
    }

    public List<EoscIfGuidelines> getEoscifguidelines() {
        return this.eoscifguidelines;
    }

    public void setEoscifguidelines(List<EoscIfGuidelines> eoscifguidelines) {
        this.eoscifguidelines = eoscifguidelines;
    }

    public Boolean getIsGreen() {
        return this.isGreen;
    }

    public void setIsGreen(Boolean green) {
        this.isGreen = green;
    }

    public OpenAccessColor getOpenAccessColor() {
        return this.openAccessColor;
    }

    public void setOpenAccessColor(OpenAccessColor openAccessColor) {
        this.openAccessColor = openAccessColor;
    }

    public Boolean getIsInDiamondJournal() {
        return this.isInDiamondJournal;
    }

    public void setIsInDiamondJournal(Boolean inDiamondJournal) {
        this.isInDiamondJournal = inDiamondJournal;
    }

    public Boolean getPubliclyFunded() {
        return this.publiclyFunded;
    }

    public void setPubliclyFunded(Boolean publiclyFunded) {
        this.publiclyFunded = publiclyFunded;
    }

    public static boolean isAnEnrichment(OafEntity e) {
        return e.getDataInfo() != null && e.getDataInfo().getProvenanceaction() != null && "sysimport:enrich".equalsIgnoreCase(e.getDataInfo().getProvenanceaction().getClassid());
    }

    private static String extractKeyFromPid(StructuredProperty pid) {
        if (pid == null) {
            return null;
        }
        StructuredProperty normalizedPid = CleaningFunctions.normalizePidValue(pid);
        return String.format("%s::%s", normalizedPid.getQualifier().getClassid(), normalizedPid.getValue());
    }

    private static boolean validPid(StructuredProperty p) {
        return p.getValue() != null && p.getQualifier() != null && p.getQualifier().getClassid() != null;
    }

    public static Map<String, Instance> toInstanceMap(List<Instance> ri) {
        return ri.stream().filter(i -> i.getPid() != null || i.getAlternateIdentifier() != null).flatMap(i -> {
            ArrayList result = new ArrayList();
            if (i.getPid() != null) {
                i.getPid().stream().filter(Result::validPid).forEach(p -> result.add(new ImmutablePair((Object)Result.extractKeyFromPid(p), i)));
            }
            if (i.getAlternateIdentifier() != null) {
                i.getAlternateIdentifier().stream().filter(Result::validPid).forEach(p -> result.add(new ImmutablePair((Object)Result.extractKeyFromPid(p), i)));
            }
            return result.stream();
        }).collect(Collectors.toMap(Pair::getLeft, Pair::getRight, (a, b) -> a));
    }

    private static List<Instance> findEnrichmentsByPID(List<StructuredProperty> pids, Map<String, Instance> enrichments) {
        if (pids == null || enrichments == null) {
            return null;
        }
        return pids.stream().map(Result::extractKeyFromPid).map(enrichments::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static void applyEnrichment(Instance currentInstance, Instance enrichment) {
        if (currentInstance == null || enrichment == null) {
            return;
        }
        if (enrichment.getAccessright() != null && currentInstance.getAccessright() == null) {
            currentInstance.setAccessright(enrichment.getAccessright());
        }
        if (enrichment.getLicense() != null && currentInstance.getLicense() == null) {
            currentInstance.setLicense(enrichment.getLicense());
        }
        if (enrichment.getInstancetype() != null && currentInstance.getInstancetype() == null) {
            currentInstance.setInstancetype(enrichment.getInstancetype());
        }
        if (enrichment.getHostedby() != null && currentInstance.getHostedby() == null) {
            currentInstance.setHostedby(enrichment.getHostedby());
        }
        if (enrichment.getDistributionlocation() != null && currentInstance.getDistributionlocation() == null) {
            currentInstance.setDistributionlocation(enrichment.getDistributionlocation());
        }
        if (enrichment.getCollectedfrom() != null && currentInstance.getCollectedfrom() == null) {
            currentInstance.setCollectedfrom(enrichment.getCollectedfrom());
        }
        if (enrichment.getDateofacceptance() != null && currentInstance.getDateofacceptance() == null) {
            currentInstance.setDateofacceptance(enrichment.getDateofacceptance());
        }
        if (enrichment.getProcessingchargeamount() != null && currentInstance.getProcessingchargeamount() == null) {
            currentInstance.setProcessingchargeamount(enrichment.getProcessingchargeamount());
        }
        if (enrichment.getRefereed() != null && currentInstance.getRefereed() == null) {
            currentInstance.setRefereed(enrichment.getRefereed());
        }
        if (enrichment.getMeasures() != null) {
            if (currentInstance.getMeasures() == null) {
                currentInstance.setMeasures(enrichment.getMeasures());
            } else {
                enrichment.getMeasures().forEach(currentInstance.getMeasures()::add);
            }
        }
    }

    private static List<Instance> enrichInstances(List<Instance> toEnrichInstances, List<Instance> enrichmentInstances) {
        ArrayList<Instance> enrichmentResult = new ArrayList<Instance>();
        if (toEnrichInstances == null) {
            return enrichmentResult;
        }
        if (enrichmentInstances == null) {
            return toEnrichInstances;
        }
        Map<String, Instance> ri = Result.toInstanceMap(enrichmentInstances);
        toEnrichInstances.forEach(i -> {
            List<Instance> e = Result.findEnrichmentsByPID(i.getPid(), ri);
            if (e != null && !e.isEmpty()) {
                e.forEach(enr -> Result.applyEnrichment(i, enr));
            } else {
                List<Instance> a = Result.findEnrichmentsByPID(i.getAlternateIdentifier(), ri);
                if (a != null && !a.isEmpty()) {
                    a.forEach(enr -> Result.applyEnrichment(i, enr));
                }
            }
            enrichmentResult.add((Instance)i);
        });
        return enrichmentResult;
    }

    @Override
    public void mergeFrom(OafEntity e) {
        super.mergeFrom(e);
        if (!Result.class.isAssignableFrom(e.getClass())) {
            return;
        }
        Result r = (Result)e;
        if (this.processingchargeamount == null || StringUtils.isBlank((CharSequence)this.processingchargeamount.getValue())) {
            this.processingchargeamount = r.getProcessingchargeamount();
            this.processingchargecurrency = r.getProcessingchargecurrency();
        }
        this.eoscifguidelines = this.mergeLists(this.eoscifguidelines, r.getEoscifguidelines());
        this.setIsGreen(this.mergeBooleanOR(this.getIsGreen(), r.getIsGreen()));
        this.setIsInDiamondJournal(this.mergeBooleanOR(this.getIsInDiamondJournal(), r.getIsInDiamondJournal()));
        this.setPubliclyFunded(this.mergeBooleanOR(this.getPubliclyFunded(), r.getPubliclyFunded()));
        if (Boolean.logicalXor(Objects.nonNull((Object)this.getOpenAccessColor()), Objects.nonNull((Object)r.getOpenAccessColor()))) {
            this.setOpenAccessColor((OpenAccessColor)((Object)ObjectUtils.firstNonNull((Object[])new OpenAccessColor[]{this.getOpenAccessColor(), r.getOpenAccessColor()})));
        } else if (!Objects.equals((Object)this.getOpenAccessColor(), (Object)r.getOpenAccessColor())) {
            this.setOpenAccessColor(null);
        }
        if (!Result.isAnEnrichment(this) && !Result.isAnEnrichment(e)) {
            this.instance = this.mergeLists(this.instance, r.getInstance());
        } else {
            List<Instance> enrichedInstances;
            List<Instance> enrichmentInstances = Result.isAnEnrichment(this) ? this.instance : r.getInstance();
            List<Instance> list = enrichedInstances = Result.isAnEnrichment(this) ? r.getInstance() : this.instance;
            if (Result.isAnEnrichment(this)) {
                this.setDataInfo(e.getDataInfo());
            }
            this.instance = Result.enrichInstances(enrichedInstances, enrichmentInstances);
        }
        if (r.getBestaccessright() != null && new AccessRightComparator<Qualifier>().compare(r.getBestaccessright(), this.bestaccessright) < 0) {
            this.bestaccessright = r.getBestaccessright();
        }
        if (r.getResulttype() != null && this.compareTrust(this, r) < 0) {
            this.resulttype = r.getResulttype();
        }
        if (r.getLanguage() != null && this.compareTrust(this, r) < 0) {
            this.language = r.getLanguage();
        }
        if (Objects.nonNull(r.getDateofacceptance())) {
            if (Objects.isNull(this.getDateofacceptance())) {
                this.dateofacceptance = r.getDateofacceptance();
            } else if (this.compareTrust(this, r) < 0) {
                this.dateofacceptance = r.getDateofacceptance();
            }
        }
        this.country = this.mergeLists(this.country, r.getCountry());
        this.subject = this.mergeLists(this.subject, r.getSubject());
        StructuredProperty baseMainTitle = null;
        if (this.title != null && (baseMainTitle = this.getMainTitle(this.title)) != null) {
            StructuredProperty p = baseMainTitle;
            this.title = this.title.stream().filter(t -> t != p).collect(Collectors.toList());
        }
        StructuredProperty newMainTitle = null;
        if (r.getTitle() != null && (newMainTitle = this.getMainTitle(r.getTitle())) != null) {
            StructuredProperty p = newMainTitle;
            r.setTitle(r.getTitle().stream().filter(t -> t != p).collect(Collectors.toList()));
        }
        if (newMainTitle != null && this.compareTrust(this, r) < 0) {
            baseMainTitle = newMainTitle;
        }
        this.title = this.mergeLists(this.title, r.getTitle());
        if (this.title != null && baseMainTitle != null) {
            this.title.add(baseMainTitle);
        }
        this.relevantdate = this.mergeLists(this.relevantdate, r.getRelevantdate());
        this.description = this.longestLists(this.description, r.getDescription());
        if (r.getPublisher() != null && this.compareTrust(this, r) < 0) {
            this.publisher = r.getPublisher();
        }
        if (r.getEmbargoenddate() != null && this.compareTrust(this, r) < 0) {
            this.embargoenddate = r.getEmbargoenddate();
        }
        this.source = this.mergeLists(this.source, r.getSource());
        this.fulltext = this.mergeLists(this.fulltext, r.getFulltext());
        this.format = this.mergeLists(this.format, r.getFormat());
        this.contributor = this.mergeLists(this.contributor, r.getContributor());
        if (r.getResourcetype() != null) {
            this.resourcetype = r.getResourcetype();
        }
        this.coverage = this.mergeLists(this.coverage, r.getCoverage());
        this.context = this.mergeLists(this.context, r.getContext());
        this.externalReference = this.mergeLists(this.externalReference, r.getExternalReference());
    }

    private Boolean mergeBooleanOR(Boolean a, Boolean b) {
        if (Boolean.logicalXor(Objects.isNull(a), Objects.isNull(b))) {
            return (Boolean)ObjectUtils.firstNonNull((Object[])new Boolean[]{a, b});
        }
        if (Objects.nonNull(a) & Objects.nonNull(b)) {
            return a != false || b != false;
        }
        return null;
    }

    private List<Field<String>> longestLists(List<Field<String>> a, List<Field<String>> b) {
        if (a == null || b == null) {
            return a == null ? b : a;
        }
        if (a.size() == b.size()) {
            int msb;
            int msa = a.stream().filter(i -> i != null && i.getValue() != null).map(i -> ((String)i.getValue()).length()).max(Comparator.naturalOrder()).orElse(0);
            return msa > (msb = b.stream().filter(i -> i != null && i.getValue() != null).map(i -> ((String)i.getValue()).length()).max(Comparator.naturalOrder()).orElse(0).intValue()) ? a : b;
        }
        return a.size() > b.size() ? a : b;
    }

    private StructuredProperty getMainTitle(List<StructuredProperty> titles) {
        for (StructuredProperty t : titles) {
            if (t.getQualifier() == null || t.getQualifier().getClassid() == null || !t.getQualifier().getClassid().equals("main title")) continue;
            return t;
        }
        return null;
    }
}

