/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.schema.sx.api.model.v2;

import com.fasterxml.jackson.annotation.JsonProperty;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixRelationship;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;

public class RelationshipType {
    @NotNull
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="SubType")
    private String subType;
    @JsonProperty(value="SubTypeSchema")
    private String subTypeSchema;
    public static Map<String, String> relationMapping = Stream.of({"issupplementto", "IsSupplementTo"}, {"issupplementedby", "IsSupplementedBy"}, {"references", "References"}, {"isreferencedby", "IsReferencedBy"}).collect(Collectors.toMap(data -> data[0], data -> data[1]));

    @Schema(description="The relationship type chosen from a Scholix controlled vocabulary")
    public String getName() {
        return this.name;
    }

    public RelationshipType setName(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="The sub-type of RelationshipType.Name")
    public String getSubType() {
        return this.subType;
    }

    public RelationshipType setSubType(String subType) {
        this.subType = subType;
        return this;
    }

    @Schema(description="The name of the schema or controlled list from which RelationshipSub-type is sourced")
    public String getSubTypeSchema() {
        return this.subTypeSchema;
    }

    public RelationshipType setSubTypeSchema(String subTypeSchema) {
        this.subTypeSchema = subTypeSchema;
        return this;
    }

    public static RelationshipType fromScholixRelationship(ScholixRelationship inputRels) {
        return new RelationshipType().setName(relationMapping.getOrDefault(inputRels.getName(), "IsRelatedTo")).setSubType(inputRels.getName()).setSubTypeSchema(inputRels.getSchema());
    }
}

