/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.schema.oaf;

import eu.dnetlib.dhp.schema.oaf.Context;
import eu.dnetlib.dhp.schema.oaf.ExtraInfo;
import eu.dnetlib.dhp.schema.oaf.Measure;
import eu.dnetlib.dhp.schema.oaf.OAIProvenance;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public abstract class OafEntity
extends Oaf
implements Serializable {
    private String id;
    private List<String> originalId;
    private List<StructuredProperty> pid;
    private String dateofcollection;
    private String dateoftransformation;
    private List<ExtraInfo> extraInfo;
    private OAIProvenance oaiprovenance;
    private List<Measure> measures;
    private List<Context> context;

    public List<Context> getContext() {
        return this.context;
    }

    public void setContext(List<Context> context) {
        this.context = context;
    }

    public List<Measure> getMeasures() {
        return this.measures;
    }

    public void setMeasures(List<Measure> measures) {
        this.measures = measures;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<String> getOriginalId() {
        return this.originalId;
    }

    public void setOriginalId(List<String> originalId) {
        this.originalId = originalId;
    }

    public List<StructuredProperty> getPid() {
        return this.pid;
    }

    public void setPid(List<StructuredProperty> pid) {
        this.pid = pid;
    }

    public String getDateofcollection() {
        return this.dateofcollection;
    }

    public void setDateofcollection(String dateofcollection) {
        this.dateofcollection = dateofcollection;
    }

    public String getDateoftransformation() {
        return this.dateoftransformation;
    }

    public void setDateoftransformation(String dateoftransformation) {
        this.dateoftransformation = dateoftransformation;
    }

    public List<ExtraInfo> getExtraInfo() {
        return this.extraInfo;
    }

    public void setExtraInfo(List<ExtraInfo> extraInfo) {
        this.extraInfo = extraInfo;
    }

    public OAIProvenance getOaiprovenance() {
        return this.oaiprovenance;
    }

    public void setOaiprovenance(OAIProvenance oaiprovenance) {
        this.oaiprovenance = oaiprovenance;
    }

    public void mergeFrom(OafEntity e) {
        super.mergeFrom(e);
        this.originalId = this.mergeLists(this.originalId, e.getOriginalId());
        this.pid = this.mergeLists(this.pid, e.getPid());
        if (e.getDateofcollection() != null && this.compareTrust(this, e) < 0) {
            this.dateofcollection = e.getDateofcollection();
        }
        if (e.getDateoftransformation() != null && this.compareTrust(this, e) < 0) {
            this.dateoftransformation = e.getDateoftransformation();
        }
        this.extraInfo = this.mergeLists(this.extraInfo, e.getExtraInfo());
        if (e.getOaiprovenance() != null && this.compareTrust(this, e) < 0) {
            this.oaiprovenance = e.getOaiprovenance();
        }
        this.measures = this.mergeLists(this.measures, e.getMeasures());
        this.context = this.mergeLists(this.context, e.getContext());
    }

    @SafeVarargs
    protected final <T> List<T> mergeLists(List<T> ... lists) {
        return Arrays.stream(lists).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OafEntity oafEntity = (OafEntity)o;
        return Objects.equals(this.id, oafEntity.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.id);
    }
}

