set mapred.job.queue.name=analytics;

drop database if exists TARGET cascade;
create database if not exists TARGET;

create table TARGET.result stored as parquet as
    select distinct * from (
        select * from SOURCE.result r where exists (select 1 from SOURCE.result_organization ro where ro.id=r.id and ro.organization in (
             'openorgs____::b84450f9864182c67b8611b5593f4250', --"Athena Research and Innovation Center In Information Communication & Knowledge Technologies', --ARC"
             'openorgs____::d41cf6bd4ab1b1362a44397e0b95c975', --National Research Council
             'openorgs____::d2a09b9d5eabb10c95f9470e172d05d2', --??? Not exists ??
             'openorgs____::d169c7407dd417152596908d48c11460', --Masaryk University
             'openorgs____::1ec924b1759bb16d0a02f2dad8689b21', --University of Belgrade
             'openorgs____::0ae431b820e4c33db8967fbb2b919150', --University of Helsinki
             'openorgs____::759d59f05d77188faee99b7493b46805', --University of Minho
             'openorgs____::cad284878801b9465fa51a95b1d779db', --Universidad Politécnica de Madrid
             'openorgs____::eadc8da90a546e98c03f896661a2e4d4', --University of Göttingen
             'openorgs____::c0286313e36479eff8676dba9b724b40', --National and Kapodistrian University of Athens
             'openorgs____::c08634f0a6b0081c3dc6e6c93a4314f3', --Bielefeld University
             'openorgs____::6fc85e4a8f7ecaf4b0c738d010e967ea', --University of Southern Denmark
             'openorgs____::3d6122f87f9a97a99d8f6e3d73313720', --Humboldt-Universität zu Berlin
             'openorgs____::16720ada63d0fa8ca41601feae7d1aa5', --TU Darmstadt
             'openorgs____::ccc0a066b56d2cfaf90c2ae369df16f5', --KU Leuven
             'openorgs____::4c6f119632adf789746f0a057ed73e90', --University of the Western Cape
             'openorgs____::ec3665affa01aeafa28b7852c4176dbd', --Rudjer Boskovic Institute
             'openorgs____::5f31346d444a7f06a28c880fb170b0f6', --Ghent University
             'openorgs____::2dbe47117fd5409f9c61620813456632', --University of Luxembourg
             'openorgs____::6445d7758d3a40c4d997953b6632a368', --National Institute of Informatics (NII)
             'openorgs____::b77c01aa15de3675da34277d48de2ec1', -- Valencia Catholic University Saint Vincent Martyr
             'openorgs____::7fe2f66cdc43983c6b24816bfe9cf6a0', -- Unviersity of Warsaw
             'openorgs____::15e7921fc50d9aa1229a82a84429419e', -- University Of Thessaly
             'openorgs____::11f7919dadc8f8a7251af54bba60c956', -- Technical University of Crete
             'openorgs____::84f0c5f5dbb6daf42748485924efde4b', -- University of Piraeus
             'openorgs____::4ac562f0376fce3539504567649cb373', -- University of Patras
             'openorgs____::3e8d1f8c3f6cd7f418b09f1f58b4873b', -- Aristotle University of Thessaloniki
             'openorgs____::3fcef6e1c469c10f2a84b281372c9814', -- World Bank
             'openorgs____::1698a2eb1885ef8adb5a4a969e745ad3', -- École des Ponts ParisTech
             'openorgs____::e15adb13c4dadd49de4d35c39b5da93a', -- Nanyang Technological University
             'openorgs____::4b34103bde246228fcd837f5f1bf4212', -- Autonomous University of Barcelona
             'openorgs____::72ec75fcfc4e0df1a76dc4c49007fceb', -- McMaster University
             'openorgs____::51c7fc556e46381734a25a6fbc3fd398', -- University of Modena and Reggio Emilia
             'openorgs____::235d7f9ad18ecd7e6dc62ea4990cb9db', -- Bilkent University
             'openorgs____::31f2fa9e05b49d4cf40a19c3fed8eb06', -- Saints Cyril and Methodius University of Skopje
             'openorgs____::db7686f30f22cbe73a4fde872ce812a6', -- University of Milan
             'openorgs____::b8b8ca674452579f3f593d9f5e557483',  -- University College Cork
             'openorgs____::38d7097854736583dde879d12dacafca',	-- Brown University
             'openorgs____::57784c9e047e826fefdb1ef816120d92',  --Arts et Métiers ParisTech
             'openorgs____::2530baca8a15936ba2e3297f2bce2e7e',	-- University of Cape Town
             'openorgs____::d11f981828c485cd23d93f7f24f24db1',  -- Technological University Dublin
             'openorgs____::5e6bf8962665cdd040341171e5c631d8',  -- Delft University of Technology
             'openorgs____::846cb428d3f52a445f7275561a7beb5d',  -- University of Manitoba
             'openorgs____::eb391317ed0dc684aa81ac16265de041',	-- Universitat Rovira i Virgili
             'openorgs____::66aa9fc2fceb271423dfabcc38752dc0',  -- Lund University
             'openorgs____::3cff625a4370d51e08624cc586138b2f',	-- IMT Atlantique
             'openorgs____::c0b262bd6eab819e4c994914f9c010e2',   -- National Institute of Geophysics and Volcanology
             'openorgs____::1624ff7c01bb641b91f4518539a0c28a',   -- Vrije Universiteit Amsterdam
             'openorgs____::4d4051b56708688235252f1d8fddb8c1',	 --Iscte - Instituto Universitário de Lisboa
             'openorgs____::ab4ac74c35fa5dada770cf08e5110fab',	 -- Universidade Católica Portuguesa
             'openorgs____::4d4051b56708688235252f1d8fddb8c1',	 -- Iscte - Instituto Universitário de Lisboa
             'openorgs____::5d55fb216b14691cf68218daf5d78cd9',  -- Munster Technological University
             'openorgs____::0fccc7640f0cb44d5cd1b06b312a06b9',  -- Cardiff University
             'openorgs____::8839b55dae0c84d56fd533f52d5d483a',   -- Leibniz Institute of Ecological Urban and Regional Development
             'openorgs____::526468206bca24c1c90da6a312295cf4',	-- Cyprus University of Technology
             'openorgs____::b5ca9d4340e26454e367e2908ef3872f',	-- Alma Mater Studiorum University of Bologna
             'openorgs____::a6340e6ecf60f6bba163659df985b0f2',	-- TU Dresden
             'openorgs____::64badd35233ba2cd4946368ef2f4cf57',  -- University of Vienna
             'openorgs____::7501d66d2297a963ebfb075c43fff88e',  -- Royal Institute of Technology
             'openorgs____::d5eb679abdd31f70fcd4c8ba711148bf',	-- Sorbonne University
             'openorgs____::b316f25380d106aac402f5ae8653910d',  -- Centre for Research on Ecology and Forestry Applications
             'openorgs____::45a2076eee3013e0e85625ce61bcd272',  -- Institut d'Investigació Sanitària Illes Balears
             'openorgs____::00b20b0a743a96169e6cf135e6e2bd7c',  -- Universidad Publica De Navarra
             'openorgs____::0f398605c2459294d125ff23473a97dc',  -- Aalto University
             'openorgs____::25b1fa62c7fd8e409d3a83c07e04b2d4',  -- WHU-Otto Beisheim School of Management
             'openorgs____::d6eec313417f11205db4e736a34c0db6',  -- KEMPELENOV INSTITUT INTELIGENTNYCH TECHNOLOGII
             'openorgs____::c2dfb90e797a2dc52f0084c549289d0c',  -- National Research Institute for Agriculture, Food and Environment
             'openorgs____::363e3a4ac2859f3506fae9fdf768660b', -- Stockholm University
             'openorgs____::0b0102bae51f4f4ef5ba57fbe1523b92', -- University of Duisburg-Essen
             'openorgs____::cdda7cfe17c89eb50628ec2eb1f8acd2', -- University of Iceland
             'openorgs____::039192f47416999e406a6b57da19beeb', -- Palacký University, Olomouc
             'openorgs____::0a45de396fc864dc70d42d13f4e786e1', -- Copenhagen Business School
             'openorgs____::925676880d50bf53409a6dd7d4d90283', -- South-West University "Neofit Rilski"
             'openorgs____::305ca93734416f1874ef0a3412b0612b', -- University of Pavol Jozef Šafárik
             'openorgs____::eb0669daa9efeb898a3090d8aac7c953', -- University Federico II of Naples
             'openorgs____::f7cfcc98245e22c7d6e321cde930e746', -- University of Innsbruck
             'openorgs____::d1f5d132714edad4a952e0414fc3c94b', -- Paris-East Créteil University
             'openorgs____::408f8173e66f58588f4fa679bac35190', -- V.N. Karazin Kharkiv National University
             'openorgs____::0120387227da5845aa410ad5b994a2e2', -- University of Tetova
             'openorgs____::d6ddbed2807becaf5b096013ba158c9b', -- University of Padua
             'openorgs____::2c42515d58e84fe37929b0bd11c30b8b' -- University of Beira Interior
            )))  foo;