/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.swh.utils;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.collection.HttpClientParams;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SWHUtils {
    private static final Logger log = LoggerFactory.getLogger(SWHUtils.class);

    public static HttpClientParams getClientParams(ArgumentApplicationParser argumentParser) {
        HttpClientParams clientParams = new HttpClientParams();
        clientParams.setMaxNumberOfRetry(Optional.ofNullable(argumentParser.get("maxNumberOfRetry")).map(Integer::parseInt).orElse(HttpClientParams._maxNumberOfRetry).intValue());
        log.info("maxNumberOfRetry is {}", (Object)clientParams.getMaxNumberOfRetry());
        clientParams.setRequestDelay(Optional.ofNullable(argumentParser.get("requestDelay")).map(Integer::parseInt).orElse(HttpClientParams._requestDelay).intValue());
        log.info("requestDelay is {}", (Object)clientParams.getRequestDelay());
        clientParams.setRetryDelay(Optional.ofNullable(argumentParser.get("retryDelay")).map(Integer::parseInt).orElse(HttpClientParams._retryDelay).intValue());
        log.info("retryDelay is {}", (Object)clientParams.getRetryDelay());
        clientParams.setRequestMethod(Optional.ofNullable(argumentParser.get("requestMethod")).orElse(HttpClientParams._requestMethod));
        log.info("requestMethod is {}", (Object)clientParams.getRequestMethod());
        return clientParams;
    }

    public static BufferedReader getFileReader(FileSystem fs, Path inputPath) throws IOException {
        FSDataInputStream inputStream = fs.open(inputPath);
        return new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));
    }

    public static SequenceFile.Writer getSequenceFileWriter(FileSystem fs, String outputPath) throws IOException {
        return SequenceFile.createWriter((Configuration)fs.getConf(), (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)new Path(outputPath)), SequenceFile.Writer.keyClass(Text.class), SequenceFile.Writer.valueClass(Text.class)});
    }

    public static SequenceFile.Reader getSequenceFileReader(FileSystem fs, String inputPath) throws IOException {
        Path filePath = new Path(inputPath);
        SequenceFile.Reader.Option fileOption = SequenceFile.Reader.file((Path)filePath);
        return new SequenceFile.Reader(fs.getConf(), new SequenceFile.Reader.Option[]{fileOption});
    }

    public static void appendToSequenceFile(SequenceFile.Writer fw, String keyStr, String valueStr) throws IOException {
        Text key = new Text();
        key.set(keyStr);
        Text value = new Text();
        value.set(valueStr);
        fw.append((Writable)key, (Writable)value);
    }
}

