/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.swh;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.collection.CollectorException;
import eu.dnetlib.dhp.common.collection.HttpClientParams;
import eu.dnetlib.dhp.schema.oaf.utils.GraphCleaningFunctions;
import eu.dnetlib.dhp.swh.CollectLastVisitRepositoryData;
import eu.dnetlib.dhp.swh.models.LastVisitData;
import eu.dnetlib.dhp.swh.utils.SWHConnection;
import eu.dnetlib.dhp.swh.utils.SWHUtils;
import eu.dnetlib.dhp.utils.DHPUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveRepositoryURLs {
    private static final Logger log = LoggerFactory.getLogger(ArchiveRepositoryURLs.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static SWHConnection swhConnection = null;

    public static void main(String[] args) throws IOException, ParseException {
        ArgumentApplicationParser argumentParser = new ArgumentApplicationParser(IOUtils.toString((InputStream)CollectLastVisitRepositoryData.class.getResourceAsStream("/eu/dnetlib/dhp/swh/input_archive_repository_urls.json")));
        argumentParser.parseArgument(args);
        String hdfsuri = argumentParser.get("namenode");
        log.info("hdfsURI: {}", (Object)hdfsuri);
        String inputPath = argumentParser.get("lastVisitsPath");
        log.info("inputPath: {}", (Object)inputPath);
        String outputPath = argumentParser.get("archiveRequestsPath");
        log.info("outputPath: {}", (Object)outputPath);
        Integer archiveThresholdInDays = Integer.parseInt(argumentParser.get("archiveThresholdInDays"));
        log.info("archiveThresholdInDays: {}", (Object)archiveThresholdInDays);
        String apiAccessToken = argumentParser.get("apiAccessToken");
        log.info("apiAccessToken: {}", (Object)apiAccessToken);
        HttpClientParams clientParams = SWHUtils.getClientParams(argumentParser);
        swhConnection = new SWHConnection(clientParams, apiAccessToken);
        FileSystem fs = FileSystem.get((Configuration)DHPUtils.getHadoopConfiguration((String)hdfsuri));
        ArchiveRepositoryURLs.archive(fs, inputPath, outputPath, archiveThresholdInDays);
    }

    private static void archive(FileSystem fs, String inputPath, String outputPath, Integer archiveThresholdInDays) throws IOException {
        SequenceFile.Reader fr = SWHUtils.getSequenceFileReader(fs, inputPath);
        SequenceFile.Writer fw = SWHUtils.getSequenceFileWriter(fs, outputPath);
        Text repoUrl = new Text();
        Text lastVisitData = new Text();
        while (fr.next((Writable)repoUrl, (Writable)lastVisitData)) {
            String response = null;
            try {
                response = ArchiveRepositoryURLs.handleRecord(repoUrl.toString(), lastVisitData.toString(), archiveThresholdInDays);
            }
            catch (java.text.ParseException e) {
                log.error("Could not handle record with repo Url: {}", (Object)repoUrl.toString());
                throw new RuntimeException(e);
            }
            if (response == null) continue;
            SWHUtils.appendToSequenceFile(fw, repoUrl.toString(), response);
        }
        fw.close();
        fr.close();
    }

    public static String handleRecord(String repoUrl, String lastVisitData, Integer archiveThresholdInDays) throws IOException, java.text.ParseException {
        String response;
        String cleanDate;
        log.info("{ Key: {}, Value: {} }", (Object)repoUrl, (Object)lastVisitData);
        LastVisitData lastVisit = (LastVisitData)OBJECT_MAPPER.readValue(lastVisitData, LastVisitData.class);
        if (lastVisit.getStatus() != null && lastVisit.getStatus().equals("not_found")) {
            log.info("Avoid request -- previous archive request returned NOT_FOUND");
            return null;
        }
        if (lastVisit.getSnapshot() != null && (cleanDate = GraphCleaningFunctions.cleanDate((String)lastVisit.getDate())) != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            Date lastVisitDate = formatter.parse(cleanDate);
            long diffInMillies = Math.abs(new Date().getTime() - lastVisitDate.getTime());
            long diffInDays = TimeUnit.DAYS.convert(diffInMillies, TimeUnit.MILLISECONDS);
            log.info("Date diff from now (in days): {}", (Object)diffInDays);
            if ((long)archiveThresholdInDays.intValue() >= diffInDays) {
                log.info("Avoid request -- no older than {} days", (Object)archiveThresholdInDays);
                return null;
            }
        }
        log.info("Perform archive request for: {}", (Object)repoUrl);
        String visitType = Optional.ofNullable(lastVisit.getType()).orElse("git");
        URL url = new URL(String.format("https://archive.softwareheritage.org/api/1/origin/save/%s/url/%s/", visitType, repoUrl.trim()));
        log.info("Sending archive request: {}", (Object)url);
        try {
            response = swhConnection.call(url.toString());
        }
        catch (CollectorException e) {
            log.error("Error in request: {}", (Object)url);
            response = "{}";
        }
        return response;
    }
}

