/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.swh;

import eu.dnetlib.dhp.common.collection.CollectorException;
import eu.dnetlib.dhp.common.collection.HttpClientParams;
import eu.dnetlib.dhp.swh.utils.SWHConnection;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SWHConnectionTest {
    private static final Logger log = LoggerFactory.getLogger(SWHConnectionTest.class);

    @Test
    void testGetCall() throws IOException {
        HttpClientParams clientParams = new HttpClientParams();
        clientParams.setRequestMethod("GET");
        SWHConnection swhConnection = new SWHConnection(clientParams, null);
        String repoUrl = "https://github.com/stanford-futuredata/FAST";
        URL url = new URL(String.format("https://archive.softwareheritage.org/api/1/origin/%s/visit/latest/", repoUrl));
        String response = null;
        try {
            response = swhConnection.call(url.toString());
        }
        catch (CollectorException e) {
            System.out.println("Error in request: " + String.valueOf(url));
        }
        System.out.println(response);
    }

    @Test
    void testPostCall() throws MalformedURLException {
        HttpClientParams clientParams = new HttpClientParams();
        clientParams.setRequestMethod("POST");
        SWHConnection swhConnection = new SWHConnection(clientParams, null);
        String repoUrl = "https://github.com/stanford-futuredata/FAST";
        URL url = new URL(String.format("https://archive.softwareheritage.org/api/1/origin/save/%s/url/%s/", "git", repoUrl));
        String response = null;
        try {
            response = swhConnection.call(url.toString());
        }
        catch (CollectorException e) {
            System.out.println("Error in request: " + String.valueOf(url));
        }
        System.out.println(response);
    }
}

