/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.oa.graph.usagestatsbuild.export;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import eu.dnetlib.oa.graph.usagestatsbuild.export.ExecuteWorkflow;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public abstract class ConnectDB {
    public static Connection DB_HIVE_CONNECTION;
    public static Connection DB_IMPALA_CONNECTION;
    private static String dbHiveUrl;
    private static String dbImpalaUrl;
    private static String usageRawDataDBSchema;
    private static String usageStatsDBSchema;
    private static String usagestatsPermanentDBSchema;
    private static String statsDBSchema;
    private static final Logger log;

    static void init() throws ClassNotFoundException {
        dbHiveUrl = ExecuteWorkflow.dbHiveUrl;
        dbImpalaUrl = ExecuteWorkflow.dbImpalaUrl;
        usageStatsDBSchema = ExecuteWorkflow.usageStatsDBSchema;
        statsDBSchema = ExecuteWorkflow.statsDBSchema;
        usageRawDataDBSchema = ExecuteWorkflow.usageRawDataDBSchema;
        usagestatsPermanentDBSchema = ExecuteWorkflow.usagestatsPermanentDBSchema;
        Class.forName("org.apache.hive.jdbc.HiveDriver");
    }

    public static Connection getHiveConnection() throws SQLException {
        if (DB_HIVE_CONNECTION != null && !DB_HIVE_CONNECTION.isClosed()) {
            return DB_HIVE_CONNECTION;
        }
        DB_HIVE_CONNECTION = ConnectDB.connectHive();
        return DB_HIVE_CONNECTION;
    }

    public static Connection getImpalaConnection() throws SQLException {
        if (DB_IMPALA_CONNECTION != null && !DB_IMPALA_CONNECTION.isClosed()) {
            return DB_IMPALA_CONNECTION;
        }
        DB_IMPALA_CONNECTION = ConnectDB.connectImpala();
        return DB_IMPALA_CONNECTION;
    }

    public static String getUsageRawDataDBSchema() {
        return usageRawDataDBSchema;
    }

    public static String getUsageStatsDBSchema() {
        String datePattern = "YYYYMMdd";
        SimpleDateFormat df = new SimpleDateFormat(datePattern);
        Date today = Calendar.getInstance().getTime();
        String todayAsString = df.format(today);
        return usageStatsDBSchema + "_" + todayAsString;
    }

    public static String getStatsDBSchema() {
        return statsDBSchema;
    }

    public static String getUsagestatsPermanentDBSchema() {
        return usagestatsPermanentDBSchema;
    }

    private static Connection connectHive() throws SQLException {
        ComboPooledDataSource cpds = new ComboPooledDataSource();
        cpds.setJdbcUrl(dbHiveUrl);
        cpds.setAcquireIncrement(1);
        cpds.setMaxPoolSize(100);
        cpds.setMinPoolSize(1);
        cpds.setInitialPoolSize(1);
        cpds.setMaxIdleTime(300);
        cpds.setMaxConnectionAge(36000);
        cpds.setAcquireRetryAttempts(30);
        cpds.setAcquireRetryDelay(2000);
        cpds.setBreakAfterAcquireFailure(false);
        cpds.setCheckoutTimeout(0);
        cpds.setPreferredTestQuery("SELECT 1");
        cpds.setIdleConnectionTestPeriod(60);
        return cpds.getConnection();
    }

    private static Connection connectImpala() throws SQLException {
        ComboPooledDataSource cpds = new ComboPooledDataSource();
        cpds.setJdbcUrl(dbImpalaUrl);
        cpds.setAcquireIncrement(1);
        cpds.setMaxPoolSize(100);
        cpds.setMinPoolSize(1);
        cpds.setInitialPoolSize(1);
        cpds.setMaxIdleTime(300);
        cpds.setMaxConnectionAge(36000);
        cpds.setAcquireRetryAttempts(30);
        cpds.setAcquireRetryDelay(2000);
        cpds.setBreakAfterAcquireFailure(false);
        cpds.setCheckoutTimeout(0);
        cpds.setPreferredTestQuery("SELECT 1");
        cpds.setIdleConnectionTestPeriod(60);
        return cpds.getConnection();
    }

    static {
        log = Logger.getLogger(ConnectDB.class);
    }
}

