/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.oa.graph.usagestatsbuild.export;

import eu.dnetlib.oa.graph.usagestatsbuild.export.ConnectDB;
import eu.dnetlib.oa.graph.usagestatsbuild.export.ExecuteWorkflow;
import eu.dnetlib.oa.graph.usagestatsbuild.export.IrusStats;
import eu.dnetlib.oa.graph.usagestatsbuild.export.LaReferenciaStats;
import eu.dnetlib.oa.graph.usagestatsbuild.export.PiwikStatsDB;
import eu.dnetlib.oa.graph.usagestatsbuild.export.SarcStats;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsageStatsExporter {
    private static final Logger logger = LoggerFactory.getLogger(UsageStatsExporter.class);

    public void export() throws Exception {
        logger.info("Initialising DB properties");
        ConnectDB.init();
        PiwikStatsDB piwikstatsdb = new PiwikStatsDB();
        logger.info("Re-creating database and tables");
        if (ExecuteWorkflow.recreateDbAndTables) {
            piwikstatsdb.recreateDBAndTables();
            logger.info("DB-Tables are created ");
        }
        if (ExecuteWorkflow.processPiwikLogs) {
            logger.info("Processing Piwik logs");
            piwikstatsdb.processLogs();
            logger.info("Piwik logs Done");
            logger.info("Processing Pedocs Old Stats");
            piwikstatsdb.uploadOldPedocs();
            logger.info("Processing Pedocs Old Stats Done");
            logger.info("Processing TUDELFT Stats");
            piwikstatsdb.uploadTUDELFTStats();
            logger.info("Processing TUDELFT Stats Done");
        }
        LaReferenciaStats lastats = new LaReferenciaStats();
        if (ExecuteWorkflow.processLaReferenciaLogs) {
            logger.info("Processing LaReferencia logs");
            lastats.processLogs();
            logger.info("LaReferencia logs done");
        }
        IrusStats irusstats = new IrusStats();
        if (ExecuteWorkflow.irusProcessStats) {
            logger.info("Processing IRUS");
            irusstats.processIrusStats();
            logger.info("Irus done");
        }
        SarcStats sarcStats = new SarcStats();
        if (ExecuteWorkflow.sarcProcessStats) {
            sarcStats.processSarc();
        }
        logger.info("Sarc done");
        if (ExecuteWorkflow.finalizeStats) {
            piwikstatsdb.finalizeStats();
            logger.info("Finalized stats");
        }
        if (ExecuteWorkflow.finalTablesVisibleToImpala) {
            logger.info("Making tables visible to Impala");
            this.invalidateMetadata();
        }
        logger.info("End");
    }

    private void invalidateMetadata() throws SQLException {
        Statement stmt = null;
        stmt = ConnectDB.getImpalaConnection().createStatement();
        String sql = "INVALIDATE METADATA " + ConnectDB.getUsageStatsDBSchema() + ".downloads_stats";
        stmt.executeUpdate(sql);
        sql = "INVALIDATE METADATA " + ConnectDB.getUsageStatsDBSchema() + ".views_stats";
        stmt.executeUpdate(sql);
        sql = "INVALIDATE METADATA " + ConnectDB.getUsageStatsDBSchema() + ".usage_stats";
        stmt.executeUpdate(sql);
        sql = "INVALIDATE METADATA " + ConnectDB.getUsageStatsDBSchema() + ".pageviews_stats";
        stmt.executeUpdate(sql);
        sql = "INVALIDATE METADATA " + ConnectDB.getUsagestatsPermanentDBSchema() + ".downloads_stats";
        stmt.executeUpdate(sql);
        sql = "INVALIDATE METADATA " + ConnectDB.getUsagestatsPermanentDBSchema() + ".views_stats";
        stmt.executeUpdate(sql);
        sql = "INVALIDATE METADATA " + ConnectDB.getUsagestatsPermanentDBSchema() + ".usage_stats";
        stmt.executeUpdate(sql);
        sql = "INVALIDATE METADATA " + ConnectDB.getUsagestatsPermanentDBSchema() + ".pageviews_stats";
        stmt.executeUpdate(sql);
        stmt.close();
        ConnectDB.getHiveConnection().close();
    }
}

