/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.oa.graph.usagestatsbuild.export;

import eu.dnetlib.oa.graph.usagestatsbuild.export.ConnectDB;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SarcStats {
    private Statement stmtHive = null;
    private Statement stmtImpala = null;
    private static final Logger logger = LoggerFactory.getLogger(SarcStats.class);

    private void createTables() throws Exception {
        try {
            this.stmtHive = ConnectDB.getHiveConnection().createStatement();
            String sqlCreateTableSushiLog = "CREATE TABLE IF NOT EXISTS sushilog(source TEXT, repository TEXT, rid TEXT, date TEXT, metric_type TEXT, count INT, PRIMARY KEY(source, repository, rid, date, metric_type));";
            this.stmtHive.executeUpdate(sqlCreateTableSushiLog);
            String sqlcreateRuleSushiLog = "CREATE OR REPLACE RULE ignore_duplicate_inserts AS  ON INSERT TO sushilog  WHERE (EXISTS ( SELECT sushilog.source, sushilog.repository,sushilog.rid, sushilog.date FROM sushilog WHERE sushilog.source = new.source AND sushilog.repository = new.repository AND sushilog.rid = new.rid AND sushilog.date = new.date AND sushilog.metric_type = new.metric_type)) DO INSTEAD NOTHING;";
            this.stmtHive.executeUpdate(sqlcreateRuleSushiLog);
            String createSushiIndex = "create index if not exists sushilog_duplicates on sushilog(source, repository, rid, date, metric_type);";
            this.stmtHive.executeUpdate(createSushiIndex);
            this.stmtHive.close();
            ConnectDB.getHiveConnection().close();
            logger.info("Sushi Tables Created");
        }
        catch (Exception e) {
            logger.error("Failed to create tables: " + e);
            throw new Exception("Failed to create tables: " + e.toString(), e);
        }
    }

    public void processSarc() throws Exception {
        Statement stmt = ConnectDB.getHiveConnection().createStatement();
        ConnectDB.getHiveConnection().setAutoCommit(false);
        logger.info("Creating sarc_downloads_stats_tmp table");
        String createDownloadsStats = "CREATE TABLE IF NOT EXISTS " + ConnectDB.getUsageStatsDBSchema() + ".sarc_downloads_stats_tmp (`source` string, `repository_id` string, `result_id` string, `date`\tstring, `count` bigint,\t`openaire`\tbigint)";
        stmt.executeUpdate(createDownloadsStats);
        logger.info("Created sarc_downloads_stats_tmp table");
        logger.info("Inserting into sarc_downloads_stats_tmp");
        String insertSarcStats = "INSERT INTO " + ConnectDB.getUsageStatsDBSchema() + ".sarc_downloads_stats_tmp SELECT s.source, d.id AS repository_id, ro.id as result_id, CONCAT(CAST(YEAR(`date`) AS STRING), '/', LPAD(CAST(MONTH(`date`) AS STRING), 2, '0')) AS `date`, s.count, '0' FROM " + ConnectDB.getUsageRawDataDBSchema() + ".sushilog s, " + ConnectDB.getStatsDBSchema() + ".datasource_oids d, " + ConnectDB.getStatsDBSchema() + ".result_pids ro WHERE d.oid LIKE CONCAT('%', s.repository, '%') AND d.id like CONCAT('%', 'sarcservicod', '%') AND s.rid=ro.pid AND ro.type='Digital Object Identifier' AND s.metric_type='ft_total' AND s.source='SARC-OJS'";
        stmt.executeUpdate(insertSarcStats);
        logger.info("Inserted into sarc_downloads_stats_tmp");
        stmt.close();
    }
}

