/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.stats;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import java.util.HashMap;
import java.util.Optional;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinalizeDB {
    private static final Logger log = LoggerFactory.getLogger(FinalizeDB.class);
    private final ArgumentApplicationParser parser;

    public FinalizeDB(ArgumentApplicationParser parser) {
        this.parser = parser;
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < args.length - 1; ++i) {
            if (!args[i].startsWith("--")) continue;
            params.put(args[i].substring(2), args[++i]);
        }
        String sourceDb = (String)params.get("stats_db_name");
        String shadowDb = (String)params.get("stats_db_shadow_name");
        Boolean isSparkSessionManaged = Optional.ofNullable(params.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        SparkConf conf = new SparkConf();
        conf.set("hive.metastore.uris", (String)params.get("hiveMetastoreUris"));
        String sql = String.format("DROP DATABASE IF EXISTS %s CASCADE;/*EOS*/CREATE DATABASE %s;/*EOS*/", shadowDb, shadowDb);
        SparkSessionSupport.runWithSparkHiveSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            for (String statement : sql.split(";\\s*/\\*\\s*EOS\\s*\\*/\\s*")) {
                FinalizeDB.executeStatement(spark, statement);
            }
            StringBuffer buffer = new StringBuffer();
            spark.sql("SHOW TABLES IN " + sourceDb).collectAsList().forEach(row -> {
                String tableName = row.getString(1);
                buffer.append(String.format("CREATE VIEW %s.%s AS SELECT * FROM %s.%s;/*EOS*/", shadowDb, tableName, sourceDb, tableName));
            });
            String viewStatements = buffer.toString();
            for (String statement : viewStatements.split(";\\s*/\\*\\s*EOS\\s*\\*/\\s*")) {
                FinalizeDB.executeStatement(spark, statement);
            }
        });
    }

    private static void executeStatement(SparkSession spark, String statement) {
        log.info("executing: {}", (Object)statement);
        long startTime = System.currentTimeMillis();
        try {
            spark.sql(statement).show();
        }
        catch (Exception e) {
            log.error("Error executing statement: {}", (Object)statement, (Object)e);
            System.err.println("Error executing statement: " + statement + "\n" + e);
            throw e;
        }
        log.info("executed in {}", (Object)DurationFormatUtils.formatDuration((long)(System.currentTimeMillis() - startTime), (String)"HH:mm:ss.S"));
    }
}

