/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.common.app;

import com.google.common.collect.Lists;
import io.micrometer.core.instrument.ImmutableTag;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.annotation.PostConstruct;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.ClassPathResource;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;

public abstract class AbstractDnetApp {
    @Value(value="pom.xml")
    private ClassPathResource pom;
    private static final Logger log = LoggerFactory.getLogger(AbstractDnetApp.class);

    @PostConstruct
    public void init() {
        MavenXpp3Reader reader = new MavenXpp3Reader();
        try {
            Model model = reader.read((Reader)new InputStreamReader(this.pom.getInputStream()));
            log.info(String.format("registering metric for %s", model.getArtifactId()));
            ImmutableTag tag1 = new ImmutableTag("component", model.getGroupId() + ":" + model.getArtifactId());
            Metrics.gauge((String)"micrometer_info", (Iterable)Lists.newArrayList((Object[])new Tag[]{tag1}), (Number)1);
        }
        catch (IOException | XmlPullParserException e) {
            log.error("Error registering metric", e);
        }
    }

    @Bean
    public Docket newSwaggerDocket() {
        log.info("Initializing SWAGGER...");
        Docket docket = new Docket(DocumentationType.SWAGGER_2);
        this.configSwagger(docket);
        return docket;
    }

    protected abstract void configSwagger(Docket var1);
}

