package eu.dnetlib.common.metrics;

import javax.annotation.PostConstruct;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;

import io.micrometer.core.instrument.Metrics;

public abstract class MetricInfo implements BeanNameAware {

	private static final Log log = LogFactory.getLog(MetricInfo.class);

	private String beanName;

	abstract public double obtainValue();

	public String getBeanName() {
		return beanName;
	}

	@Override
	public void setBeanName(final String beanName) {
		this.beanName = beanName;
	}

	@PostConstruct
	public void register() {
		log.info("Prometheus - new metric registered: " + getBeanName());
		Metrics.gauge(getBeanName(), this, o -> obtainValue());
	}

}
