/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.common.metrics;

import eu.dnetlib.common.metrics.MetricInfo;
import io.prometheus.client.GaugeMetricFamily;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MetricUtils {
    @Autowired(required=false)
    private Map<String, MetricInfo> kpiMetrics;
    private static final Log log = LogFactory.getLog(MetricUtils.class);

    @PostConstruct
    public void registerToMainEndpoint() {
        if (this.kpiMetrics != null) {
            log.info((Object)("KPI METRICS REGISTERED: " + StringUtils.join(this.kpiMetrics.keySet(), (String)", ")));
        }
    }

    public String output(String contentType) {
        try {
            ArrayList samples = new ArrayList();
            if (this.kpiMetrics != null) {
                this.kpiMetrics.forEach((k, v) -> samples.add(new GaugeMetricFamily(k, "", v.obtainValue())));
            }
            StringWriter writer = new StringWriter();
            TextFormat.writeFormat((String)contentType, (Writer)writer, Collections.enumeration(samples));
            return ((Object)writer).toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Writing metrics failed", e);
        }
    }
}

