/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.common.utils.mail;

import eu.dnetlib.common.exceptions.DnetException;
import eu.dnetlib.common.utils.mail.EmailMessage;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import org.apache.commons.lang3.StringUtils;

public class EmailFactory {
    private String smtpHost = "localhost";
    private int smtpPort = 587;
    private String smtpUser = null;
    private String smtpPassword = "";

    public EmailMessage prepareEmail(String subject, String content, String fromMail, String fromName, String to, String ... ccs) throws DnetException {
        Session session = Session.getInstance((Properties)this.obtainProperties(), (Authenticator)this.obtainAuthenticator());
        try {
            return new EmailMessage(session, subject, content, fromMail, fromName, to, ccs);
        }
        catch (Exception e) {
            throw new DnetException("Error preparing mail message", e);
        }
    }

    private Properties obtainProperties() {
        Properties p = new Properties();
        p.put("mail.transport.protocol", "smtp");
        p.put("mail.smtp.host", this.getSmtpHost());
        p.put("mail.smtp.port", (Object)this.getSmtpPort());
        p.put("mail.smtp.auth", Boolean.toString(StringUtils.isNotBlank((CharSequence)this.getSmtpUser())));
        return p;
    }

    private Authenticator obtainAuthenticator() {
        if (StringUtils.isBlank((CharSequence)this.getSmtpUser())) {
            return null;
        }
        return new Authenticator(){
            private final PasswordAuthentication authentication;
            {
                this.authentication = new PasswordAuthentication(EmailFactory.this.getSmtpUser(), EmailFactory.this.getSmtpPassword());
            }

            protected PasswordAuthentication getPasswordAuthentication() {
                return this.authentication;
            }
        };
    }

    public String getSmtpHost() {
        return this.smtpHost;
    }

    public void setSmtpHost(String smtpHost) {
        this.smtpHost = smtpHost;
    }

    public int getSmtpPort() {
        return this.smtpPort;
    }

    public void setSmtpPort(int smtpPort) {
        this.smtpPort = smtpPort;
    }

    public String getSmtpUser() {
        return this.smtpUser;
    }

    public void setSmtpUser(String smtpUser) {
        this.smtpUser = smtpUser;
    }

    public String getSmtpPassword() {
        return this.smtpPassword;
    }

    public void setSmtpPassword(String smtpPassword) {
        this.smtpPassword = smtpPassword;
    }
}

