/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.broker.common.subscriptions;

import eu.dnetlib.broker.common.elasticsearch.Event;
import eu.dnetlib.broker.common.subscriptions.ConditionOperator;
import eu.dnetlib.broker.common.subscriptions.ConditionParams;
import eu.dnetlib.broker.common.utils.DateParser;
import eu.dnetlib.broker.common.utils.MapValueType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.search.MatchQuery;

public class MapCondition {
    private static final Log log = LogFactory.getLog(MapCondition.class);
    private String field;
    private MapValueType fieldType;
    private ConditionOperator operator;
    private List<ConditionParams> listParams = new ArrayList<ConditionParams>();

    public MapCondition() {
    }

    public MapCondition(String field, MapValueType fieldType, ConditionOperator operator, List<ConditionParams> listParams) {
        this.field = field;
        this.fieldType = fieldType;
        this.operator = operator;
        this.listParams = listParams;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public MapValueType getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(MapValueType fieldType) {
        this.fieldType = fieldType;
    }

    public ConditionOperator getOperator() {
        return this.operator;
    }

    public void setOperator(ConditionOperator operator) {
        this.operator = operator;
    }

    public List<ConditionParams> getListParams() {
        return this.listParams;
    }

    public void setListParams(List<ConditionParams> listParams) {
        this.listParams = listParams;
    }

    public boolean verifyEvent(Event event) {
        Object val = event.getMap().get(this.field);
        return this.getListParams().stream().anyMatch(cp -> {
            try {
                switch (this.fieldType) {
                    case STRING: {
                        return cp.verify(val.toString(), this.operator);
                    }
                    case INTEGER: {
                        return cp.verify(val instanceof Long ? (double)((Long)val).longValue() : (double)NumberUtils.toInt((String)val.toString()), this.operator);
                    }
                    case FLOAT: {
                        return cp.verify(val instanceof Double ? (Double)val : NumberUtils.toDouble((String)val.toString()), this.operator);
                    }
                    case BOOLEAN: {
                        return cp.verify(val instanceof Boolean ? ((Boolean)val).booleanValue() : val.toString().equalsIgnoreCase("true"), this.operator);
                    }
                    case DATE: {
                        return cp.verify(val instanceof Date ? (Date)val : DateParser.parse(val.toString()), this.operator);
                    }
                    case LIST_STRING: {
                        return ((List)val).stream().map(Object::toString).anyMatch(s -> cp.verify((String)s, this.operator));
                    }
                    case LIST_DATE: {
                        return ((List)val).stream().map(o -> o instanceof Date ? (Date)o : DateParser.parse(o.toString())).anyMatch(s -> cp.verify((Date)s, this.operator));
                    }
                    case LIST_INTEGER: {
                        return ((List)val).stream().map(Object::toString).map(NumberUtils::toInt).anyMatch(n -> cp.verify(n.intValue(), this.operator));
                    }
                    case LIST_FLOAT: {
                        return ((List)val).stream().map(Object::toString).map(NumberUtils::toDouble).anyMatch(n -> cp.verify((double)n, this.operator));
                    }
                }
            }
            catch (Throwable e) {
                log.error((Object)("Error verifying condition " + this + " on event: " + event), e);
            }
            return false;
        });
    }

    public QueryBuilder asQueryBuilder() {
        if (this.listParams == null || this.listParams.isEmpty()) {
            return null;
        }
        if (this.operator == ConditionOperator.RANGE) {
            if (this.listParams.size() == 1) {
                return this.createSimpleRangeOperator(this.listParams.get(0));
            }
            return this.createListRangeOperator(this.listParams);
        }
        if (this.listParams.size() == 1) {
            return this.createSimpleOperator(this.listParams.get(0));
        }
        return this.createListOperator(this.listParams);
    }

    private QueryBuilder createSimpleOperator(ConditionParams p) {
        if (StringUtils.isNotBlank((CharSequence)p.getValue())) {
            return QueryBuilders.matchQuery((String)("map." + this.field), (Object)this.convertToType(p.getValue())).operator(Operator.AND).zeroTermsQuery(MatchQuery.ZeroTermsQuery.ALL);
        }
        return null;
    }

    private QueryBuilder createListOperator(List<ConditionParams> list) {
        BoolQueryBuilder query = QueryBuilders.boolQuery();
        for (ConditionParams p : list) {
            query.should((QueryBuilder)QueryBuilders.matchQuery((String)("map." + this.field), (Object)this.convertToType(p.getValue())).operator(Operator.AND).zeroTermsQuery(MatchQuery.ZeroTermsQuery.ALL));
        }
        return query;
    }

    private QueryBuilder createSimpleRangeOperator(ConditionParams p) {
        if (StringUtils.isNotBlank((CharSequence)p.getValue()) || StringUtils.isNotBlank((CharSequence)p.getOtherValue())) {
            return QueryBuilders.rangeQuery((String)("map." + this.field)).from(this.convertToType(p.getValue())).to(this.convertToType(p.getOtherValue()));
        }
        return null;
    }

    private QueryBuilder createListRangeOperator(List<ConditionParams> list) {
        BoolQueryBuilder query = QueryBuilders.boolQuery();
        for (ConditionParams p : list) {
            query.should((QueryBuilder)QueryBuilders.rangeQuery((String)("map." + this.field)).from(this.convertToType(p.getValue())).to(this.convertToType(p.getOtherValue())));
        }
        return query;
    }

    private Object convertToType(String s) {
        switch (this.fieldType) {
            case STRING: 
            case LIST_STRING: {
                return s;
            }
            case INTEGER: 
            case LIST_INTEGER: {
                return NumberUtils.toLong((String)s, (long)0L);
            }
            case FLOAT: 
            case LIST_FLOAT: {
                return NumberUtils.toDouble((String)s, (double)0.0);
            }
            case DATE: 
            case LIST_DATE: {
                return DateParser.parse(s).getTime();
            }
            case BOOLEAN: 
            case LIST_BOOLEAN: {
                return "true".equalsIgnoreCase(s);
            }
        }
        return null;
    }

    public String toString() {
        return String.format("[ %s %s %s ]", new Object[]{this.field, this.operator, this.listParams});
    }
}

