/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.broker.common.subscriptions;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import eu.dnetlib.broker.common.elasticsearch.Event;
import eu.dnetlib.broker.common.subscriptions.MapCondition;
import eu.dnetlib.broker.common.subscriptions.NotificationFrequency;
import eu.dnetlib.broker.common.subscriptions.NotificationMode;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity(name="subscriptions")
@Table(name="subscriptions")
public class Subscription {
    @Id
    @Column(name="subscriptionid")
    private String subscriptionId;
    @Column(name="subscriber", nullable=false)
    private String subscriber;
    @Column(name="topic", nullable=false)
    private String topic;
    @Column(name="frequency", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private NotificationFrequency frequency;
    @Column(name="mode", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private NotificationMode mode;
    @Column(name="lastNotificationDate", nullable=true)
    private Date lastNotificationDate;
    @Column(name="creationDate", nullable=false, columnDefinition="timestamp default '2018-01-01 00:00:00'")
    private Date creationDate;
    @Column(name="conditions", nullable=true)
    private String conditions;

    public Subscription() {
    }

    public Subscription(String subscriptionId, String subscriber, String topic, NotificationFrequency frequency, NotificationMode mode, Date lastNotificationDate, Date creationDate, List<MapCondition> conditions) {
        this(subscriptionId, subscriber, topic, frequency, mode, lastNotificationDate, creationDate, new Gson().toJson(conditions));
    }

    public Subscription(String subscriptionId, String subscriber, String topic, NotificationFrequency frequency, NotificationMode mode, Date lastNotificationDate, Date creationDate, String conditions) {
        this.subscriptionId = subscriptionId;
        this.subscriber = subscriber;
        this.topic = topic;
        this.frequency = frequency;
        this.mode = mode;
        this.lastNotificationDate = lastNotificationDate;
        this.creationDate = creationDate;
        this.conditions = conditions;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public String getSubscriber() {
        return this.subscriber;
    }

    public void setSubscriber(String subscriber) {
        this.subscriber = subscriber;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public NotificationFrequency getFrequency() {
        return this.frequency;
    }

    public void setFrequency(NotificationFrequency frequency) {
        this.frequency = frequency;
    }

    public NotificationMode getMode() {
        return this.mode;
    }

    public void setMode(NotificationMode mode) {
        this.mode = mode;
    }

    public Date getLastNotificationDate() {
        return this.lastNotificationDate;
    }

    public void setLastNotificationDate(Date lastNotificationDate) {
        this.lastNotificationDate = lastNotificationDate;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public String getConditions() {
        return this.conditions;
    }

    public List<MapCondition> getConditionsAsList() {
        return (List)new Gson().fromJson(this.conditions, new TypeToken<List<MapCondition>>(){}.getType());
    }

    public void setConditions(String conditions) {
        this.conditions = conditions;
    }

    public static boolean isReady(Subscription s) {
        if (s == null || s.getFrequency() == NotificationFrequency.never) {
            return false;
        }
        if (s.getFrequency() == NotificationFrequency.realtime) {
            return true;
        }
        if (s.getLastNotificationDate() == null) {
            return true;
        }
        long diff = new Date().getTime() - s.getLastNotificationDate().getTime();
        return s.getFrequency() == NotificationFrequency.daily && diff >= TimeUnit.DAYS.toMillis(1L) || s.getFrequency() == NotificationFrequency.weekly && diff >= TimeUnit.DAYS.toMillis(7L) || s.getFrequency() == NotificationFrequency.monthly && diff >= TimeUnit.DAYS.toMillis(30L);
    }

    public String toString() {
        return new Gson().toJson((Object)this);
    }

    public boolean verifyEventConditions(Event event) {
        for (MapCondition cond : this.getConditionsAsList()) {
            if (cond.verifyEvent(event)) continue;
            return false;
        }
        return true;
    }
}

