package eu.dnetlib.broker.common.elasticsearch;

import java.util.Map;

import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

@Document(indexName = "#{@elasticSearchProperties.getSuggestionEventsIndexName()}")
public class SuggestionEvent implements Event {

	public static final String PREFIX = "event-";

	@Id
	private String eventId;

	@Field(type = FieldType.Keyword)
	private String producerId;

	@Field(type = FieldType.Keyword)
	private String topic;

	@Field(type = FieldType.Text)
	private String payload;

	@Field(type = FieldType.Long)
	private Long creationDate;

	@Field(type = FieldType.Long)
	private Long expiryDate;

	@Field(type = FieldType.Boolean)
	private boolean instantMessage;

	@Field(type = FieldType.Nested)
	private Map<String, Object> map;

	@Override
	public String getProducerId() {
		return producerId;
	}

	public void setProducerId(final String producerId) {
		this.producerId = producerId;
	}

	@Override
	public String getEventId() {
		return eventId;
	}

	public void setEventId(final String eventId) {
		this.eventId = eventId;
	}

	@Override
	public String getTopic() {
		return topic;
	}

	public void setTopic(final String topic) {
		this.topic = topic;
	}

	@Override
	public String getPayload() {
		return payload;
	}

	public void setPayload(final String payload) {
		this.payload = payload;
	}

	@Override
	public Long getCreationDate() {
		return creationDate;
	}

	public void setCreationDate(final Long creationDate) {
		this.creationDate = creationDate;
	}

	@Override
	public Long getExpiryDate() {
		return expiryDate;
	}

	public void setExpiryDate(final Long expiryDate) {
		this.expiryDate = expiryDate;
	}

	@Override
	public boolean isInstantMessage() {
		return instantMessage;
	}

	public void setInstantMessage(final boolean instantMessage) {
		this.instantMessage = instantMessage;
	}

	@Override
	public Map<String, Object> getMap() {
		return map;
	}

	public void setMap(final Map<String, Object> map) {
		this.map = map;
	}

}
