package eu.dnetlib.broker.common.properties;

import javax.validation.constraints.NotNull;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component("elasticSearchProperties")
@ConfigurationProperties(prefix = "lbs.elastic")
public class ElasticSearchProperties {

	@NotNull
	private String clusterNodes;
	@NotNull
	private String homepage;
	@NotNull
	private String suggestionEventsIndexName;
	@NotNull
	private String suggestionNotificationsIndexName;
	@NotNull
	private String alertNotificationsIndexName;
	@NotNull
	private long connectionTimeout;
	@NotNull
	private long socketTimeout;

	public String getClusterNodes() {
		return clusterNodes;
	}

	public void setClusterNodes(final String clusterNodes) {
		this.clusterNodes = clusterNodes;
	}

	public String getHomepage() {
		return homepage;
	}

	public void setHomepage(final String homepage) {
		this.homepage = homepage;
	}

	public String getSuggestionEventsIndexName() {
		return suggestionEventsIndexName;
	}

	public void setSuggestionEventsIndexName(final String suggestionEventsIndexName) {
		this.suggestionEventsIndexName = suggestionEventsIndexName;
	}

	public String getSuggestionNotificationsIndexName() {
		return suggestionNotificationsIndexName;
	}

	public void setSuggestionNotificationsIndexName(final String suggestionNotificationsIndexName) {
		this.suggestionNotificationsIndexName = suggestionNotificationsIndexName;
	}

	public String getAlertNotificationsIndexName() {
		return alertNotificationsIndexName;
	}

	public void setAlertNotificationsIndexName(final String alertNotificationsIndexName) {
		this.alertNotificationsIndexName = alertNotificationsIndexName;
	}

	public long getConnectionTimeout() {
		return connectionTimeout;
	}

	public void setConnectionTimeout(final long connectionTimeout) {
		this.connectionTimeout = connectionTimeout;
	}

	public long getSocketTimeout() {
		return socketTimeout;
	}

	public void setSocketTimeout(final long socketTimeout) {
		this.socketTimeout = socketTimeout;
	}

}
