package eu.dnetlib.broker.common.stats;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Table;

@Entity
@Table(name = "oa_datasource_stats")
@IdClass(OpenaireDsStatPK.class)
public class OpenaireDsStat implements Serializable {

	/**
	 *
	 */
	private static final long serialVersionUID = 6498718759303687338L;

	@Id
	@Column(name = "id", nullable = false)
	private String dsId;

	@Id
	@Column(name = "topic", nullable = false)
	private String topic;

	@Column(name = "name", nullable = false)
	private String dsName;

	@Column(name = "type", nullable = false)
	private String dsType;

	@Column(name = "size", nullable = false)
	private Long size = 0L;

	public String getDsId() {
		return dsId;
	}

	public void setDsId(final String dsId) {
		this.dsId = dsId;
	}

	public String getTopic() {
		return topic;
	}

	public void setTopic(final String topic) {
		this.topic = topic;
	}

	public String getDsName() {
		return dsName;
	}

	public void setDsName(final String dsName) {
		this.dsName = dsName;
	}

	public String getDsType() {
		return dsType;
	}

	public void setDsType(final String dsType) {
		this.dsType = dsType;
	}

	public Long getSize() {
		return size;
	}

	public void setSize(final Long size) {
		this.size = size;
	}

}
