/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.dsm;

import eu.dnetlib.enabling.datasources.common.Api;
import eu.dnetlib.enabling.datasources.common.Datasource;
import eu.dnetlib.enabling.datasources.common.DsmException;
import eu.dnetlib.enabling.datasources.common.DsmForbiddenException;
import eu.dnetlib.enabling.datasources.common.DsmNotFoundException;
import eu.dnetlib.openaire.common.ISClient;
import eu.dnetlib.openaire.community.CommunityClient;
import eu.dnetlib.openaire.dsm.dao.DatasourceDao;
import eu.dnetlib.openaire.dsm.dao.MongoLoggerClient;
import eu.dnetlib.openaire.dsm.dao.ResponseUtils;
import eu.dnetlib.openaire.dsm.dao.VocabularyClient;
import eu.dnetlib.openaire.dsm.dao.utils.DsmMappingUtils;
import eu.dnetlib.openaire.dsm.domain.AggregationHistoryResponse;
import eu.dnetlib.openaire.dsm.domain.ApiDetails;
import eu.dnetlib.openaire.dsm.domain.ApiDetailsResponse;
import eu.dnetlib.openaire.dsm.domain.DatasourceDetailResponse;
import eu.dnetlib.openaire.dsm.domain.DatasourceDetails;
import eu.dnetlib.openaire.dsm.domain.DatasourceDetailsUpdate;
import eu.dnetlib.openaire.dsm.domain.DatasourceSnippetResponse;
import eu.dnetlib.openaire.dsm.domain.RegisteredDatasourceInfo;
import eu.dnetlib.openaire.dsm.domain.RequestFilter;
import eu.dnetlib.openaire.dsm.domain.RequestSort;
import eu.dnetlib.openaire.dsm.domain.RequestSortOrder;
import eu.dnetlib.openaire.dsm.domain.SimpleResponse;
import eu.dnetlib.openaire.dsm.domain.db.ApiDbEntry;
import eu.dnetlib.openaire.dsm.domain.db.DatasourceDbEntry;
import eu.dnetlib.openaire.vocabularies.Country;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.domain.Page;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"openaire.exporter.enable.dsm"}, havingValue="true")
public class DsmCore {
    private static final Log log = LogFactory.getLog(DsmCore.class);
    @Autowired
    private MongoLoggerClient mongoLoggerClient;
    @Autowired
    private ISClient isClient;
    @Autowired
    private VocabularyClient vocabularyClient;
    @Autowired
    private DatasourceDao<DatasourceDbEntry, ApiDbEntry> dsDao;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private CommunityClient communityClient;

    public List<Country> listCountries() throws DsmException {
        try {
            return this.dsDao.listCountries();
        }
        catch (Throwable e) {
            log.error((Object)"error listing countries", e);
            throw e;
        }
    }

    public DatasourceDetailResponse searchDsDetails(RequestSort requestSortBy, RequestSortOrder order, RequestFilter requestFilter, int page, int size) throws DsmException {
        try {
            Page dsPage = this.dsDao.search(requestSortBy, order, requestFilter, page, size);
            return ResponseUtils.detailsResponse((List)dsPage.map(d -> DsmMappingUtils.asDetails((DatasourceDbEntry)d)).getContent(), (long)dsPage.getTotalElements());
        }
        catch (Throwable e) {
            log.error((Object)"error searching datasources", e);
            throw e;
        }
    }

    public DatasourceSnippetResponse searchSnippet(RequestSort requestSortBy, RequestSortOrder order, RequestFilter requestFilter, int page, int size) throws DsmException {
        try {
            Page dsPage = this.dsDao.search(requestSortBy, order, requestFilter, page, size);
            return ResponseUtils.snippetResponse((List)dsPage.map(DsmMappingUtils::asSnippetExtended).getContent(), (long)dsPage.getTotalElements());
        }
        catch (Throwable e) {
            log.error((Object)"error searching datasources", e);
            throw e;
        }
    }

    public DatasourceSnippetResponse searchRegistered(RequestSort requestSortBy, RequestSortOrder order, RequestFilter requestFilter, int page, int size) throws DsmException {
        try {
            Page dsPage = this.dsDao.searchRegistered(requestSortBy, order, requestFilter, page, size);
            return ResponseUtils.snippetResponse((List)dsPage.map(DsmMappingUtils::asSnippetExtended).getContent(), (long)dsPage.getTotalElements());
        }
        catch (Throwable e) {
            log.error((Object)"error searching datasources", e);
            throw e;
        }
    }

    public List<String> findBaseURLs(RequestFilter requestFilter, int page, int size) throws DsmException {
        try {
            return this.dsDao.findApiBaseURLs(requestFilter, page, size);
        }
        catch (Throwable e) {
            log.error((Object)"error searching datasource base urls", e);
            throw e;
        }
    }

    public ApiDetailsResponse getApis(String dsId) throws DsmException {
        try {
            String eoscType = ((DatasourceDbEntry)this.dsDao.getDs(dsId)).getEoscDatasourceType();
            List apis = this.dsDao.getApis(dsId);
            List api = apis.stream().map(DsmMappingUtils::asDetails).map(a -> a.setEoscDatasourceType(eoscType)).collect(Collectors.toList());
            return ResponseUtils.apiResponse(api, (long)api.size());
        }
        catch (Throwable e) {
            log.error((Object)String.format("error searching datasource api %s", dsId), e);
            throw e;
        }
    }

    public void setManaged(String dsId, boolean managed) throws DsmException {
        log.info((Object)String.format("updated ds '%s' managed with '%s'", dsId, managed));
        this.dsDao.setManaged(dsId, managed);
    }

    public boolean isManaged(String dsId) throws DsmException {
        return this.dsDao.isManaged(dsId);
    }

    public boolean exist(DatasourceDetails d) throws DsmException {
        return this.dsDao.existDs(d.getId());
    }

    public void save(DatasourceDetails d) throws DsmException {
        try {
            this.dsDao.saveDs((Datasource)DsmMappingUtils.asDbEntry((DatasourceDetails)d));
        }
        catch (Throwable e) {
            log.error((Object)ExceptionUtils.getStackTrace((Throwable)e));
            throw e;
        }
    }

    public void updateDatasource(DatasourceDetailsUpdate d) throws DsmException, DsmNotFoundException {
        try {
            DatasourceDbEntry ds = (DatasourceDbEntry)this.dsDao.getDs(d.getId());
            if (ds == null) {
                throw new DsmNotFoundException(String.format("ds '%s' does not exist", d.getId()));
            }
            DatasourceDbEntry update = DsmMappingUtils.asDbEntry((DatasourceDetailsUpdate)d);
            if (d.getIdentities() != null) {
                HashSet identities = new HashSet(Stream.of(update.getIdentities(), ds.getIdentities()).flatMap(Collection::stream).collect(Collectors.toMap(i -> i.getIssuertype() + i.getPid(), Function.identity(), (i1, i2) -> i1)).values());
                DsmMappingUtils.copyNonNullProperties((Object)update, (Object)ds);
                ds.setIdentities(identities);
            } else {
                DsmMappingUtils.copyNonNullProperties((Object)update, (Object)ds);
            }
            this.dsDao.saveDs((Datasource)ds);
        }
        catch (Throwable e) {
            log.error((Object)ExceptionUtils.getStackTrace((Throwable)e));
            throw e;
        }
    }

    public void deleteDs(String dsId) throws DsmException {
        log.info((Object)String.format("deleted datasource '%s'", dsId));
        this.dsDao.deleteDs(dsId);
    }

    public void updateApiOaiSet(String dsId, String apiId, String oaiSet) throws DsmException {
        this.dsDao.upsertApiOaiSet(apiId, oaiSet);
    }

    public void updateApiBaseurl(String dsId, String apiId, String baseUrl) throws DsmException {
        log.info((Object)String.format("updated api '%s' baseurl with '%s'", apiId, baseUrl));
        this.dsDao.updateApiBaseUrl(apiId, baseUrl);
    }

    public void updateApiCompatibility(String dsId, String apiId, String compliance, boolean override) throws DsmException {
        log.info((Object)String.format("updated api '%s' compliance with '%s'", apiId, compliance));
        this.dsDao.updateCompliance(null, apiId, compliance, override);
    }

    public void addApi(ApiDetails api) throws DsmException {
        if (StringUtils.isBlank((CharSequence)api.getId())) {
            api.setId(DsmMappingUtils.createId((ApiDetails)api));
            log.info((Object)String.format("missing api id, created '%s'", api.getId()));
        }
        this.dsDao.addApi((Api)DsmMappingUtils.asDbEntry((ApiDetails)api));
    }

    public void deleteApi(String apiId) throws DsmForbiddenException, DsmNotFoundException {
        this.dsDao.deleteApi(null, apiId);
    }

    public void dropCaches() {
        this.mongoLoggerClient.dropCache();
        this.isClient.dropCache();
        this.vocabularyClient.dropCache();
        this.communityClient.dropCache();
    }

    public SimpleResponse<?> searchRecentRegistered(int size) throws Throwable {
        try {
            String sql = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/openaire/sql/recent_registered_datasources.sql.st"), (Charset)Charset.defaultCharset());
            List list = this.jdbcTemplate.query(sql, (RowMapper)BeanPropertyRowMapper.newInstance(RegisteredDatasourceInfo.class), new Object[]{size});
            return ResponseUtils.simpleResponse((List)list);
        }
        catch (Throwable e) {
            log.error((Object)"error searching recent datasources", e);
            throw e;
        }
    }

    public Long countRegisteredAfter(String fromDate, String typeFilter) throws Throwable {
        try {
            if (StringUtils.isNotBlank((CharSequence)typeFilter)) {
                String sql = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/openaire/sql/recent_registered_datasources_fromDate_typology.st.sql"), (Charset)Charset.defaultCharset());
                return (Long)this.jdbcTemplate.queryForObject(sql, Long.class, new Object[]{fromDate, typeFilter + "%"});
            }
            String sql = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/openaire/sql/recent_registered_datasources_fromDate.st.sql"), (Charset)Charset.defaultCharset());
            return (Long)this.jdbcTemplate.queryForObject(sql, Long.class, new Object[]{fromDate});
        }
        catch (Throwable e) {
            log.error((Object)"error searching recent datasources", e);
            throw e;
        }
    }

    public AggregationHistoryResponse aggregationhistory(String dsId) throws DsmException {
        List history = this.mongoLoggerClient.getAggregationHistory(dsId);
        AggregationHistoryResponse rsp = new AggregationHistoryResponse(history);
        rsp.setHeader(ResponseUtils.header((long)history.size()));
        return rsp;
    }
}

