/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.project.dao;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import eu.dnetlib.DnetOpenaireExporterProperties;
import eu.dnetlib.openaire.project.dao.JdbcApiDao;
import eu.dnetlib.openaire.project.dao.ProjectTsvRepository;
import eu.dnetlib.openaire.project.dao.ValueCleaner;
import eu.dnetlib.openaire.project.domain.Project;
import eu.dnetlib.openaire.project.domain.db.ProjectDetails;
import eu.dnetlib.openaire.project.domain.db.ProjectTsv;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.sql.DataSource;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"openaire.exporter.enable.project"}, havingValue="true")
public class JdbcApiDaoImpl
implements JdbcApiDao {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    private static final Log log = LogFactory.getLog(JdbcApiDaoImpl.class);
    @Autowired
    private DnetOpenaireExporterProperties config;
    @Autowired
    private DataSource dataSource;
    @Autowired
    private ProjectTsvRepository projectTsvRepository;

    @Cacheable(value={"fundingpath-ids"})
    public Map<String, String> readFundingpathIds() {
        log.debug((Object)"loading funding ids");
        String sql = "SELECT id FROM fundingpaths";
        HashSet ids = Sets.newHashSet();
        try (Connection con = this.getConn();
             PreparedStatement stm = this.getStm("SELECT id FROM fundingpaths", con);
             ResultSet rs = this.getRs(stm);){
            while (rs.next()) {
                ids.add(rs.getString("id"));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        log.debug((Object)String.format("loaded %s funding ids", ids.size()));
        HashMap res = Maps.newHashMap();
        Splitter sp = Splitter.on((String)"::").trimResults();
        ids.stream().filter(s -> sp.splitToList((CharSequence)s).size() < 3).forEach(s -> res.put(StringUtils.substringAfterLast((String)s, (String)"::").toUpperCase(), s));
        res.put("FP7", "ec__________::EC::FP7");
        res.put("H2020", "ec__________::EC::H2020");
        log.debug((Object)String.format("processed %s funding ids", res.size()));
        res.forEach((k, v) -> log.debug((Object)String.format("%s : '%s'", k, v)));
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processProjectDetails(OutputStream outputStream, String format, Boolean compress) throws IOException {
        OutputStream out = this.getOutputStream((OutputStream)new BufferedOutputStream(outputStream), compress);
        try {
            String sql = "SELECT * FROM project_details";
            try (Connection con = this.getConn();
                 PreparedStatement stm = this.getStm("SELECT * FROM project_details", con);
                 ResultSet rs = this.getRs(stm);){
                while (rs.next()) {
                    try {
                        switch (format) {
                            case "csv": {
                                out.write(this.getProjectDetails(rs).asCSV().getBytes(UTF8));
                                break;
                            }
                            case "json": {
                                out.write(this.getProjectDetails(rs).asJson().getBytes(UTF8));
                            }
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                        return;
                    }
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (out instanceof GZIPOutputStream) {
                ((GZIPOutputStream)out).finish();
            }
            out.close();
        }
    }

    private OutputStream getOutputStream(OutputStream outputStream, Boolean compress) throws IOException {
        if (compress != null && compress.booleanValue()) {
            return new GZIPOutputStream(outputStream);
        }
        return outputStream;
    }

    private ProjectDetails getProjectDetails(ResultSet rs) throws SQLException {
        return new ProjectDetails().setProjectId(rs.getString("projectid")).setAcronym(rs.getString("acronym")).setCode(rs.getString("code")).setJsonextrainfo(rs.getString("jsonextrainfo")).setFundingPath(this.asList(rs.getArray("fundingpath")));
    }

    private String[] asList(Array value) throws SQLException {
        if (value != null) {
            List<Object> list = Arrays.asList((Object[])value.getArray());
            return (String[])list.stream().map(o -> o != null ? o.toString() : null).toArray(String[]::new);
        }
        return new String[0];
    }

    public void processTsvRequest(ZipOutputStream out, Boolean article293, String fundingPrefix, String filename) throws IOException {
        out.putNextEntry(new ZipEntry(filename));
        this.writeTsvLine(out, Splitter.on((String)",").trimResults().splitToList((CharSequence)this.config.getProject().getTsvFields()));
        this.queryForTsv(fundingPrefix, article293).forEach(p -> {
            try {
                this.writeTsvLine(out, p.asList());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void writeTsvLine(ZipOutputStream out, List<String> s) throws IOException {
        out.write(Joiner.on((char)'\t').useForNull("").join(s).getBytes(UTF8));
        out.write(10);
    }

    private Iterable<ProjectTsv> queryForTsv(String fundingPrefix, Boolean article293) {
        log.debug((Object)String.format("fundingPrefix:'%s' and oa_mandate_for_datasets:'%s'", fundingPrefix, article293));
        if (article293 != null) {
            return this.projectTsvRepository.findByFundingpathidStartingWithAndOaMandateForDatasetsOrderByAcronym(fundingPrefix, article293.booleanValue());
        }
        return this.projectTsvRepository.findByFundingpathidStartingWithOrderByAcronym(fundingPrefix);
    }

    public void streamProjects(String sql, OutputStream out, String head, StringTemplate projectTemplate, String tail, ValueCleaner cleaner) throws IOException, SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Thread " + Thread.currentThread().getId() + " begin"));
        }
        LocalDateTime start = LocalDateTime.now();
        if (StringUtils.isNotBlank((CharSequence)head)) {
            out.write(head.getBytes(UTF8));
        }
        try (Connection con = this.getConn();
             PreparedStatement stm = this.getStm(sql, con);
             ResultSet rs = this.getRs(stm);){
            while (rs.next()) {
                Project p = new Project().setFunder(cleaner.clean(rs.getString("funder"))).setJurisdiction(cleaner.clean(rs.getString("jurisdiction"))).setFundingpathid(cleaner.clean(rs.getString("fundingpathid"))).setAcronym(cleaner.clean(rs.getString("acronym"))).setTitle(cleaner.clean(rs.getString("title"))).setCode(cleaner.clean(rs.getString("code"))).setStartdate(cleaner.clean(rs.getString("startdate"))).setEnddate(cleaner.clean(rs.getString("enddate")));
                projectTemplate.reset();
                projectTemplate.setAttribute("p", (Object)p);
                out.write(projectTemplate.toString().getBytes(UTF8));
            }
            if (StringUtils.isNotBlank((CharSequence)tail)) {
                out.write(tail.getBytes(UTF8));
            }
            LocalDateTime end = LocalDateTime.now();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Thread " + Thread.currentThread().getId() + " ends, took: " + Duration.between(start, end).toMillis() + " ms"));
            }
        }
    }

    @CacheEvict(cacheNames={"fundingpath-ids"}, allEntries=true)
    @Scheduled(fixedDelayString="${openaire.exporter.cache.ttl}")
    public void dropCache() {
        log.debug((Object)"dropped fundingpath ids cache");
    }

    private Connection getConn() throws SQLException {
        Connection connection = this.dataSource.getConnection();
        connection.setAutoCommit(false);
        return connection;
    }

    private PreparedStatement getStm(String sql, Connection con) throws SQLException {
        PreparedStatement stm = con.prepareStatement(sql, 1003);
        stm.setFetchSize(this.config.getJdbc().getMaxRows());
        return stm;
    }

    private ResultSet getRs(PreparedStatement stm) throws SQLException {
        ResultSet rs = stm.executeQuery();
        rs.setFetchSize(this.config.getJdbc().getMaxRows());
        return rs;
    }
}

