package eu.dnetlib.openaire.dsm.domain;

import java.sql.Date;
import java.util.Set;

import javax.validation.constraints.Email;
import javax.validation.constraints.NotBlank;

import com.fasterxml.jackson.annotation.JsonAutoDetect;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Created by claudio on 12/09/16.
 */
@JsonAutoDetect
@ApiModel(value = "Datasource updatable fields model", description = "provides information about the datasource field that can be updated")
public class DatasourceDetailsUpdate {

	@NotBlank
	@ApiModelProperty(position = 0)
	private String id;

	@NotBlank
	@ApiModelProperty(position = 2)
	private String officialname;

	@NotBlank
	@ApiModelProperty(position = 3)
	private String englishname;

	@ApiModelProperty(position = 4)
	private String websiteurl;

	@ApiModelProperty(position = 5)
	private String logourl;

	@Email
	@ApiModelProperty(position = 6)
	private String contactemail;

	@ApiModelProperty(position = 7)
	private Double latitude;

	@ApiModelProperty(position = 8)
	private Double longitude;

	@ApiModelProperty(position = 9)
	private String timezone;

	@NotBlank
	@ApiModelProperty(position = 13)
	private String eoscDatasourceType;

	@ApiModelProperty(position = 15)
	private String platform;

	@ApiModelProperty(position = 17)
	private String description;

	@Email
	@ApiModelProperty(position = 21)
	private String registeredby;

	@ApiModelProperty(position = 25)
	private Boolean managed;

	@ApiModelProperty(position = 27)
	private Set<IdentitiesDetails> identities;

	@ApiModelProperty(position = 28)
	private Boolean consentTermsOfUse;

	@ApiModelProperty(position = 29)
	private Date consentTermsOfUseDate;

	@ApiModelProperty(position = 29)
	private Date lastConsentTermsOfUseDate;

	@ApiModelProperty(position = 31)
	private Boolean fullTextDownload;

	public String getId() {
		return id;
	}

	public String getOfficialname() {
		return officialname;
	}

	public String getEnglishname() {
		return englishname;
	}

	public String getWebsiteurl() {
		return websiteurl;
	}

	public String getLogourl() {
		return logourl;
	}

	public String getContactemail() {
		return contactemail;
	}

	public Double getLatitude() {
		return latitude;
	}

	public Double getLongitude() {
		return longitude;
	}

	public String getTimezone() {
		return timezone;
	}

	public String getEoscDatasourceType() {
		return eoscDatasourceType;
	}

	public String getPlatform() {
		return platform;
	}

	public String getDescription() {
		return description;
	}

	public String getRegisteredby() {
		return registeredby;
	}

	public Boolean getManaged() {
		return managed;
	}

	public Set<IdentitiesDetails> getIdentities() {
		return identities;
	}

	public DatasourceDetailsUpdate setId(final String id) {
		this.id = id;
		return this;
	}

	public DatasourceDetailsUpdate setOfficialname(final String officialname) {
		this.officialname = officialname;
		return this;
	}

	public DatasourceDetailsUpdate setEnglishname(final String englishname) {
		this.englishname = englishname;
		return this;
	}

	public DatasourceDetailsUpdate setWebsiteurl(final String websiteurl) {
		this.websiteurl = websiteurl;
		return this;
	}

	public DatasourceDetailsUpdate setLogourl(final String logourl) {
		this.logourl = logourl;
		return this;
	}

	public DatasourceDetailsUpdate setContactemail(final String contactemail) {
		this.contactemail = contactemail;
		return this;
	}

	public DatasourceDetailsUpdate setLatitude(final Double latitude) {
		this.latitude = latitude;
		return this;
	}

	public DatasourceDetailsUpdate setLongitude(final Double longitude) {
		this.longitude = longitude;
		return this;
	}

	public DatasourceDetailsUpdate setTimezone(final String timezone) {
		this.timezone = timezone;
		return this;
	}

	public DatasourceDetailsUpdate setEoscDatasourceType(final String eoscDatasourceType) {
		this.eoscDatasourceType = eoscDatasourceType;
		return this;
	}

	public DatasourceDetailsUpdate setPlatform(final String platform) {
		this.platform = platform;
		return this;
	}

	public DatasourceDetailsUpdate setDescription(final String description) {
		this.description = description;
		return this;
	}

	public DatasourceDetailsUpdate setRegisteredby(final String registeredby) {
		this.registeredby = registeredby;
		return this;
	}

	public DatasourceDetailsUpdate setManaged(final Boolean managed) {
		this.managed = managed;
		return this;
	}

	public DatasourceDetailsUpdate setIdentities(final Set<IdentitiesDetails> identities) {
		this.identities = identities;
		return this;
	}

	public Boolean getConsentTermsOfUse() {
		return consentTermsOfUse;
	}

	public DatasourceDetailsUpdate setConsentTermsOfUse(final Boolean consentTermsOfUse) {
		this.consentTermsOfUse = consentTermsOfUse;
		return this;
	}

	public Date getConsentTermsOfUseDate() {
		return consentTermsOfUseDate;
	}

	public DatasourceDetailsUpdate setConsentTermsOfUseDate(final Date consentTermsOfUseDate) {
		this.consentTermsOfUseDate = consentTermsOfUseDate;
		return this;
	}

	public Boolean getFullTextDownload() {
		return fullTextDownload;
	}

	public DatasourceDetailsUpdate setFullTextDownload(final Boolean fullTextDownload) {
		this.fullTextDownload = fullTextDownload;
		return this;
	}

	public Date getLastConsentTermsOfUseDate() {
		return lastConsentTermsOfUseDate;
	}

	public DatasourceDetailsUpdate setLastConsentTermsOfUseDate(final Date lastConsentTermsOfUseDate) {
		this.lastConsentTermsOfUseDate = lastConsentTermsOfUseDate;
		return this;
	}

}
