package eu.dnetlib.openaire.dsm.domain;

import java.util.Date;
import java.util.Set;

import javax.validation.constraints.Email;
import javax.validation.constraints.NotBlank;

import com.fasterxml.jackson.annotation.JsonAutoDetect;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@JsonAutoDetect
@ApiModel(value = "Datasource model", description = "provides extended information about the datasource")
public class DatasourceSnippetExtended {

	@NotBlank
	@ApiModelProperty(position = 0)
	private String id;

	@NotBlank
	@ApiModelProperty(position = 2)
	private String officialname;

	@NotBlank
	@ApiModelProperty(position = 3)
	private String englishname;

	@ApiModelProperty(position = 4)
	private String websiteurl;

	@Email
	@ApiModelProperty(position = 5)
	private String registeredby;

	@ApiModelProperty(position = 6)
	private Date registrationdate;

	@ApiModelProperty(position = 7)
	private String eoscDatasourceType;

	@ApiModelProperty(position = 8)
	private String logoUrl;

	@ApiModelProperty(position = 9)
	private String description;

	@ApiModelProperty(position = 10)
	private Boolean consentTermsOfUse;

	@ApiModelProperty(position = 11)
	private Date consentTermsOfUseDate;

	@ApiModelProperty(position = 12)
	private Date lastConsentTermsOfUseDate;

	@ApiModelProperty(position = 13)
	private Boolean fullTextDownload;

	@ApiModelProperty(position = 14)
	private Set<OrganizationDetails> organizations;

	@Deprecated
	@ApiModelProperty(position = 15)
	private String typology;

	public String getId() {
		return id;
	}

	public void setId(final String id) {
		this.id = id;
	}

	public String getOfficialname() {
		return officialname;
	}

	public void setOfficialname(final String officialname) {
		this.officialname = officialname;
	}

	public String getEnglishname() {
		return englishname;
	}

	public void setEnglishname(final String englishname) {
		this.englishname = englishname;
	}

	public String getWebsiteurl() {
		return websiteurl;
	}

	public void setWebsiteurl(final String websiteurl) {
		this.websiteurl = websiteurl;
	}

	public String getRegisteredby() {
		return registeredby;
	}

	public void setRegisteredby(final String registeredby) {
		this.registeredby = registeredby;
	}

	public Date getRegistrationdate() {
		return registrationdate;
	}

	public void setRegistrationdate(final Date registrationdate) {
		this.registrationdate = registrationdate;
	}

	public String getEoscDatasourceType() {
		return eoscDatasourceType;
	}

	public void setEoscDatasourceType(final String eoscDatasourceType) {
		this.eoscDatasourceType = eoscDatasourceType;
	}

	public String getLogoUrl() {
		return logoUrl;
	}

	public Boolean getConsentTermsOfUse() {
		return consentTermsOfUse;
	}

	public DatasourceSnippetExtended setConsentTermsOfUse(final Boolean consentTermsOfUse) {
		this.consentTermsOfUse = consentTermsOfUse;
		return this;
	}

	public Date getConsentTermsOfUseDate() {
		return consentTermsOfUseDate;
	}

	public DatasourceSnippetExtended setConsentTermsOfUseDate(final Date consentTermsOfUseDate) {
		this.consentTermsOfUseDate = consentTermsOfUseDate;
		return this;
	}

	public Boolean getFullTextDownload() {
		return fullTextDownload;
	}

	public DatasourceSnippetExtended setFullTextDownload(final Boolean fullTextDownload) {
		this.fullTextDownload = fullTextDownload;
		return this;
	}

	public DatasourceSnippetExtended setLogoUrl(final String logoUrl) {
		this.logoUrl = logoUrl;
		return this;
	}

	public String getDescription() {
		return description;
	}

	public DatasourceSnippetExtended setDescription(final String description) {
		this.description = description;
		return this;
	}

	public Set<OrganizationDetails> getOrganizations() {
		return organizations;
	}

	public DatasourceSnippetExtended setOrganizations(final Set<OrganizationDetails> organizations) {
		this.organizations = organizations;
		return this;
	}

	@Deprecated
	public String getTypology() {
		return typology;
	}

	@Deprecated
	public DatasourceSnippetExtended setTypology(final String typology) {
		this.typology = typology;
		return this;
	}

	public Date getLastConsentTermsOfUseDate() {
		return lastConsentTermsOfUseDate;
	}

	public DatasourceSnippetExtended setLastConsentTermsOfUseDate(final Date lastConsentTermsOfUseDate) {
		this.lastConsentTermsOfUseDate = lastConsentTermsOfUseDate;
		return this;
	}

}
