package eu.dnetlib.openaire.dsm.domain;

import java.util.List;
import java.util.Queue;
import java.util.stream.Collectors;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import com.google.gson.GsonBuilder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel
@JsonAutoDetect
public class Header {

	@ApiModelProperty(position = 0)
	private long total;

	@ApiModelProperty(position = 1)
	private int page;

	@ApiModelProperty(position = 2)
	private int size;

	@ApiModelProperty(position = 3)
	private long time;

	@ApiModelProperty(position = 4)
	private int statusCode;

	@ApiModelProperty(position = 5)
	private List<String> errors = Lists.newArrayList();

	@JsonIgnore
	private Queue<Throwable> exceptions = Lists.newLinkedList();

	public static Header newInsance() {
		return new Header();
	}

	public Header() {
	}

	public long getTime() {
		return time;
	}

	public Header setTime(final long time) {
		this.time = time;
		return this;
	}

	public int getStatusCode() {
		return statusCode;
	}

	public Header setStatusCode(final int statusCode) {
		this.statusCode = statusCode;
		return this;
	}

	public long getTotal() {
		return total;
	}

	public int getPage() {
		return page;
	}

	public int getSize() {
		return size;
	}

	public Header setPage(final int page) {
		this.page = page;
		return this;
	}

	public Header setSize(final int size) {
		this.size = size;
		return this;
	}

	public Header setTotal(final long total) {
		this.total = total;
		return this;
	}

	public Queue<Throwable> getExceptions() {
		return exceptions;
	}

	public Header setExceptions(final Queue<Throwable> exceptions) {
		this.exceptions = exceptions;
		return this;
	}

	public List<String> getErrors() {
		return getExceptions().stream()
				.map(Throwable::getMessage)
				.collect(Collectors.toList());
	}

	public Header setErrors(final List<String> errors) {
		this.errors = errors;
		return this;
	}

	public String toJson() {
		return new GsonBuilder().setPrettyPrinting().create().toJson(this);
	}

}
