package eu.dnetlib.openaire.dsm.domain;

import java.sql.Date;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonAutoDetect;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@JsonAutoDetect
@ApiModel(value = "Api model", description = "provides information about the datasource API")
public class ApiDetails extends ApiIgnoredProperties {

	@ApiModelProperty(position = 0)
	private String id = null;

	@ApiModelProperty(position = 1)
	private String protocol = null;

	@ApiModelProperty(position = 2)
	private String datasource = null;

	@ApiModelProperty(position = 3)
	private String contentdescription = null;

	@ApiModelProperty(position = 4)
	private String eoscDatasourceType = null;

	@ApiModelProperty(position = 5)
	private String compatibility;

	@ApiModelProperty(position = 7)
	private String compatibilityOverride;

	@ApiModelProperty(position = 8)
	private Integer lastCollectionTotal;

	@ApiModelProperty(position = 9)
	private Date lastCollectionDate;

	@ApiModelProperty(position = 10)
	private Integer lastAggregationTotal;

	@ApiModelProperty(position = 11)
	private Date lastAggregationDate;

	@ApiModelProperty(position = 12)
	private Integer lastDownloadTotal;

	@ApiModelProperty(position = 13)
	private Date lastDownloadDate;

	@ApiModelProperty(position = 14)
	private String baseurl;

	@ApiModelProperty(position = 15)
	protected Boolean removable = false;

	@ApiModelProperty(position = 16)
	private Set<ApiParamDetails> apiParams;

	@ApiModelProperty(position = 17)
	private String metadataIdentifierPath = "";

	public String getId() {
		return id;
	}

	public String getProtocol() {
		return protocol;
	}

	public String getDatasource() {
		return datasource;
	}

	public String getContentdescription() {
		return contentdescription;
	}

	public String getCompatibility() {
		return compatibility;
	}

	public Integer getLastCollectionTotal() {
		return lastCollectionTotal;
	}

	public Date getLastCollectionDate() {
		return lastCollectionDate;
	}

	public Integer getLastAggregationTotal() {
		return lastAggregationTotal;
	}

	public Date getLastAggregationDate() {
		return lastAggregationDate;
	}

	public Integer getLastDownloadTotal() {
		return lastDownloadTotal;
	}

	public Date getLastDownloadDate() {
		return lastDownloadDate;
	}

	public String getBaseurl() {
		return baseurl;
	}

	public ApiDetails setId(final String id) {
		this.id = id;
		return this;
	}

	public ApiDetails setProtocol(final String protocol) {
		this.protocol = protocol;
		return this;
	}

	public ApiDetails setDatasource(final String datasource) {
		this.datasource = datasource;
		return this;
	}

	public ApiDetails setContentdescription(final String contentdescription) {
		this.contentdescription = contentdescription;
		return this;
	}

	public ApiDetails setCompatibility(final String compatibility) {
		this.compatibility = compatibility;
		return this;
	}

	public ApiDetails setLastCollectionTotal(final Integer lastCollectionTotal) {
		this.lastCollectionTotal = lastCollectionTotal;
		return this;
	}

	public ApiDetails setLastCollectionDate(final Date lastCollectionDate) {
		this.lastCollectionDate = lastCollectionDate;
		return this;
	}

	public ApiDetails setLastAggregationTotal(final Integer lastAggregationTotal) {
		this.lastAggregationTotal = lastAggregationTotal;
		return this;
	}

	public ApiDetails setLastAggregationDate(final Date lastAggregationDate) {
		this.lastAggregationDate = lastAggregationDate;
		return this;
	}

	public ApiDetails setLastDownloadTotal(final Integer lastDownloadTotal) {
		this.lastDownloadTotal = lastDownloadTotal;
		return this;
	}

	public ApiDetails setLastDownloadDate(final Date lastDownloadDate) {
		this.lastDownloadDate = lastDownloadDate;
		return this;
	}

	public ApiDetails setBaseurl(final String baseurl) {
		this.baseurl = baseurl;
		return this;
	}

	public Set<ApiParamDetails> getApiParams() {
		return apiParams;
	}

	public void setApiParams(final Set<ApiParamDetails> apiParams) {
		this.apiParams = apiParams;
	}

	public String getCompatibilityOverride() {
		return compatibilityOverride;
	}

	public ApiDetails setCompatibilityOverride(final String compatibilityOverride) {
		this.compatibilityOverride = compatibilityOverride;
		return this;
	}

	public Boolean getRemovable() {
		return removable;
	}

	public ApiDetails setRemovable(final Boolean removable) {
		this.removable = removable;
		return this;
	}

	public String getMetadataIdentifierPath() {
		return metadataIdentifierPath;
	}

	public ApiDetails setMetadataIdentifierPath(final String metadataIdentifierPath) {
		this.metadataIdentifierPath = metadataIdentifierPath;
		return this;
	}

	public String getEoscDatasourceType() {
		return eoscDatasourceType;
	}

	public ApiDetails setEoscDatasourceType(final String eoscDatasourceType) {
		this.eoscDatasourceType = eoscDatasourceType;
		return this;
	}
}
