/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.common;

import com.google.common.collect.Lists;
import com.google.common.escape.Escaper;
import com.google.common.xml.XmlEscapers;
import eu.dnetlib.DnetOpenaireExporterProperties;
import eu.dnetlib.enabling.datasources.common.DsmException;
import eu.dnetlib.enabling.datasources.common.DsmRuntimeException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.openaire.common.ISClient;
import eu.dnetlib.openaire.common.Utils;
import eu.dnetlib.openaire.context.Context;
import eu.dnetlib.openaire.context.ContextMappingUtils;
import eu.dnetlib.openaire.dsm.dao.utils.IndexDsInfo;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.core.io.ClassPathResource;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ISClientImpl
implements ISClient {
    private static final Log log = LogFactory.getLog(ISClientImpl.class);
    @Autowired
    private DnetOpenaireExporterProperties config;
    @Autowired
    private ISLookUpService isLookUpService;

    @Cacheable(value={"indexdsinfo-cache"})
    public IndexDsInfo calculateCurrentIndexDsInfo() throws DsmException {
        log.warn((Object)"calculateCurrentIndexDsInfo(): not using cache");
        try {
            String[] arr = this._isLookUp(this._getQuery(this.config.getFindIndexDsInfo())).split("@@@");
            return new IndexDsInfo(this._isLookUp(this._getQuery(this.config.getFindSolrIndexUrl())), arr[0].trim(), arr[1].trim(), arr[2].trim());
        }
        catch (ISLookUpException | IOException e) {
            throw new DsmException("unable fetch index DS information from IS");
        }
    }

    @Cacheable(value={"objectstoreid-cache"})
    public String getObjectStoreId(String dsId) throws DsmException {
        log.warn((Object)String.format("getObjectStoreId(%s): not using cache", dsId));
        try {
            String xqueryTemplate = this._getQuery(this.config.getFindObjectStore());
            return this._isLookUp(String.format(xqueryTemplate, dsId));
        }
        catch (ISLookUpException | IOException e) {
            throw new DsmException("unble to find objectstore for ds " + dsId);
        }
    }

    @Cacheable(value={"context-cache-funder"})
    public Map<String, Context> getFunderContextMap() throws IOException {
        return this._processContext(this._getQuery(this.config.getFindFunderContexts()));
    }

    @Cacheable(value={"context-cache-community"})
    public Map<String, Context> getCommunityContextMap() throws IOException {
        return this._processContext(this._getQuery(this.config.getFindCommunityContexts()));
    }

    @Cacheable(value={"context-cache"})
    public Map<String, Context> getContextMap(List<String> type) throws IOException {
        if (Objects.isNull(type) || type.isEmpty()) {
            return this._processContext(this._getQuery(this.config.getFindContextProfiles()));
        }
        String xqueryTemplate = this._getQuery(this.config.getFindContextProfilesByType());
        String xquery = String.format(xqueryTemplate, type.stream().map(t -> String.format("./RESOURCE_PROFILE/BODY/CONFIGURATION/context/@type = '%s'", t)).collect(Collectors.joining(" or ")));
        return this._processContext(xquery);
    }

    @CacheEvict(value={"context-cache", "context-cache-funder"}, allEntries=true)
    public void updateContextParam(String id, String name, String value) {
        try {
            this._quickSeachProfile(this.getXQuery(id, name, value));
        }
        catch (ISLookUpException e) {
            throw new DsmRuntimeException(String.format("unable update context param [id: %s, name: %s, value: %s]", id, name, value), (Throwable)e);
        }
    }

    @CacheEvict(value={"context-cache", "context-cache-funder"}, allEntries=true)
    public void updateContextAttribute(String id, String name, String value) {
        Escaper esc = XmlEscapers.xmlAttributeEscaper();
        try {
            this._quickSeachProfile(String.format("update value collection('/db/DRIVER/ContextDSResources/ContextDSResourceType')/RESOURCE_PROFILE/BODY/CONFIGURATION/context[./@id = '%s']/@%s with '%s'", id, name, Utils.escape((Escaper)esc, (String)value)));
        }
        catch (ISLookUpException e) {
            throw new DsmRuntimeException(String.format("unable update context attribute [id: %s, name: %s, data: %s]", id, name, value), (Throwable)e);
        }
    }

    @CacheEvict(value={"context-cache", "context-cache-funder"}, allEntries=true)
    public void addConcept(String id, String categoryId, String data) {
        try {
            this._quickSeachProfile(String.format("update insert %s into collection('/db/DRIVER/ContextDSResources/ContextDSResourceType')/RESOURCE_PROFILE/BODY/CONFIGURATION/context[./@id = '%s']/category[./@id = '%s']", data, id, categoryId));
        }
        catch (ISLookUpException e) {
            throw new DsmRuntimeException(String.format("unable add concept [id: %s, categoryId: %s, data: %s]", id, categoryId, data), (Throwable)e);
        }
    }

    @CacheEvict(value={"context-cache", "context-cache-funder"}, allEntries=true)
    public void removeConcept(String id, String categoryId, String conceptId) {
        try {
            this._quickSeachProfile(String.format("for $concept in collection('/db/DRIVER/ContextDSResources/ContextDSResourceType')/RESOURCE_PROFILE/BODY/CONFIGURATION/context[./@id = '%s']/category[./@id = '%s']/concept[./@id = '%s'] return update delete $concept", id, categoryId, conceptId));
        }
        catch (ISLookUpException e) {
            throw new DsmRuntimeException(String.format("unable remove concept [id: %s, categoryId: %s, conceptId: %s]", id, categoryId, conceptId), (Throwable)e);
        }
    }

    @CacheEvict(value={"context-cache", "context-cache-community", "context-cache-funder"}, allEntries=true)
    public void updateConceptAttribute(String id, String name, String value) {
        Escaper esc = XmlEscapers.xmlAttributeEscaper();
        try {
            this._quickSeachProfile(String.format("update value collection('/db/DRIVER/ContextDSResources/ContextDSResourceType')/RESOURCE_PROFILE/BODY/CONFIGURATION/context/category/concept[./@id = '%s']/@%s with '%s'", id, name, Utils.escape((Escaper)esc, (String)value)));
        }
        catch (ISLookUpException e) {
            throw new DsmRuntimeException(String.format("unable update concept attribute [id: %s, name: %s, value: %s]", id, name, value), (Throwable)e);
        }
    }

    @CacheEvict(value={"context-cache", "context-cache-funder"}, allEntries=true)
    public void updateConceptParam(String id, String name, String value) {
        try {
            this._quickSeachProfile(this.getConceptXQuery(id, name, value));
        }
        catch (ISLookUpException e) {
            throw new DsmRuntimeException(String.format("unable update concept param [id: %s, name: %s, value: %s]", id, name, value), (Throwable)e);
        }
    }

    @CacheEvict(value={"context-cache", "context-cache-funder"}, allEntries=true)
    public void updateConceptParamNoEscape(String id, String name, String value) {
        try {
            this._quickSeachProfile(this.getConceptXQueryNoEscape(id, name, value));
        }
        catch (ISLookUpException e) {
            throw new DsmRuntimeException(String.format("unable update concept param [id: %s, name: %s, value: %s]", id, name, value), (Throwable)e);
        }
    }

    private String getXQuery(String id, String name, String value) {
        Escaper esc = XmlEscapers.xmlContentEscaper();
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return String.format("update replace collection('/db/DRIVER/ContextDSResources/ContextDSResourceType')/RESOURCE_PROFILE/BODY/CONFIGURATION/context[./@id = '%s']/param[./@name = '%s'] with <param name='%s'>%s</param>", id, name, name, Utils.escape((Escaper)esc, (String)value));
        }
        return String.format("update replace collection('/db/DRIVER/ContextDSResources/ContextDSResourceType')/RESOURCE_PROFILE/BODY/CONFIGURATION/context[./@id = '%s']/param[./@name = '%s'] with <param name='%s'/>", id, name, name);
    }

    private String getConceptXQuery(String id, String name, String value) {
        Escaper esc = XmlEscapers.xmlContentEscaper();
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return String.format("update replace collection('/db/DRIVER/ContextDSResources/ContextDSResourceType')//concept[./@id = '%s']/param[./@name = '%s'] with <param name='%s'>%s</param>", id, name, name, Utils.escape((Escaper)esc, (String)value));
        }
        return String.format("update replace collection('/db/DRIVER/ContextDSResources/ContextDSResourceType')//concept[./@id = '%s']/param[./@name = '%s'] with <param name='%s'/>", id, name, name);
    }

    private String getConceptXQueryNoEscape(String id, String name, String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return String.format("update replace collection('/db/DRIVER/ContextDSResources/ContextDSResourceType')//concept[./@id = '%s']/param[./@name = '%s'] with <param name='%s'>%s</param>", id, name, name, value);
        }
        return String.format("update replace collection('/db/DRIVER/ContextDSResources/ContextDSResourceType')//concept[./@id = '%s']/param[./@name = '%s'] with <param name='%s'/>", id, name, name);
    }

    private Map<String, Context> _processContext(String xquery) throws IOException {
        return this._processContext(new LinkedBlockingQueue(), xquery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Context> _processContext(Queue<Throwable> errors, String xquery) throws IOException {
        try {
            Map<String, Context> map = this.getContextProfiles(errors, xquery).stream().filter(StringUtils::isNotBlank).map(s -> ContextMappingUtils.parseContext((String)s, (Queue)errors)).collect(Collectors.toMap(Context::getId, Function.identity(), (c1, c2) -> {
                log.warn((Object)String.format("found duplicate context profile '%s'", c1.getId()));
                return c1;
            }));
            return map;
        }
        finally {
            if (!errors.isEmpty()) {
                log.error(errors);
                errors.forEach(Throwable::printStackTrace);
            }
        }
    }

    private List<String> getContextProfiles(Queue<Throwable> errors, String xquery) throws IOException {
        log.warn((Object)"getContextProfiles(): not using cache");
        try {
            return this._quickSeachProfile(xquery);
        }
        catch (ISLookUpException e) {
            throw new DsmRuntimeException("unable to get context profiles", (Throwable)e);
        }
    }

    private String _getQuery(ClassPathResource resource) throws IOException {
        return IOUtils.toString((InputStream)resource.getInputStream(), (Charset)Charset.defaultCharset());
    }

    private String _isLookUp(String xquery) throws ISLookUpException {
        log.debug((Object)String.format("running xquery:\n%s", xquery));
        return this.isLookUpService.getResourceProfileByQuery(xquery);
    }

    private List<String> _quickSeachProfile(String xquery) throws ISLookUpException {
        ArrayList res = Lists.newArrayList();
        log.debug((Object)String.format("running xquery:\n%s", xquery));
        List list = this.isLookUpService.quickSearchProfile(xquery);
        if (list != null) {
            res.addAll(list);
        }
        log.debug((Object)String.format("query result size: %s", res.size()));
        return res;
    }

    @CacheEvict(cacheNames={"context-cache", "indexdsinfo-cache", "objectstoreid-cache"}, allEntries=true)
    @Scheduled(fixedDelayString="${openaire.exporter.cache.ttl}")
    public void dropCache() {
        log.debug((Object)"dropped dsManager IS cache");
    }
}

