/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.info;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import eu.dnetlib.openaire.common.AbstractExporterController;
import eu.dnetlib.openaire.info.JdbcInfoDao;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@ConditionalOnProperty(value={"openaire.exporter.enable.info"}, havingValue="true")
@Api(tags={"OpenAIRE Info API"}, description="the OpenAIRE info API")
public class InfoController
extends AbstractExporterController {
    private static final Log log = LogFactory.getLog(InfoController.class);
    public static final String UTF8 = "UTF-8";
    @Autowired
    private JdbcInfoDao jdbcInfoDao;

    @RequestMapping(value={"/info/{infoKey}"}, produces={"application/json"}, method={RequestMethod.GET})
    @ApiOperation(value="get info date", notes="get info date", tags={"Read"}, response=LocalDate.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=LocalDate.class), @ApiResponse(code=500, message="unexpected error", response=AbstractExporterController.ErrorMessage.class)})
    public LocalDate getDate(@PathVariable String infoKey) {
        JdbcInfoDao.DATE_INFO info = JdbcInfoDao.DATE_INFO.valueOf((String)infoKey);
        if (info == null) {
            throw new RuntimeException(infoKey + " not recognized");
        }
        return this.jdbcInfoDao.getDate(info);
    }

    @RequestMapping(value={"/info"}, produces={"application/json"}, method={RequestMethod.GET})
    @ApiOperation(value="get all the info date", notes="get all the info date", tags={"Read"}, response=Map.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=LocalDate.class), @ApiResponse(code=500, message="unexpected error", response=AbstractExporterController.ErrorMessage.class)})
    public Map<String, LocalDate> listInfo() {
        HashMap map = Maps.newHashMap();
        for (JdbcInfoDao.DATE_INFO dateInfo : JdbcInfoDao.DATE_INFO.values()) {
            map.put(dateInfo.name(), this.jdbcInfoDao.getDate(dateInfo));
        }
        return map;
    }

    @RequestMapping(value={"/info/keys"}, produces={"application/json"}, method={RequestMethod.GET})
    @ApiOperation(value="get the available keys", notes="get the available keys", tags={"Read"}, response=String.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=LocalDate.class), @ApiResponse(code=500, message="unexpected error", response=AbstractExporterController.ErrorMessage.class)})
    public List<String> listInfoKeys() {
        ArrayList keys = Lists.newArrayList();
        for (JdbcInfoDao.DATE_INFO dateInfo : JdbcInfoDao.DATE_INFO.values()) {
            keys.add(dateInfo.name());
        }
        return keys;
    }

    @RequestMapping(value={"/info/dropCache"}, produces={"application/json"}, method={RequestMethod.GET})
    @ApiOperation(value="Drops the info cache", notes="Drops the info cache", tags={"Read"})
    public void dropCache() {
        this.jdbcInfoDao.dropCache();
    }
}

