package eu.dnetlib.openaire.community;

import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonAutoDetect;

import io.swagger.v3.oas.annotations.media.Schema;

@JsonAutoDetect
public class CommunityDetails extends CommunitySummary {

	@Schema(description = "date of creation for this community")
	private Date creationDate;

	@Schema(description = "date of the last update for this communityu")
	private Date lastUpdateDate;

	@Schema(description = "list of subjects (keywords) that characterise this community")
	private List<String> subjects;

	public CommunityDetails() {}

	public CommunityDetails(final CommunitySummary summary) {
		super(summary);
	}

	@Override
	public Date getCreationDate() {
		return creationDate;
	}

	@Override
	public void setCreationDate(final Date creationDate) {
		this.creationDate = creationDate;
	}

	public List<String> getSubjects() {
		return subjects;
	}

	public void setSubjects(final List<String> subjects) {
		this.subjects = subjects;
	}

	@Override
	public Date getLastUpdateDate() {
		return lastUpdateDate;
	}

	@Override
	public void setLastUpdateDate(final Date lastUpdateDate) {
		this.lastUpdateDate = lastUpdateDate;
	}
}
