/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.dsm.dao.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.data.transform.xml.AbstractDNetXsltFunctions;
import eu.dnetlib.enabling.datasources.common.Api;
import eu.dnetlib.openaire.dsm.domain.ApiDetails;
import eu.dnetlib.openaire.dsm.domain.DatasourceDetails;
import eu.dnetlib.openaire.dsm.domain.DatasourceDetailsUpdate;
import eu.dnetlib.openaire.dsm.domain.DatasourceSnippetExtended;
import eu.dnetlib.openaire.dsm.domain.OrganizationDetails;
import eu.dnetlib.openaire.dsm.domain.db.ApiDbEntry;
import eu.dnetlib.openaire.dsm.domain.db.DatasourceDbEntry;
import eu.dnetlib.openaire.dsm.domain.db.OrganizationDbEntry;
import java.beans.PropertyDescriptor;
import java.sql.Date;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;

/*
 * Exception performing whole class analysis ignored.
 */
public class DsmMappingUtils {
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String ID_SEPARATOR = "::";
    public static final String ID_PREFIX = "api_________::";

    public static String createId(ApiDetails api) {
        return "api_________::" + api.getDatasource() + "::" + RandomStringUtils.randomAlphanumeric((int)8);
    }

    public static DatasourceDetails asDetails(DatasourceDbEntry d) {
        DatasourceDetails details = (DatasourceDetails)DsmMappingUtils._convert((Object)d, DatasourceDetails.class);
        return details.setOpenaireId(DsmMappingUtils.asOpenaireId((String)details.getId()));
    }

    public static DatasourceSnippetExtended asSnippetExtended(DatasourceDbEntry d) {
        DatasourceSnippetExtended ds = new DatasourceSnippetExtended();
        ds.setId(d.getId());
        ds.setOfficialname(d.getOfficialname());
        ds.setEnglishname(d.getEnglishname());
        ds.setRegisteredby(d.getRegisteredby());
        ds.setWebsiteurl(d.getWebsiteurl());
        ds.setEoscDatasourceType(d.getEoscDatasourceType());
        ds.setRegistrationdate((java.util.Date)d.getRegistrationdate());
        ds.setLogoUrl(d.getLogourl());
        ds.setDescription(d.getDescription());
        ds.setConsentTermsOfUse(d.getConsentTermsOfUse());
        ds.setConsentTermsOfUseDate((java.util.Date)d.getConsentTermsOfUseDate());
        ds.setLastConsentTermsOfUseDate((java.util.Date)d.getLastConsentTermsOfUseDate());
        ds.setFullTextDownload(d.getFullTextDownload());
        if (d.getOrganizations() != null) {
            ds.setOrganizations(d.getOrganizations().stream().map(DsmMappingUtils::asOrganizationDetail).collect(Collectors.toSet()));
        }
        ds.setTypology(d.getTypology());
        return ds;
    }

    private static OrganizationDetails asOrganizationDetail(OrganizationDbEntry o) {
        return new OrganizationDetails().setCountry(o.getCountry()).setLegalname(o.getLegalname()).setLegalshortname(o.getLegalshortname()).setWebsiteurl(o.getWebsiteurl()).setLogourl(o.getLogourl());
    }

    public static ApiDetails asDetails(ApiDbEntry d) {
        return (ApiDetails)DsmMappingUtils._convert((Object)d, ApiDetails.class);
    }

    public static ApiDbEntry asDbEntry(ApiDetails d) {
        ApiDbEntry apiDbEntry = new ApiDbEntry();
        apiDbEntry.setId(d.getId());
        apiDbEntry.setBaseurl(d.getBaseurl());
        apiDbEntry.setProtocol(d.getProtocol());
        apiDbEntry.setDatasource(d.getDatasource());
        apiDbEntry.setContentdescription(d.getContentdescription());
        apiDbEntry.setCompatibility(d.getCompatibility());
        apiDbEntry.setCompatibilityOverride(d.getCompatibilityOverride());
        apiDbEntry.setRemovable(d.getRemovable());
        apiDbEntry.setMetadataIdentifierPath(d.getMetadataIdentifierPath());
        apiDbEntry.getApiParams().forEach(ap -> ap.getId().setApi((Api)apiDbEntry));
        return apiDbEntry;
    }

    public static DatasourceDbEntry asDbEntry(DatasourceDetails d) {
        DatasourceDbEntry dbe = (DatasourceDbEntry)DsmMappingUtils._convert((Object)d, DatasourceDbEntry.class);
        if (dbe.getOrganizations() != null) {
            dbe.getOrganizations().forEach(o -> {
                String prefix = StringUtils.isNotBlank((CharSequence)dbe.getNamespaceprefix()) ? dbe.getNamespaceprefix() : dbe.getId();
                o.setId(prefix + "::" + o.getLegalname());
                if (o.getDateofcollection() == null) {
                    o.setDateofcollection(new Date(System.currentTimeMillis()));
                }
                o.setCollectedfrom(dbe.getCollectedfrom());
            });
        }
        DsmMappingUtils._fix_typology((DatasourceDbEntry)dbe, (String)d.getTypology(), (String)d.getEoscDatasourceType());
        return dbe;
    }

    @Deprecated
    private static void _fix_typology(DatasourceDbEntry dbe, String oldTypology, String eoscTypology) {
        if (StringUtils.isNotBlank((CharSequence)oldTypology) && StringUtils.isBlank((CharSequence)eoscTypology)) {
            if (oldTypology.startsWith("crissystem")) {
                dbe.setEoscDatasourceType("CRIS system");
            } else if (oldTypology.startsWith("entityregistry")) {
                dbe.setEoscDatasourceType("Registry");
            } else if (oldTypology.startsWith("pubscatalogue") || oldTypology.equals("websource")) {
                dbe.setEoscDatasourceType("Catalogue");
            } else if (oldTypology.contains("journal")) {
                dbe.setEoscDatasourceType("Journal archive");
            } else if (oldTypology.startsWith("aggregator")) {
                dbe.setEoscDatasourceType("Aggregator");
            } else if (oldTypology.contains("repository")) {
                dbe.setEoscDatasourceType("Repository");
            } else {
                dbe.setEoscDatasourceType("Aggregator");
            }
        } else if (StringUtils.isBlank((CharSequence)oldTypology) && StringUtils.isNotBlank((CharSequence)eoscTypology)) {
            if (dbe.getEoscDatasourceType().equals("CRIS system")) {
                dbe.setTypology("crissystem");
            } else if (dbe.getEoscDatasourceType().equals("Registry")) {
                dbe.setTypology("entityregistry");
            } else if (dbe.getEoscDatasourceType().equals("Catalogue")) {
                dbe.setTypology("pubscatalogue::unknown");
            } else if (dbe.getEoscDatasourceType().equals("Journal archive")) {
                dbe.setTypology("pubsrepository::journal");
            } else if (dbe.getEoscDatasourceType().equals("Aggregator")) {
                dbe.setTypology("aggregator");
            } else if (dbe.getEoscDatasourceType().equals("Repository")) {
                dbe.setTypology("pubsrepository::unknown");
            } else {
                dbe.setTypology("aggregator");
            }
        }
    }

    public static DatasourceDbEntry asDbEntry(DatasourceDetailsUpdate d) {
        DatasourceDbEntry dbe = (DatasourceDbEntry)DsmMappingUtils._convert((Object)d, DatasourceDbEntry.class);
        DsmMappingUtils._fix_typology((DatasourceDbEntry)dbe, (String)d.getTypology(), (String)d.getEoscDatasourceType());
        return dbe;
    }

    private static <T> T _convert(Object o, Class<T> clazz) {
        ObjectMapper mapper = new ObjectMapper();
        return (T)mapper.convertValue(o, clazz);
    }

    private static String asOpenaireId(String id) {
        String prefix = StringUtils.substringBefore((String)id, (String)"::");
        String md5 = StringUtils.substringAfter((String)id, (String)"::");
        return prefix + "::" + AbstractDNetXsltFunctions.md5((String)md5);
    }

    public static void copyNonNullProperties(Object src, Object target) {
        BeanUtils.copyProperties((Object)src, (Object)target, (String[])DsmMappingUtils.getNullPropertyNames((Object)src));
    }

    public static String[] getNullPropertyNames(Object source) {
        BeanWrapperImpl src = new BeanWrapperImpl(source);
        PropertyDescriptor[] pds = src.getPropertyDescriptors();
        HashSet<String> emptyNames = new HashSet<String>();
        for (PropertyDescriptor pd : pds) {
            Object srcValue = src.getPropertyValue(pd.getName());
            if (srcValue != null) continue;
            emptyNames.add(pd.getName());
        }
        String[] result = new String[emptyNames.size()];
        return emptyNames.toArray(result);
    }
}

