/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.dsm;

import eu.dnetlib.enabling.datasources.common.DsmException;
import eu.dnetlib.enabling.datasources.common.DsmForbiddenException;
import eu.dnetlib.enabling.datasources.common.DsmNotFoundException;
import eu.dnetlib.openaire.common.AbstractExporterController;
import eu.dnetlib.openaire.common.OperationManager;
import eu.dnetlib.openaire.dsm.DsmCore;
import eu.dnetlib.openaire.dsm.domain.AggregationHistoryResponse;
import eu.dnetlib.openaire.dsm.domain.ApiDetails;
import eu.dnetlib.openaire.dsm.domain.ApiDetailsResponse;
import eu.dnetlib.openaire.dsm.domain.DatasourceDetailResponse;
import eu.dnetlib.openaire.dsm.domain.DatasourceDetails;
import eu.dnetlib.openaire.dsm.domain.DatasourceDetailsUpdate;
import eu.dnetlib.openaire.dsm.domain.DatasourceDetailsWithApis;
import eu.dnetlib.openaire.dsm.domain.DatasourceSnippetResponse;
import eu.dnetlib.openaire.dsm.domain.RequestFilter;
import eu.dnetlib.openaire.dsm.domain.RequestSort;
import eu.dnetlib.openaire.dsm.domain.RequestSortOrder;
import eu.dnetlib.openaire.dsm.domain.Response;
import eu.dnetlib.openaire.dsm.domain.SimpleResponse;
import eu.dnetlib.openaire.vocabularies.Country;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@ConditionalOnProperty(value={"openaire.exporter.enable.dsm"}, havingValue="true")
@Tag(name="OpenAIRE DSM API", description="the OpenAIRE Datasource Manager API")
public class DsmApiController
extends AbstractExporterController {
    @Autowired
    private DsmCore dsmCore;
    @Autowired
    private OperationManager operationManager;

    @RequestMapping(value={"/ds/countries"}, produces={"application/json"}, method={RequestMethod.GET})
    @Operation(summary="list the datasource countries", description="list the datasource countries", tags={"Datasource", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="unexpected error")})
    public List<Country> listCountries() throws DsmException {
        return this.dsmCore.listCountries();
    }

    @RequestMapping(value={"/ds/searchdetails/{page}/{size}"}, produces={"application/json"}, method={RequestMethod.POST})
    @Operation(summary="search datasources", description="Returns list of Datasource details.", tags={"Datasource", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="unexpected error")})
    public DatasourceDetailResponse searchDsDetails(@RequestParam RequestSort requestSortBy, @RequestParam RequestSortOrder order, @RequestBody RequestFilter requestFilter, @PathVariable int page, @PathVariable int size) throws DsmException {
        StopWatch stop = StopWatch.createStarted();
        DatasourceDetailResponse rsp = this.dsmCore.searchDsDetails(requestSortBy, order, requestFilter, page, size);
        return (DatasourceDetailResponse)this.prepareResponse(page, size, stop, (Response)rsp);
    }

    @RequestMapping(value={"/ds/aggregationhistory/{dsId}"}, produces={"application/json"}, method={RequestMethod.GET})
    @Operation(summary="search datasources", description="Returns list of Datasource details.", tags={"Datasource", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="unexpected error")})
    public AggregationHistoryResponse aggregationHistory(@PathVariable String dsId) throws DsmException {
        StopWatch stop = StopWatch.createStarted();
        AggregationHistoryResponse rsp = this.dsmCore.aggregationhistory(dsId);
        return (AggregationHistoryResponse)this.prepareResponse(0, rsp.getAggregationInfo().size(), stop, (Response)rsp);
    }

    @RequestMapping(value={"/ds/searchsnippet/{page}/{size}"}, produces={"application/json"}, method={RequestMethod.POST})
    @Operation(summary="search datasources", description="Returns list of Datasource basic info.", tags={"Datasource", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="unexpected error")})
    public DatasourceSnippetResponse searchSnippet(@RequestParam RequestSort requestSortBy, @RequestParam RequestSortOrder order, @RequestBody RequestFilter requestFilter, @PathVariable int page, @PathVariable int size) throws DsmException {
        StopWatch stop = StopWatch.createStarted();
        DatasourceSnippetResponse rsp = this.dsmCore.searchSnippet(requestSortBy, order, requestFilter, page, size);
        return (DatasourceSnippetResponse)this.prepareResponse(page, size, stop, (Response)rsp);
    }

    @RequestMapping(value={"/ds/searchregistered/{page}/{size}"}, produces={"application/json"}, method={RequestMethod.POST})
    @Operation(summary="search among registered datasources", description="Returns list of Datasource basic info.", tags={"Datasource", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="unexpected error")})
    public DatasourceSnippetResponse searchRegistered(@RequestParam RequestSort requestSortBy, @RequestParam RequestSortOrder order, @RequestBody RequestFilter requestFilter, @PathVariable int page, @PathVariable int size) throws DsmException {
        StopWatch stop = StopWatch.createStarted();
        DatasourceSnippetResponse rsp = this.dsmCore.searchRegistered(requestSortBy, order, requestFilter, page, size);
        return (DatasourceSnippetResponse)this.prepareResponse(page, size, stop, (Response)rsp);
    }

    @RequestMapping(value={"/ds/recentregistered/{size}"}, produces={"application/json"}, method={RequestMethod.GET})
    @Operation(summary="return the latest datasources that were registered through Provide", description="Returns list of Datasource basic info.", tags={"Datasource", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="unexpected error")})
    public SimpleResponse<?> recentRegistered(@PathVariable int size) throws Throwable {
        StopWatch stop = StopWatch.createStarted();
        SimpleResponse rsp = this.dsmCore.searchRecentRegistered(size);
        return (SimpleResponse)this.prepareResponse(1, size, stop, (Response)rsp);
    }

    @RequestMapping(value={"/ds/countregistered"}, produces={"application/json"}, method={RequestMethod.GET})
    @Operation(summary="return the number of datasources registered after the given date", description="Returns a number.", tags={"Datasource", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="unexpected error")})
    public Long countRegistered(@RequestParam String fromDate, @RequestParam(required=false) String typologyFilter) throws Throwable {
        return this.dsmCore.countRegisteredAfter(fromDate, typologyFilter);
    }

    @RequestMapping(value={"/ds/api/{dsId}"}, produces={"application/json"}, method={RequestMethod.GET})
    @Operation(summary="get the list of API for a given datasource", description="Returns the list of API for a given datasource.", tags={"Interface", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="unexpected error")})
    public ApiDetailsResponse getApi(@PathVariable String dsId) throws DsmException {
        StopWatch stop = StopWatch.createStarted();
        ApiDetailsResponse rsp = this.dsmCore.getApis(dsId);
        return (ApiDetailsResponse)this.prepareResponse(0, rsp.getApi().size(), stop, (Response)rsp);
    }

    @RequestMapping(value={"/api/baseurl/{page}/{size}"}, produces={"application/json"}, method={RequestMethod.POST})
    @Operation(summary="search for the list of base URLs of Datasource APIs managed by a user", description="Returns the list of base URLs of Datasource APIs managed by a user", tags={"Datasource", "Interface", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="unexpected error")})
    public List<String> searchBaseUrls(@RequestBody RequestFilter requestFilter, @PathVariable int page, @PathVariable int size) throws DsmException {
        return this.dsmCore.findBaseURLs(requestFilter, page, size);
    }

    @RequestMapping(value={"/ds/api/{apiId}"}, method={RequestMethod.DELETE})
    @Operation(summary="delete an API", description="delete an API, if removable", tags={"Interface", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", description="Api not found"), @ApiResponse(responseCode="403", description="Api not removable"), @ApiResponse(responseCode="500", description="DSM Server error")})
    public void deleteApi(@PathVariable String apiId) throws DsmForbiddenException, DsmNotFoundException {
        this.dsmCore.deleteApi(apiId);
    }

    @RequestMapping(value={"/ds/manage"}, method={RequestMethod.POST})
    @Operation(summary="set the managed status for a given datasource", description="set the managed status for a given datasource", tags={"Datasource", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void setManaged(@RequestParam String id, @RequestParam boolean managed) throws DsmException {
        this.dsmCore.setManaged(id, managed);
    }

    @RequestMapping(value={"/ds/managed/{id}"}, method={RequestMethod.GET})
    @Operation(summary="get the datasource managed status", description="get the datasource managed status", tags={"Datasource", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="unexpected error")})
    public boolean isManaged(@PathVariable String id) throws DsmException {
        return this.dsmCore.isManaged(id);
    }

    @RequestMapping(value={"/ds/add"}, method={RequestMethod.POST})
    @Operation(summary="add a new Datasource", description="add a new Datasource", tags={"Datasource", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", description="Malformed request"), @ApiResponse(responseCode="500", description="Unexpected error")})
    public void saveDs(@Valid @RequestBody DatasourceDetails datasource) throws DsmException {
        if (this.dsmCore.exist(datasource)) {
            throw new DsmException(409, String.format("cannot register, datasource already defined '%s'", datasource.getId()));
        }
        this.dsmCore.save(datasource);
    }

    @RequestMapping(value={"/ds/addWithApis"}, method={RequestMethod.POST})
    @Operation(summary="add a new Datasource and its apis", description="add a new Datasource and its apis", tags={"Datasource", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", description="Malformed request"), @ApiResponse(responseCode="500", description="Unexpected error")})
    public void saveDsWithApis(@Valid @RequestBody DatasourceDetailsWithApis d) throws DsmException {
        if (d.getDatasource() == null) {
            throw new DsmException(400, "Datasource field is null");
        }
        if (this.dsmCore.exist(d.getDatasource())) {
            throw new DsmException(409, String.format("cannot register, datasource already defined '%s'", d.getDatasource().getId()));
        }
        this.dsmCore.save(d);
    }

    @RequestMapping(value={"/ds/update"}, method={RequestMethod.POST})
    @Operation(summary="update Datasource details", description="update Datasource details", tags={"Datasource", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void updateDatasource(@RequestBody DatasourceDetailsUpdate ds) throws DsmException, DsmNotFoundException {
        this.dsmCore.updateDatasource(ds);
    }

    @RequestMapping(value={"/ds/api/baseurl"}, method={RequestMethod.POST})
    @Operation(summary="update the base URL of a datasource interface", description="update the base URL of a datasource interface", tags={"Interface", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void updateBaseUrl(@RequestParam String dsId, @RequestParam String apiId, @RequestParam String baseUrl) throws DsmException {
        this.dsmCore.updateApiBaseurl(dsId, apiId, baseUrl);
    }

    @RequestMapping(value={"/ds/api/compliance"}, method={RequestMethod.POST})
    @Operation(summary="update the compatibility of a datasource interface", description="update the compatibility of a datasource interface", tags={"Interface", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void updateCompliance(@RequestParam String dsId, @RequestParam String apiId, @RequestParam String compliance, @RequestParam(required=false, defaultValue="false") boolean override) throws DsmException {
        this.dsmCore.updateApiCompatibility(dsId, apiId, compliance, override);
    }

    @RequestMapping(value={"/ds/api/oaiset"}, method={RequestMethod.POST})
    @Operation(summary="update the OAI set of a datasource interface", description="update the OAI set of a datasource interface", tags={"Interface", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void updateOaiSetl(@RequestParam String dsId, @RequestParam String apiId, @RequestParam String oaiSet) throws DsmException {
        this.dsmCore.updateApiOaiSet(dsId, apiId, oaiSet);
    }

    @RequestMapping(value={"/ds/api/add"}, method={RequestMethod.POST})
    @Operation(summary="adds a new Interface to one Datasource", description="adds an Interface to one Datasource", tags={"Interface", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void addApi(@RequestBody ApiDetails api) throws DsmException {
        if (StringUtils.isBlank((CharSequence)api.getDatasource())) {
            throw new DsmException(400, "missing datasource id");
        }
        this.dsmCore.addApi(api);
    }

    @RequestMapping(value={"/dsm/ops"}, method={RequestMethod.GET})
    @Operation(summary="get the number of pending operations", description="get the number of pending operations", tags={"Read", "Management"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="unexpected error")})
    public int getOps() throws DsmException {
        return this.operationManager.getOpSize();
    }

    @RequestMapping(value={"/dsm/killops"}, method={RequestMethod.POST})
    @Operation(summary="interrupts the pending operations", description="return the number of interrupted operations", tags={"Write", "Management"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="unexpected error")})
    public int killOps() throws DsmException {
        return this.operationManager.dropAll();
    }

    @RequestMapping(value={"/dsm/dropcache"}, method={RequestMethod.POST})
    @Operation(summary="drop the caches", description="drop the internal caches", tags={"Write", "Management"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void dropCache() throws DsmException {
        this.dsmCore.dropCaches();
    }

    private <T extends Response> T prepareResponse(int page, int size, StopWatch stopWatch, T rsp) {
        rsp.getHeader().setTime(stopWatch.getTime()).setPage(page).setSize(size);
        return rsp;
    }
}

