/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.funders;

import eu.dnetlib.openaire.funders.FunderRepository;
import eu.dnetlib.openaire.funders.FundersApiException;
import eu.dnetlib.openaire.funders.domain.ConversionUtils;
import eu.dnetlib.openaire.funders.domain.ExtendedFunderDetails;
import eu.dnetlib.openaire.funders.domain.FunderDetails;
import eu.dnetlib.openaire.funders.domain.db.FunderDbEntry;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"openaire.exporter.enable.funders"}, havingValue="true")
public class FunderDao {
    @Autowired
    private FunderRepository funderRepository;

    public ExtendedFunderDetails getExtendedFunderDetails(String funderId) throws FundersApiException {
        return ConversionUtils.asExtendedFunderDetails((FunderDbEntry)((FunderDbEntry)this.funderRepository.findById((Object)funderId).orElseThrow(() -> new FundersApiException("Funder not found. ID:  " + funderId))));
    }

    public List<FunderDetails> listFunderDetails(int page, int size) throws FundersApiException {
        return this.funderRepository.findAll((Pageable)PageRequest.of((int)page, (int)size)).getContent().stream().map(ConversionUtils::asFunderDetails).collect(Collectors.toList());
    }

    public List<String> listFunderIds(int page, int size) throws FundersApiException {
        return this.funderRepository.findAll((Pageable)PageRequest.of((int)page, (int)size)).getContent().stream().map(f -> f.getId()).collect(Collectors.toList());
    }
}

