/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.dsm.dao;

import eu.dnetlib.data.objectstore.rmi.ObjectStoreService;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreServiceException;
import eu.dnetlib.openaire.dsm.dao.ObjectStoreClient;
import eu.dnetlib.openaire.exporter.exceptions.DsmApiException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"openaire.exporter.enable.dsm"}, havingValue="true")
public class ObjectStoreClientImpl
implements ObjectStoreClient {
    private static final Log log = LogFactory.getLog(ObjectStoreClientImpl.class);
    @Autowired
    private ObjectStoreService objectStoreService;

    public Long getObjectStoreSize(String objectStoreId) throws DsmApiException {
        log.debug((Object)("get size for objectStore " + objectStoreId));
        if (StringUtils.isBlank((CharSequence)objectStoreId)) {
            return 0L;
        }
        try {
            long size = this.objectStoreService.getSize(objectStoreId);
            log.debug((Object)("got objectStore size: " + size));
            return size;
        }
        catch (ObjectStoreServiceException e) {
            throw new DsmApiException("unable to get size for objectStore " + objectStoreId);
        }
    }
}

