package eu.dnetlib.openaire.community.repository;

import java.util.List;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.jpa.repository.JpaRepository;

import eu.dnetlib.openaire.community.model.DbSubCommunity;

@ConditionalOnProperty(value = "openaire.exporter.enable.community", havingValue = "true")
public interface DbSubCommunityRepository extends JpaRepository<DbSubCommunity, String> {

	List<DbSubCommunity> findByCommunity(String community);

	List<DbSubCommunity> findByCommunityAndParent(String community, String parent);

	void deleteByCommunity(String id);

}
