/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.funders;

import eu.dnetlib.openaire.exporter.model.funders.ExtendedFunderDetails;
import eu.dnetlib.openaire.exporter.model.funders.FunderDetails;
import eu.dnetlib.openaire.exporter.model.funders.FundingStream;
import eu.dnetlib.openaire.funders.domain.db.FunderDbEntry;
import eu.dnetlib.openaire.funders.domain.db.FundingPathDbEntry;
import java.io.Reader;
import java.io.StringReader;
import java.util.Date;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

/*
 * Exception performing whole class analysis ignored.
 */
public class ConversionUtils {
    public static final String SEPARATOR = "::";

    public static FunderDetails asFunderDetails(FunderDbEntry fdb) {
        FunderDetails f = new FunderDetails();
        f.setId(fdb.getId());
        f.setName(fdb.getName());
        f.setShortname(fdb.getShortname());
        f.setJurisdiction(fdb.getJurisdiction());
        f.setRegistrationDate((Date)fdb.getRegistrationdate());
        f.setLastUpdateDate((Date)fdb.getLastupdatedate());
        return f;
    }

    public static ExtendedFunderDetails asExtendedFunderDetails(FunderDbEntry fdb) {
        ExtendedFunderDetails f = new ExtendedFunderDetails(ConversionUtils.asFunderDetails((FunderDbEntry)fdb));
        if (fdb.getFundingpaths() != null) {
            f.setFundingStreams(fdb.getFundingpaths().stream().map(ConversionUtils::asFundingStream).collect(Collectors.toList()));
        }
        return f;
    }

    private static FundingStream asFundingStream(FundingPathDbEntry pathDbEntry) {
        FundingStream f = new FundingStream();
        try {
            Document xml = new SAXReader().read((Reader)new StringReader(pathDbEntry.getPath()));
            for (int i = 2; i >= 0; --i) {
                if (!ConversionUtils.hasFundingLevel((int)i, (Document)xml)) continue;
                f.setId(ConversionUtils.getId((int)i, (Document)xml));
                f.setName(ConversionUtils.getName((int)i, (Document)xml));
                break;
            }
            if (StringUtils.isBlank((CharSequence)f.getId()) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xml.valueOf("//funder/id/text()")})) {
                f.setId(xml.valueOf("//funder/shortname/text()"));
                f.setName(xml.valueOf("//funder/name/text()"));
            }
            if (StringUtils.isBlank((CharSequence)f.getId())) {
                throw new IllegalStateException("invalid funding path:\n" + xml.asXML());
            }
            return f;
        }
        catch (DocumentException e) {
            throw new IllegalStateException("unable to parse funding path:\n" + pathDbEntry.getPath());
        }
    }

    private static String getName(int level, Document d) {
        return d.valueOf(String.format("//funding_level_%s/description/text()", level));
    }

    private static String getId(int level, Document d) {
        return StringUtils.substringAfter((String)d.valueOf(String.format("//funding_level_%s/id/text()", level)), (String)"::");
    }

    private static boolean hasFundingLevel(int level, Document d) {
        return StringUtils.isNotBlank((CharSequence)ConversionUtils.getId((int)level, (Document)d));
    }
}

