/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.community.utils;

import com.google.common.collect.Lists;
import eu.dnetlib.openaire.community.model.DbCommunity;
import eu.dnetlib.openaire.community.model.DbDatasource;
import eu.dnetlib.openaire.community.model.DbProject;
import eu.dnetlib.openaire.community.model.DbSubCommunity;
import eu.dnetlib.openaire.community.model.DbSupportOrg;
import eu.dnetlib.openaire.exporter.model.community.CommunityContentprovider;
import eu.dnetlib.openaire.exporter.model.community.CommunityDetails;
import eu.dnetlib.openaire.exporter.model.community.CommunityOrganization;
import eu.dnetlib.openaire.exporter.model.community.CommunityProject;
import eu.dnetlib.openaire.exporter.model.community.CommunitySummary;
import eu.dnetlib.openaire.exporter.model.community.CommunityWritableProperties;
import eu.dnetlib.openaire.exporter.model.community.SubCommunity;
import eu.dnetlib.openaire.exporter.model.context.IISConfigurationEntry;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class CommunityMappingUtils {
    public static final String PIPE_SEPARATOR = "||";
    private static final List<String> DATE_PATTERN = Lists.newArrayList((Object[])new String[]{"yyyy-MM-dd'T'hh:mm:ss", "yyyy-MM-dd'T'hh:mm:ssXXX", "yyyy-MM-dd'T'hh:mm:ss+00:00"});
    private static final Log log = LogFactory.getLog(CommunityMappingUtils.class);

    public static CommunitySummary toCommunitySummary(DbCommunity c) {
        CommunitySummary summary = new CommunitySummary();
        CommunityMappingUtils.populateSummary((CommunitySummary)summary, (DbCommunity)c);
        return summary;
    }

    public static DbCommunity toCommunity(CommunityDetails details) {
        DbCommunity c = new DbCommunity();
        c.setId(details.getId());
        c.setName(details.getName());
        c.setShortName(details.getShortName());
        c.setDescription(details.getDescription());
        c.setStatus(details.getStatus());
        c.setLogoUrl(details.getLogoUrl());
        c.setMembership(details.getMembership());
        c.setType(details.getType());
        c.setClaim(details.getClaim());
        c.setSubjects(CommunityMappingUtils.toStringArray((List)details.getSubjects()));
        c.setFos(CommunityMappingUtils.toStringArray((List)details.getFos()));
        c.setSdg(CommunityMappingUtils.toStringArray((List)details.getSdg()));
        c.setAdvancedConstraints(details.getAdvancedConstraints());
        c.setRemoveConstraints(details.getRemoveConstraints());
        c.setMainZenodoCommunity(details.getZenodoCommunity());
        c.setOtherZenodoCommunities(CommunityMappingUtils.toStringArray((List)details.getOtherZenodoCommunities()));
        c.setSuggestedAcknowledgements(CommunityMappingUtils.toStringArray((List)details.getSuggestedAcknowledgements()));
        c.setPlan(details.getPlan());
        c.setCreationDate((LocalDateTime)ObjectUtils.firstNonNull((Object[])new LocalDateTime[]{details.getCreationDate(), LocalDateTime.now()}));
        c.setLastUpdateDate(LocalDateTime.now());
        return c;
    }

    public static void populateCommunity(DbCommunity c, CommunityWritableProperties details) {
        if (StringUtils.isNotBlank((CharSequence)details.getName())) {
            c.setName(details.getName());
        }
        if (StringUtils.isNotBlank((CharSequence)details.getShortName())) {
            c.setShortName(details.getShortName());
        }
        if (StringUtils.isNotBlank((CharSequence)details.getDescription())) {
            c.setDescription(details.getDescription());
        }
        if (details.getStatus() != null) {
            c.setStatus(details.getStatus());
        }
        if (details.getMembership() != null) {
            c.setMembership(details.getMembership());
        }
        if (details.getType() != null) {
            c.setType(details.getType());
        }
        if (details.getClaim() != null) {
            c.setClaim(details.getClaim());
        }
        if (StringUtils.isNotBlank((CharSequence)details.getLogoUrl())) {
            c.setLogoUrl(details.getLogoUrl());
        }
        if (details.getFos() != null) {
            c.setFos(CommunityMappingUtils.toStringArray((List)details.getFos()));
        }
        if (details.getSdg() != null) {
            c.setSdg(CommunityMappingUtils.toStringArray((List)details.getSdg()));
        }
        if (details.getSubjects() != null) {
            c.setSubjects(CommunityMappingUtils.toStringArray((List)details.getSubjects()));
        }
        if (details.getAdvancedConstraints() != null) {
            c.setAdvancedConstraints(details.getAdvancedConstraints());
        }
        if (details.getRemoveConstraints() != null) {
            c.setRemoveConstraints(details.getRemoveConstraints());
        }
        if (StringUtils.isNotBlank((CharSequence)details.getMainZenodoCommunity())) {
            c.setMainZenodoCommunity(details.getMainZenodoCommunity());
        }
        if (details.getOtherZenodoCommunities() != null) {
            c.setOtherZenodoCommunities(CommunityMappingUtils.toStringArray((List)details.getOtherZenodoCommunities()));
        }
        if (details.getPlan() != null) {
            c.setPlan(details.getPlan());
        }
        c.setLastUpdateDate(LocalDateTime.now());
    }

    public static CommunityDetails toCommunityDetails(DbCommunity c) {
        CommunityDetails details = new CommunityDetails();
        CommunityMappingUtils.populateSummary((CommunitySummary)details, (DbCommunity)c);
        details.setAdvancedConstraints(c.getAdvancedConstraints());
        details.setRemoveConstraints(c.getRemoveConstraints());
        details.setFos(Arrays.asList(c.getFos()));
        details.setSdg(Arrays.asList(c.getSdg()));
        details.setSubjects(Arrays.asList(c.getSubjects()));
        details.setOtherZenodoCommunities(Arrays.asList(c.getOtherZenodoCommunities()));
        details.setSuggestedAcknowledgements(Arrays.asList(c.getSuggestedAcknowledgements()));
        return details;
    }

    private static void populateSummary(CommunitySummary summary, DbCommunity c) {
        summary.setId(c.getId());
        summary.setShortName(c.getShortName());
        summary.setName(c.getName());
        summary.setLastUpdateDate(c.getLastUpdateDate());
        summary.setCreationDate(c.getCreationDate());
        summary.setQueryId(c.getId() + "||" + c.getShortName());
        summary.setType(c.getType());
        summary.setDescription(c.getDescription());
        summary.setLogoUrl(c.getLogoUrl());
        summary.setStatus(c.getStatus());
        summary.setClaim(c.getClaim());
        summary.setMembership(c.getMembership());
        summary.setZenodoCommunity(c.getMainZenodoCommunity());
        summary.setPlan(c.getPlan());
    }

    public static CommunityProject toCommunityProject(DbProject dbEntry) {
        CommunityProject cp = new CommunityProject();
        cp.setCommunityId(dbEntry.getCommunity());
        cp.setOpenaireId(dbEntry.getProjectId());
        cp.setName(dbEntry.getProjectName());
        cp.setAcronym(dbEntry.getProjectAcronym());
        cp.setFunder(dbEntry.getProjectFunder());
        cp.setGrantId(dbEntry.getProjectCode());
        cp.setAvailableSince(dbEntry.getAvailableSince());
        return cp;
    }

    public static DbProject toDbProject(String id, CommunityProject project) {
        DbProject p = new DbProject();
        p.setCommunity(id);
        p.setProjectId(project.getOpenaireId());
        p.setProjectName(project.getName());
        p.setProjectAcronym(project.getAcronym());
        p.setProjectCode(project.getGrantId());
        p.setProjectFunder(project.getFunder());
        if (project.getAvailableSince() != null) {
            p.setAvailableSince(project.getAvailableSince());
        } else {
            p.setAvailableSince(LocalDate.now());
        }
        return p;
    }

    public static CommunityContentprovider toCommunityContentprovider(DbDatasource dbEntry) {
        CommunityContentprovider ccp = new CommunityContentprovider();
        ccp.setCommunityId(dbEntry.getCommunity());
        ccp.setOpenaireId(dbEntry.getDsId());
        ccp.setName(dbEntry.getDsName());
        ccp.setOfficialname(dbEntry.getDsOfficialName());
        ccp.setSelectioncriteria(dbEntry.getConstraints());
        ccp.setEnabled(dbEntry.getEnabled() != null ? dbEntry.getEnabled() : true);
        return ccp;
    }

    public static DbDatasource toDbDatasource(String id, CommunityContentprovider provider) {
        DbDatasource ds = new DbDatasource();
        ds.setCommunity(id);
        ds.setDsId(provider.getOpenaireId());
        ds.setDsName(provider.getName());
        ds.setDsOfficialName(provider.getOfficialname());
        ds.setConstraints(provider.getSelectioncriteria());
        ds.setEnabled(Boolean.valueOf(provider.isEnabled()));
        return ds;
    }

    public static CommunityOrganization toCommunityOrganization(DbSupportOrg dbEntry) {
        CommunityOrganization co = new CommunityOrganization();
        co.setCommunityId(dbEntry.getCommunity());
        co.setName(dbEntry.getOrgName());
        co.setWebsite_url(dbEntry.getOrgUrl());
        co.setLogo_url(dbEntry.getOrgLogoUrl());
        return co;
    }

    public static DbSupportOrg toDbSupportOrg(String id, CommunityOrganization org) {
        DbSupportOrg dbo = new DbSupportOrg();
        dbo.setCommunity(id);
        dbo.setOrgName(org.getName());
        dbo.setOrgUrl(org.getWebsite_url());
        dbo.setOrgLogoUrl(org.getLogo_url());
        return dbo;
    }

    public static DbSubCommunity toDbSubCommunity(String id, SubCommunity sub) {
        DbSubCommunity dbsc = new DbSubCommunity();
        dbsc.setCommunity(id);
        dbsc.setId(sub.getSubCommunityId());
        dbsc.setCategory(sub.getCategory());
        dbsc.setLabel(sub.getLabel());
        dbsc.setParams(sub.getParams());
        dbsc.setParent(sub.getParent());
        dbsc.setClaim(sub.isClaim());
        dbsc.setBrowsable(sub.isBrowsable());
        return dbsc;
    }

    public static SubCommunity toSubCommunity(DbSubCommunity sub) {
        SubCommunity sc = new SubCommunity();
        sc.setSubCommunityId(sub.getId());
        sc.setCategory(sub.getCategory());
        sc.setCommunityId(sub.getCommunity());
        sc.setLabel(sub.getLabel());
        sc.setParams(sub.getParams());
        sc.setParent(sub.getParent());
        sc.setClaim(sub.isClaim());
        sc.setBrowsable(sub.isBrowsable());
        return sc;
    }

    public static LocalDateTime asLocalDateTime(String s) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        for (String pattern : DATE_PATTERN) {
            try {
                Date res = DateUtils.parseDate((String)s, (String[])new String[]{pattern});
                if (res == null) continue;
                return CommunityMappingUtils.asLocalDateTime((Date)res);
            }
            catch (ParseException parseException) {
            }
        }
        log.warn((Object)("Invalid Date: " + s));
        return null;
    }

    public static LocalDateTime asLocalDateTime(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    private static String[] toStringArray(List<String> list) {
        return list != null ? list.toArray(new String[list.size()]) : new String[]{};
    }

    public static IISConfigurationEntry asIISConfigurationEntry(DbCommunity c) {
        IISConfigurationEntry conf = new IISConfigurationEntry();
        conf.setId(c.getId());
        conf.setLabel(c.getName());
        conf.addParams("description", new String[]{c.getDescription()});
        conf.addParams("logourl", new String[]{c.getLogoUrl()});
        conf.addParams("status", new String[]{c.getStatus().toString()});
        conf.addParams("name", new String[]{c.getName()});
        conf.addParams("zenodoCommunity", new String[]{c.getMainZenodoCommunity()});
        conf.addParams("subject", c.getSubjects());
        conf.addParams("fos", c.getFos());
        conf.addParams("sdg", c.getSdg());
        conf.addParams("advancedConstraints", new String[]{c.getAdvancedConstraints() != null ? c.getAdvancedConstraints().toJson() : null});
        conf.addParams("removeConstraints", new String[]{c.getRemoveConstraints() != null ? c.getRemoveConstraints().toJson() : null});
        conf.addParams("suggestedAcknowledgement", c.getSuggestedAcknowledgements());
        conf.addParams("creationdate", new String[]{c.getCreationDate() != null ? c.getCreationDate().toString() : null});
        return conf;
    }

    public static IISConfigurationEntry asIISConfigurationEntry(DbSubCommunity subc) {
        IISConfigurationEntry conf = new IISConfigurationEntry();
        conf.setId(subc.getId());
        conf.setLabel(subc.getLabel());
        if (subc.getParams() != null) {
            conf.getParams().addAll(subc.getParams());
        }
        return conf;
    }
}

