/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.ServerAddress;
import eu.dnetlib.DnetOpenaireExporterProperties;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreService;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DNetOpenaireExporterConfiguration {
    private static final Log log = LogFactory.getLog(DNetOpenaireExporterConfiguration.class);
    @Autowired
    private DnetOpenaireExporterProperties props;

    @Bean
    public ISLookUpService getLookUpService() {
        return (ISLookUpService)this.getServiceStub(ISLookUpService.class, this.props.getIsLookupUrl());
    }

    @Bean
    public ObjectStoreService getObjectStoreService() {
        return (ObjectStoreService)this.getServiceStub(ObjectStoreService.class, this.props.getObjectStoreServiceUrl());
    }

    @Bean
    public ISRegistryService getRegistryService() {
        return (ISRegistryService)this.getServiceStub(ISRegistryService.class, this.props.getIsRegistryServiceUrl());
    }

    private <T> T getServiceStub(Class<T> clazz, String endpoint) {
        log.info((Object)String.format("Initializing service stub %s, endpoint %s", clazz.toString(), endpoint));
        JaxWsProxyFactoryBean jaxWsProxyFactory = new JaxWsProxyFactoryBean();
        jaxWsProxyFactory.setServiceClass(clazz);
        jaxWsProxyFactory.setAddress(endpoint);
        Object service = jaxWsProxyFactory.create();
        Client client = ClientProxy.getClient((Object)service);
        if (client != null) {
            HTTPConduit conduit = (HTTPConduit)client.getConduit();
            HTTPClientPolicy policy = new HTTPClientPolicy();
            log.info((Object)String.format("setting connectTimeout to %s, receiveTimeout to %s for service %s", this.props.getCxfClientConnectTimeout(), this.props.getCxfClientReceiveTimeout(), clazz.getCanonicalName()));
            policy.setConnectionTimeout((long)this.props.getCxfClientConnectTimeout());
            policy.setReceiveTimeout((long)this.props.getCxfClientReceiveTimeout());
            conduit.setClient(policy);
        }
        return (T)service;
    }

    @Bean
    public DataSource getSqlDataSource() {
        DnetOpenaireExporterProperties.Jdbc jdbc = this.props.getJdbc();
        return this.getDatasource(jdbc.getDriverClassName(), jdbc.getUrl(), jdbc.getUser(), jdbc.getPwd(), jdbc.getMinIdle(), jdbc.getMaxRows());
    }

    private BasicDataSource getDatasource(String driverClassName, String jdbcUrl, String jdbcUser, String jdbcPwd, int jdbcMinIdle, int jdbcMaxIdle) {
        BasicDataSource d = new BasicDataSource();
        d.setDriverClassName(driverClassName);
        d.setUrl(jdbcUrl);
        d.setUsername(jdbcUser);
        d.setPassword(jdbcPwd);
        d.setMinIdle(jdbcMinIdle);
        d.setMaxIdle(jdbcMaxIdle);
        return d;
    }

    @Bean
    public MongoClient getMongoClient() {
        return new MongoClient(new ServerAddress(this.props.getDatasource().getMongoHost(), this.props.getDatasource().getMongoPort()), MongoClientOptions.builder().connectionsPerHost(this.props.getDatasource().getMongoConnectionsPerHost()).build());
    }
}

