/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.dsm.dao;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.primitives.Ints;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import eu.dnetlib.DnetOpenaireExporterProperties;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.openaire.common.Utils;
import eu.dnetlib.openaire.dsm.dao.MongoLoggerClient;
import eu.dnetlib.openaire.dsm.dao.MongoLoggerClientImpl;
import eu.dnetlib.openaire.exporter.exceptions.DsmApiException;
import eu.dnetlib.openaire.exporter.model.dsm.AggregationInfo;
import eu.dnetlib.openaire.exporter.model.dsm.AggregationInfoV1;
import eu.dnetlib.openaire.exporter.model.dsm.AggregationStage;
import eu.dnetlib.openaire.exporter.model.dsm.CollectionInfoV1;
import eu.dnetlib.openaire.exporter.model.dsm.CollectionInfoV2;
import eu.dnetlib.openaire.exporter.model.dsm.CollectionMode;
import eu.dnetlib.openaire.exporter.model.dsm.TransformationInfoV1;
import eu.dnetlib.openaire.exporter.model.dsm.TransformationInfoV2;
import eu.dnetlib.openaire.info.JdbcInfoDao;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@ConditionalOnProperty(value={"openaire.exporter.enable.dsm"}, havingValue="true")
public class MongoLoggerClientImpl
implements MongoLoggerClient {
    private static final Log log = LogFactory.getLog(MongoLoggerClientImpl.class);
    @Autowired
    private MongoClient datasourcePublisherMongoClient;
    @Autowired
    private DnetOpenaireExporterProperties config;
    @Autowired
    private JdbcInfoDao jdbcInfoDao;
    private static final String LOADTIME = "loadtime";
    private final LoadingCache<String, Instant> loadingCache = CacheBuilder.newBuilder().maximumSize(1L).expireAfterWrite(60L, TimeUnit.MINUTES).build((CacheLoader)new /* Unavailable Anonymous Inner Class!! */);
    private static final Bson fields = MongoLoggerClientImpl.getFields();
    private static MongoCollection<Document> collection = null;

    @Cacheable(value={"dsm-aggregationhistory-cache-v1"})
    @Deprecated
    public List<AggregationInfoV1> getAggregationHistoryV1(String dsId) throws DsmApiException {
        return this.getAggregationHistory(dsId, this.queryForAggregationHistoryV1(dsId, "(collect|transform)"), this.getMapperV1());
    }

    @Cacheable(value={"dsm-aggregationhistory-cache-v2"})
    public List<AggregationInfo> getAggregationHistoryV2(String dsId) throws DsmApiException {
        return this.getAggregationHistory(dsId, this.queryForAggregationHistoryV2(dsId, "(collect|transform)"), this.getMapperV2());
    }

    private <T extends AggregationInfo> List<T> getAggregationHistory(String dsId, Bson queryForAggregationHistory, Function<Document, T> mapper) throws DsmApiException {
        log.warn((Object)String.format("getAggregationHistory(dsId = %s): not using cache", dsId));
        DnetOpenaireExporterProperties.Datasource conf = this.config.getDatasource();
        try {
            FindIterable aggregationDocs = this.getCollection().find(queryForAggregationHistory).projection(fields).limit(conf.getMongoQueryLimit()).sort((Bson)MongoLoggerClientImpl.dbo((String)"system:startHumanDate", (Object)-1));
            List aggregationInfos = Utils.stream((Iterator)aggregationDocs.iterator()).map(mapper).filter(ai -> ai.getNumberOfRecords() >= 0 && StringUtils.isNotBlank((CharSequence)ai.getDate())).collect(Collectors.toList());
            Instant loadTime = (Instant)this.loadingCache.get((Object)"loadtime");
            if (!Objects.equals(Instant.MIN, loadTime)) {
                for (AggregationInfo a : aggregationInfos) {
                    if (!this.asInstant(a).isBefore(loadTime) || !AggregationStage.COLLECT.equals((Object)a.getAggregationStage())) continue;
                    a.setIndexedVersion(true);
                    break;
                }
            }
            return aggregationInfos;
        }
        catch (Throwable e) {
            throw new DsmApiException(500, String.format("error reading aggregation history for '%s'", dsId), e);
        }
    }

    private Instant getLoadTime() {
        log.warn((Object)"querying for metadata load time, not using cache");
        LocalDate date = this.jdbcInfoDao.getDate(JdbcInfoDao.DATE_INFO.oaf_load_date);
        return date.atStartOfDay(ZoneId.systemDefault()).toInstant();
    }

    private Instant asInstant(AggregationInfo a) {
        return Instant.parse(a.getDate() + "T00:00:00Z");
    }

    @CacheEvict(cacheNames={"dsm-aggregationhistory-cache-v1", "dsm-aggregationhistory-cache-v2", "dsm-firstharvestdate-cache"}, allEntries=true)
    @Scheduled(fixedDelayString="${openaire.exporter.cache.ttl}")
    public void dropCache() {
        log.debug((Object)"dropped dsManager aggregation history cache");
    }

    @Deprecated
    private Function<Document, AggregationInfoV1> getMapperV1() {
        return d -> {
            TransformationInfoV1 info = null;
            AggregationStage stage = AggregationStage.parse((String)d.getString((Object)"system:wfName"));
            boolean success = this.isCompletedSuccesfully(d);
            switch (2.$SwitchMap$eu$dnetlib$openaire$exporter$model$dsm$AggregationStage[stage.ordinal()]) {
                case 1: {
                    CollectionInfoV1 cInfo = new CollectionInfoV1();
                    cInfo.setAggregationStage(stage);
                    cInfo.setCollectionMode(this.getCollectionMode(d));
                    cInfo.setNumberOfRecords(success ? this.getNumberOfRecords(d) : 0);
                    cInfo.setDate(this.getDate(d));
                    cInfo.setCompletedSuccessfully(success);
                    info = cInfo;
                    break;
                }
                case 2: {
                    TransformationInfoV1 tInfo = new TransformationInfoV1();
                    tInfo.setAggregationStage(stage);
                    tInfo.setNumberOfRecords(success ? this.getNumberOfRecords(d) : 0);
                    tInfo.setDate(this.getDate(d));
                    tInfo.setCompletedSuccessfully(success);
                    info = tInfo;
                }
            }
            return info;
        };
    }

    private Function<Document, AggregationInfo> getMapperV2() {
        return d -> {
            TransformationInfoV2 info = null;
            AggregationStage stage = AggregationStage.parse((String)d.getString((Object)"system:wfName"));
            boolean success = this.isCompletedSuccesfully(d);
            switch (2.$SwitchMap$eu$dnetlib$openaire$exporter$model$dsm$AggregationStage[stage.ordinal()]) {
                case 1: {
                    CollectionInfoV2 cInfo = new CollectionInfoV2();
                    cInfo.setAggregationStage(stage);
                    cInfo.setCollectionMode(this.getCollectionMode(d));
                    cInfo.setNumberOfRecords(success ? this.getNumberOfRecords(d) : 0);
                    cInfo.setDate(this.getDate(d));
                    cInfo.setCompletedSuccessfully(success);
                    info = cInfo;
                    break;
                }
                case 2: {
                    TransformationInfoV2 tInfo = new TransformationInfoV2();
                    tInfo.setAggregationStage(stage);
                    tInfo.setNumberOfRecords(success ? this.getNumberOfRecords(d) : 0);
                    tInfo.setDate(this.getDate(d));
                    tInfo.setCompletedSuccessfully(success);
                    info = tInfo;
                }
            }
            return info;
        };
    }

    private CollectionMode getCollectionMode(Document d) {
        return Optional.ofNullable(d.getString((Object)"system:node:SELECT_MODE:selection")).map(CollectionMode::valueOf).orElseGet(() -> Optional.ofNullable(d.getString((Object)"collectionMode")).map(CollectionMode::valueOf).orElse(null));
    }

    private Integer getNumberOfRecords(Document d) {
        String sinkSize = d.getString((Object)"mainlog:sinkSize");
        String total = d.getString((Object)"mainlog:total");
        if (StringUtils.isNotBlank((CharSequence)sinkSize)) {
            return Ints.tryParse((String)sinkSize);
        }
        if (StringUtils.isNotBlank((CharSequence)total)) {
            return Ints.tryParse((String)total);
        }
        return -1;
    }

    private String getDate(Document d) {
        String dateString = d.getString((Object)"system:startHumanDate");
        if (StringUtils.isBlank((CharSequence)dateString)) {
            return "";
        }
        return DateFormatUtils.format((Date)new DateUtils().parse(dateString), (String)"yyyy-MM-dd");
    }

    private boolean isCompletedSuccesfully(Document d) {
        String boolString = d.getString((Object)"system:isCompletedSuccessfully");
        return BooleanUtils.toBoolean((String)boolString);
    }

    private static Bson getFields() {
        return Projections.fields((Bson[])new Bson[]{Filters.eq((String)"system:wfName", (Object)1), Filters.eq((String)"system:node:SELECT_MODE:selection", (Object)1), Filters.eq((String)"collectionMode", (Object)1), Filters.eq((String)"mainlog:sinkSize", (Object)1), Filters.eq((String)"mainlog:writeOps", (Object)1), Filters.eq((String)"mainlog:total", (Object)1), Filters.eq((String)"system:startHumanDate", (Object)1), Filters.eq((String)"system:profileName", (Object)1), Filters.eq((String)"system:isCompletedSuccessfully", (Object)1)});
    }

    private static BasicDBObject dbo(String key, Object value) {
        return new BasicDBObject(key, value);
    }

    @Deprecated
    private Bson queryForAggregationHistoryV1(String dsId, String pattern) {
        return Filters.and((Bson[])new Bson[]{Filters.eq((String)"parentDatasourceId", (Object)dsId), Filters.eq((String)"system:profileFamily", (Object)"aggregator"), Filters.eq((String)"system:isCompletedSuccessfully", (Object)"true"), Filters.regex((String)"system:wfName", (String)pattern, (String)"i")});
    }

    private Bson queryForAggregationHistoryV2(String dsId, String pattern) {
        return Filters.and((Bson[])new Bson[]{Filters.eq((String)"parentDatasourceId", (Object)dsId), Filters.eq((String)"system:profileFamily", (Object)"aggregator"), Filters.regex((String)"system:wfName", (String)pattern, (String)"i")});
    }

    private synchronized MongoCollection<Document> getCollection() {
        if (collection == null) {
            log.info((Object)"inizializing mongodb collection ...");
            DnetOpenaireExporterProperties.Datasource conf = this.config.getDatasource();
            collection = this.datasourcePublisherMongoClient.getDatabase(conf.getMongoDbName()).getCollection(conf.getMongoCollectionName());
        }
        return collection;
    }

    static /* synthetic */ Instant access$000(MongoLoggerClientImpl x0) {
        return x0.getLoadTime();
    }

    static /* synthetic */ Log access$100() {
        return log;
    }
}

