package eu.dnetlib.openaire.funders;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;

import javax.servlet.http.HttpServletResponse;

import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import eu.dnetlib.openaire.common.AbstractExporterController;
import eu.dnetlib.openaire.exporter.exceptions.FundersApiException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;

@RestController
@CrossOrigin(origins = {
		"*"
})
@ConditionalOnProperty(value = "openaire.exporter.enable.funders", havingValue = "true")
@Tag(name = "OpenAIRE funders API", description = "the OpenAIRE funders API")
public class FundersApiController extends AbstractExporterController {

	@Autowired
	private FunderService service;

	private static final Log log = LogFactory.getLog(FundersApiController.class);

	@RequestMapping(value = "/funders", produces = {
			"application/json"
	}, method = RequestMethod.GET)
	@Operation(summary = "get all funders", description = "get all funders")
	@ApiResponses(value = {
			@ApiResponse(responseCode = "200", description = "OK"),
			@ApiResponse(responseCode = "500", description = "unexpected error")
	})
	public void getFunders(final HttpServletResponse res) throws FundersApiException {

		res.setContentType(MediaType.APPLICATION_JSON_VALUE);

		final File file = service.getTempFile();

		if (file == null) {
			log.error("Missing temp file (NULL)");
			throw new FundersApiException("Missing temp file (NULL)");
		}

		if (!file.exists()) {
			log.error("Missing temp file " + service.getTempFile());
			throw new FundersApiException("Missing temp file " + service.getTempFile());
		}

		try (final InputStream in = new FileInputStream(file); OutputStream out = res.getOutputStream()) {
			IOUtils.copy(in, out);
			return;
		} catch (final Exception e) {
			log.error("Error reading file " + service.getTempFile(), e);
			throw new FundersApiException("Error reading file " + service.getTempFile(), e);
		}
	}

}
