/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.community.importer;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import eu.dnetlib.miscutils.functional.hash.Hashing;
import eu.dnetlib.openaire.community.CommunityService;
import eu.dnetlib.openaire.community.model.DbOrganization;
import eu.dnetlib.openaire.community.repository.DbOrganizationRepository;
import eu.dnetlib.openaire.community.utils.CommunityMappingUtils;
import eu.dnetlib.openaire.exporter.exceptions.CommunityException;
import eu.dnetlib.openaire.exporter.model.community.CommunityClaimType;
import eu.dnetlib.openaire.exporter.model.community.CommunityContentprovider;
import eu.dnetlib.openaire.exporter.model.community.CommunityDetails;
import eu.dnetlib.openaire.exporter.model.community.CommunityMembershipType;
import eu.dnetlib.openaire.exporter.model.community.CommunityOrganization;
import eu.dnetlib.openaire.exporter.model.community.CommunityPlanType;
import eu.dnetlib.openaire.exporter.model.community.CommunityProject;
import eu.dnetlib.openaire.exporter.model.community.CommunityStatus;
import eu.dnetlib.openaire.exporter.model.community.CommunityType;
import eu.dnetlib.openaire.exporter.model.community.SubCommunity;
import eu.dnetlib.openaire.exporter.model.community.selectioncriteria.SelectionCriteria;
import eu.dnetlib.openaire.exporter.model.context.Category;
import eu.dnetlib.openaire.exporter.model.context.Concept;
import eu.dnetlib.openaire.exporter.model.context.Context;
import eu.dnetlib.openaire.exporter.model.context.Param;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.transaction.Transactional;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.DocumentHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@ConditionalOnProperty(value={"openaire.exporter.enable.community.import"}, havingValue="true")
public class CommunityImporterService {
    public static final String OPENAIRE_ID = "openaireId";
    public static final String PIPE_SEPARATOR = "||";
    public static final String ID_SEPARATOR = "::";
    public static final String CSV_DELIMITER = ",";
    public static final String CLABEL = "label";
    public static final String PROJECTS_ID_SUFFIX = "::projects";
    public static final String CONTENTPROVIDERS_ID_SUFFIX = "::contentproviders";
    public static final String ZENODOCOMMUNITY_ID_SUFFIX = "::zenodocommunities";
    public static final String ORGANIZATION_ID_SUFFIX = "::organizations";
    public static final String CSUMMARY_DESCRIPTION = "description";
    public static final String CSUMMARY_LOGOURL = "logourl";
    public static final String CSUMMARY_STATUS = "status";
    public static final String CSUMMARY_NAME = "name";
    public static final String CSUMMARY_MANAGER = "manager";
    public static final String CSUMMARY_ZENODOC = "zenodoCommunity";
    public static final String CPROFILE_SUBJECT = "subject";
    public static final String CPROFILE_CREATIONDATE = "creationdate";
    public static final String CPROFILE_FOS = "fos";
    public static final String CPROFILE_SDG = "sdg";
    public static final String CPROFILE_ADVANCED_CONSTRAINT = "advancedConstraints";
    public static final String CPROFILE_REMOVE_CONSTRAINT = "removeConstraints";
    public static final String CPROFILE_SUGGESTED_ACKNOWLEDGEMENT = "suggestedAcknowledgement";
    public static final String CPROJECT_FUNDER = "funder";
    public static final String CPROJECT_NUMBER = "CD_PROJECT_NUMBER";
    public static final String CPROJECT_FULLNAME = "projectfullname";
    public static final String CPROJECT_ACRONYM = "acronym";
    public static final String CCONTENTPROVIDER_NAME = "name";
    public static final String CCONTENTPROVIDER_OFFICIALNAME = "officialname";
    public static final String CCONTENTPROVIDER_ENABLED = "enabled";
    public static final String CCONTENTPROVIDERENABLED_DEFAULT = "true";
    public static final String CCONTENTPROVIDER_SELCRITERIA = "selcriteria";
    public static final String CZENODOCOMMUNITY_ID = "zenodoid";
    public static final String CORGANIZATION_NAME = "name";
    public static final String CORGANIZATION_LOGOURL = "logourl";
    public static final String CORGANIZATION_WEBSITEURL = "websiteurl";
    @Autowired
    private DbOrganizationRepository dbOrganizationRepository;
    @Autowired
    private CommunityService service;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private static final Log log = LogFactory.getLog(CommunityImporterService.class);

    public List<DbOrganization> importPropagationOrganizationsFromProfile(String xml, boolean simulation) throws Exception {
        String json = DocumentHelper.parseText((String)xml).selectSingleNode("//NODE[@name='setPropagationOrganizationCommunityMap']//PARAM[@name='parameterValue']").getText();
        List<DbOrganization> list = ((Map)new ObjectMapper().readValue(json, (TypeReference)new /* Unavailable Anonymous Inner Class!! */)).entrySet().stream().flatMap(e -> ((List)e.getValue()).stream().map(community -> {
            if (((String)e.getKey()).contains("|")) {
                return new DbOrganization(community, StringUtils.substringAfter((String)((String)e.getKey()), (String)"|"));
            }
            return new DbOrganization(community, (String)e.getKey());
        })).collect(Collectors.toList());
        if (!simulation) {
            list.forEach(o -> {
                try {
                    this.dbOrganizationRepository.save(o);
                }
                catch (Throwable e) {
                    log.error((Object)("ERROR saving org: " + o));
                }
            });
        }
        return list;
    }

    @Transactional
    public void importCommunity(Context context) {
        try {
            CommunityDetails community = CommunityImporterService.asCommunityDetails((Context)context);
            List<CommunityContentprovider> datasources = this.getCommunityInfo(context, "::contentproviders", c -> CommunityImporterService.asCommunityDataprovider((String)context.getId(), (Concept)c)).stream().map(o -> {
                if (o.getOpenaireId() == null) {
                    log.warn((Object)("Openaire ID is missing, organization: " + o.getOfficialname()));
                } else if (o.getOpenaireId().contains("|")) {
                    o.setOpenaireId(StringUtils.substringAfter((String)o.getOpenaireId(), (String)"|"));
                }
                return o;
            }).filter(o -> o.getOpenaireId() != null).collect(Collectors.toList());
            List<CommunityProject> projects = this.getCommunityInfo(context, "::projects", c -> CommunityImporterService.asCommunityProject((String)context.getId(), (Concept)c)).stream().map(p -> {
                if (p.getOpenaireId() == null) {
                    if ("EC".equalsIgnoreCase(p.getFunder())) {
                        String ns = this.findNamespaceForECProject(p.getGrantId());
                        if (ns != null) {
                            p.setOpenaireId(ns + "::" + Hashing.md5((String)p.getGrantId()));
                        } else {
                            log.warn((Object)("EC project not in the db: " + p.getGrantId()));
                        }
                    } else if ("NSF".equalsIgnoreCase(p.getFunder())) {
                        p.setOpenaireId("nsf_________::" + Hashing.md5((String)p.getGrantId()));
                    } else if ("NIH".equalsIgnoreCase(p.getFunder())) {
                        p.setOpenaireId("nih_________::" + Hashing.md5((String)p.getGrantId()));
                    } else {
                        log.warn((Object)("Openaire ID is missing, funder: " + p.getFunder()));
                    }
                } else if (p.getOpenaireId().contains("|")) {
                    p.setOpenaireId(StringUtils.substringAfter((String)p.getOpenaireId(), (String)"|"));
                }
                return p;
            }).filter(p -> p.getOpenaireId() != null).collect(Collectors.toList());
            List orgs = this.getCommunityInfo(context, "::organizations", c -> CommunityImporterService.asCommunityOrganization((String)context.getId(), (Concept)c));
            List otherZenodoCommunities = this.getCommunityInfo(context, "::zenodocommunities", CommunityImporterService::asZenodoCommunity);
            community.setOtherZenodoCommunities(otherZenodoCommunities);
            List<SubCommunity> subs = context.getCategories().entrySet().stream().filter(e -> !(context.getId() + "::contentproviders").equals(e.getKey())).filter(e -> !(context.getId() + "::projects").equals(e.getKey())).filter(e -> !(context.getId() + "::organizations").equals(e.getKey())).filter(e -> !(context.getId() + "::zenodocommunities").equals(e.getKey())).map(Map.Entry::getValue).map(cat -> CommunityImporterService.asSubCommunities((String)context.getId(), null, (String)cat.getLabel(), (List)cat.getConcepts())).flatMap(Collection::stream).collect(Collectors.toList());
            this.service.saveCommunity(community);
            this.service.addCommunityProjects(context.getId(), projects.toArray(new CommunityProject[projects.size()]));
            this.service.addCommunityDatasources(context.getId(), datasources.toArray(new CommunityContentprovider[datasources.size()]));
            this.service.addCommunityOrganizations(context.getId(), orgs.toArray(new CommunityOrganization[orgs.size()]));
            this.service.addSubCommunities(context.getId(), subs.toArray(new SubCommunity[subs.size()]));
        }
        catch (Exception e2) {
            throw new RuntimeException("Error importing community: " + context.getId(), e2);
        }
    }

    private <R> List<R> getCommunityInfo(Context context, String idSuffix, Function<Concept, R> mapping) throws CommunityException {
        Map categories;
        Category category;
        if (context != null && (category = (Category)(categories = context.getCategories()).get(context.getId() + idSuffix)) != null) {
            return category.getConcepts().stream().map(mapping).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    private static CommunityDetails asCommunityDetails(Context c) {
        CommunityDetails details = new CommunityDetails();
        details.setId(c.getId());
        details.setShortName(c.getLabel());
        details.setDisplayShortName(c.getLabel());
        details.setLastUpdateDate(CommunityMappingUtils.asLocalDateTime((Date)c.getLastUpdateDate()));
        details.setCreationDate(CommunityMappingUtils.asLocalDateTime((Date)c.getCreationDate()));
        details.setQueryId(c.getId() + "||" + c.getLabel());
        details.setType(CommunityType.valueOf((String)c.getType()));
        details.setMembership(CommunityMembershipType.open);
        details.setClaim(CommunityClaimType.all);
        details.setDescription(CommunityImporterService.asCsv((String)"description", (List)c.getParams()));
        details.setLogoUrl(CommunityImporterService.asCsv((String)"logourl", (List)c.getParams()));
        String status = CommunityImporterService.firstValue((String)"status", (List)c.getParams());
        if (StringUtils.isNotBlank((CharSequence)status)) {
            details.setStatus(CommunityStatus.valueOf((String)status));
        } else {
            details.setStatus(CommunityStatus.hidden);
        }
        details.setName((String)StringUtils.firstNonBlank((CharSequence[])new String[]{CommunityImporterService.asCsv((String)"name", (List)c.getParams()), c.getLabel()}));
        details.setDisplayName((String)StringUtils.firstNonBlank((CharSequence[])new String[]{CommunityImporterService.asCsv((String)"name", (List)c.getParams()), c.getLabel()}));
        details.setZenodoCommunity(CommunityImporterService.asCsv((String)"zenodoCommunity", (List)c.getParams()));
        details.setSubjects(CommunityImporterService.splitValues((Stream)CommunityImporterService.asValues((String)"subject", (List)c.getParams()), (String)","));
        details.setFos(CommunityImporterService.splitValues((Stream)CommunityImporterService.asValues((String)"fos", (List)c.getParams()), (String)","));
        details.setSdg(CommunityImporterService.splitValues((Stream)CommunityImporterService.asValues((String)"sdg", (List)c.getParams()), (String)","));
        details.setAdvancedConstraints(SelectionCriteria.fromJson((String)CommunityImporterService.asCsv((String)"advancedConstraints", (List)c.getParams())));
        details.setRemoveConstraints(SelectionCriteria.fromJson((String)CommunityImporterService.asCsv((String)"removeConstraints", (List)c.getParams())));
        details.setSuggestedAcknowledgements(CommunityImporterService.splitValues((Stream)CommunityImporterService.asValues((String)"suggestedAcknowledgement", (List)c.getParams()), (String)","));
        details.setPlan(CommunityPlanType.Default);
        try {
            details.setCreationDate(CommunityMappingUtils.asLocalDateTime((String)CommunityImporterService.asCsv((String)"creationdate", (List)c.getParams())));
        }
        catch (Exception e) {
            log.debug((Object)("Exception on date format: " + e.getMessage()));
        }
        return details;
    }

    private static CommunityProject asCommunityProject(String communityId, Concept c) {
        List p = c.getParams();
        CommunityProject project = new CommunityProject();
        project.setCommunityId(communityId);
        project.setOpenaireId(CommunityImporterService.firstValue((String)"openaireId", (List)p));
        project.setFunder(CommunityImporterService.firstValue((String)"funder", (List)p));
        project.setGrantId(CommunityImporterService.firstValue((String)"CD_PROJECT_NUMBER", (List)p));
        project.setName(CommunityImporterService.firstValue((String)"projectfullname", (List)p));
        project.setAcronym(CommunityImporterService.firstValue((String)"acronym", (List)p));
        project.setAvailableSince(LocalDate.of(2017, 2, 25));
        return project;
    }

    private static CommunityContentprovider asCommunityDataprovider(String communityId, Concept c) {
        List p = c.getParams();
        CommunityContentprovider d = new CommunityContentprovider();
        d.setCommunityId(communityId);
        d.setOpenaireId(CommunityImporterService.firstValue((String)"openaireId", (List)p));
        d.setName(CommunityImporterService.firstValue((String)"name", (List)p));
        d.setOfficialname(CommunityImporterService.firstValue((String)"officialname", (List)p));
        d.setEnabled(BooleanUtils.toBoolean((String)CommunityImporterService.firstValue((String)"enabled", (List)p)));
        d.setSelectioncriteria(SelectionCriteria.fromJson((String)CommunityImporterService.firstValue((String)"selcriteria", (List)p)));
        d.setDeposit(Boolean.valueOf(false));
        d.setMessage(null);
        return d;
    }

    private static CommunityOrganization asCommunityOrganization(String id, Concept c) {
        List p = c.getParams();
        CommunityOrganization o = new CommunityOrganization();
        o.setCommunityId(id);
        o.setName(CommunityImporterService.firstValue((String)"name", (List)p));
        o.setLogo_url(CommunityImporterService.getDecodedUrl((String)CommunityImporterService.firstValue((String)"logourl", (List)p)));
        o.setWebsite_url(CommunityImporterService.getDecodedUrl((String)CommunityImporterService.firstValue((String)"websiteurl", (List)p)));
        return o;
    }

    private static String asZenodoCommunity(Concept c) {
        return CommunityImporterService.firstValue((String)"zenodoid", (List)c.getParams());
    }

    private static List<SubCommunity> asSubCommunities(String communityId, String parent, String category, List<Concept> concepts) {
        ArrayList<SubCommunity> list = new ArrayList<SubCommunity>();
        for (Concept c : concepts) {
            SubCommunity sc = new SubCommunity();
            sc.setSubCommunityId(c.getId());
            sc.setCommunityId(communityId);
            sc.setParent(parent);
            sc.setCategory(category);
            sc.setLabel(c.getLabel());
            sc.setParams(c.getParams());
            sc.setClaim(c.isClaim());
            sc.setBrowsable(false);
            list.add(sc);
            list.addAll(CommunityImporterService.asSubCommunities((String)communityId, (String)c.getId(), (String)category, (List)c.getConcepts()));
        }
        return list;
    }

    private String findNamespaceForECProject(String code) {
        List list = this.jdbcTemplate.queryForList("SELECT substr(id, 1, 12) from projects where code = ? and id like 'corda%'", String.class, new Object[]{code});
        return list.isEmpty() ? null : (String)list.get(0);
    }

    private static String getDecodedUrl(String encoded_url) {
        if (encoded_url == null || encoded_url.startsWith("http")) {
            return encoded_url;
        }
        try {
            return new String(Base64.getDecoder().decode(encoded_url));
        }
        catch (Exception e) {
            log.warn((Object)("Invalid base64: " + encoded_url));
            return encoded_url;
        }
    }

    private static List<String> splitValues(Stream<String> stream, String separator) {
        return stream.map(s -> s.split(separator)).map(Arrays::asList).flatMap(Collection::stream).filter(StringUtils::isNotBlank).map(StringUtils::trim).collect(Collectors.toList());
    }

    private static String firstValue(String name, List<Param> params) {
        return CommunityImporterService.asValues((String)name, params).findFirst().orElse(null);
    }

    private static String asCsv(String name, List<Param> params) {
        return CommunityImporterService.asValues((String)name, params).collect(Collectors.joining(","));
    }

    private static Stream<String> asValues(String name, List<Param> params) {
        return params == null ? Stream.empty() : params.stream().filter(p -> p != null).filter(p -> StringUtils.isNotBlank((CharSequence)p.getName())).filter(p -> p.getName().trim().equals(name.trim())).map(Param::getValue).map(StringUtils::trim).distinct();
    }

    protected DbOrganizationRepository getDbOrganizationRepository() {
        return this.dbOrganizationRepository;
    }

    protected void setDbOrganizationRepository(DbOrganizationRepository dbOrganizationRepository) {
        this.dbOrganizationRepository = dbOrganizationRepository;
    }

    protected CommunityService getService() {
        return this.service;
    }

    protected void setService(CommunityService service) {
        this.service = service;
    }

    protected JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    protected void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

