/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.community;

import eu.dnetlib.openaire.community.model.DbCommunity;
import eu.dnetlib.openaire.community.model.DbDatasourcePK;
import eu.dnetlib.openaire.community.model.DbOrganization;
import eu.dnetlib.openaire.community.model.DbProject;
import eu.dnetlib.openaire.community.model.DbProjectPK;
import eu.dnetlib.openaire.community.model.DbSubCommunity;
import eu.dnetlib.openaire.community.model.DbSupportOrgPK;
import eu.dnetlib.openaire.community.repository.DbCommunityRepository;
import eu.dnetlib.openaire.community.repository.DbDatasourceRepository;
import eu.dnetlib.openaire.community.repository.DbOrganizationRepository;
import eu.dnetlib.openaire.community.repository.DbProjectRepository;
import eu.dnetlib.openaire.community.repository.DbSubCommunityRepository;
import eu.dnetlib.openaire.community.repository.DbSupportOrgRepository;
import eu.dnetlib.openaire.community.utils.CommunityMappingUtils;
import eu.dnetlib.openaire.exporter.exceptions.CommunityException;
import eu.dnetlib.openaire.exporter.exceptions.ResourceNotFoundException;
import eu.dnetlib.openaire.exporter.model.community.CommunityContentprovider;
import eu.dnetlib.openaire.exporter.model.community.CommunityDetails;
import eu.dnetlib.openaire.exporter.model.community.CommunityOrganization;
import eu.dnetlib.openaire.exporter.model.community.CommunityProject;
import eu.dnetlib.openaire.exporter.model.community.CommunitySummary;
import eu.dnetlib.openaire.exporter.model.community.CommunityWritableProperties;
import eu.dnetlib.openaire.exporter.model.community.SubCommunity;
import eu.dnetlib.openaire.exporter.model.community.selectioncriteria.SelectionCriteria;
import eu.dnetlib.openaire.exporter.model.context.IISConfigurationEntry;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(value={"openaire.exporter.enable.community"}, havingValue="true")
public class CommunityService {
    @Autowired
    private DbCommunityRepository dbCommunityRepository;
    @Autowired
    private DbProjectRepository dbProjectRepository;
    @Autowired
    private DbDatasourceRepository dbDatasourceRepository;
    @Autowired
    private DbOrganizationRepository dbOrganizationRepository;
    @Autowired
    private DbSupportOrgRepository dbSupportOrgRepository;
    @Autowired
    private DbSubCommunityRepository dbSubCommunityRepository;
    private static final Log log = LogFactory.getLog(CommunityService.class);

    public List<CommunitySummary> listCommunities() {
        return this.dbCommunityRepository.findAll().stream().map(CommunityMappingUtils::toCommunitySummary).collect(Collectors.toList());
    }

    @Transactional
    public CommunityDetails newCommunity(CommunityDetails details) throws CommunityException {
        if (StringUtils.isBlank((CharSequence)details.getId())) {
            throw new CommunityException("Empty Id");
        }
        if (this.dbCommunityRepository.existsById((Object)details.getId())) {
            throw new CommunityException("Community already exists: " + details.getId());
        }
        details.setCreationDate(LocalDateTime.now());
        return this.saveCommunity(details);
    }

    @Transactional
    public CommunityDetails saveCommunity(CommunityDetails details) {
        details.setLastUpdateDate(LocalDateTime.now());
        this.dbCommunityRepository.save((Object)CommunityMappingUtils.toCommunity((CommunityDetails)details));
        return this.getCommunity(details.getId());
    }

    @Transactional
    public CommunityDetails getCommunity(String id) {
        DbCommunity c = (DbCommunity)this.dbCommunityRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException("Community not found: " + id));
        return CommunityMappingUtils.toCommunityDetails((DbCommunity)c);
    }

    @Transactional
    public void setCommunity(String id, CommunityWritableProperties details) {
        DbCommunity c = (DbCommunity)this.dbCommunityRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException("Community not found: " + id));
        CommunityMappingUtils.populateCommunity((DbCommunity)c, (CommunityWritableProperties)details);
        c.setLastUpdateDate(LocalDateTime.now());
        this.dbCommunityRepository.save((Object)c);
    }

    @Transactional
    public Page<CommunityProject> getCommunityProjects(String id, String funder, String filter, int page, int size, String orderBy) throws CommunityException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new CommunityException("Empty ID");
        }
        try {
            Sort sort = StringUtils.isBlank((CharSequence)orderBy) ? Sort.by((String[])new String[]{"projectName"}) : ("funder".equalsIgnoreCase(orderBy) ? Sort.by((String[])new String[]{"projectFunder"}).and(Sort.by((String[])new String[]{"projectName"})) : ("grantId".equalsIgnoreCase(orderBy) ? Sort.by((String[])new String[]{"projectCode"}) : ("acronym".equalsIgnoreCase(orderBy) ? Sort.by((String[])new String[]{"projectAcronym"}) : ("openaireId".equalsIgnoreCase(orderBy) ? Sort.by((String[])new String[]{"projectId"}) : Sort.by((String[])new String[]{"projectName"})))));
            PageRequest pageable = PageRequest.of((int)page, (int)size, (Sort)sort);
            if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{filter, funder})) {
                return this.dbProjectRepository.findByCommunity(id, (Pageable)pageable).map(CommunityMappingUtils::toCommunityProject);
            }
            Specification projSpec = this.prepareProjectSpec(id, funder, filter);
            return this.dbProjectRepository.findAll(projSpec, (Pageable)pageable).map(CommunityMappingUtils::toCommunityProject);
        }
        catch (Throwable e) {
            log.error((Object)e);
            throw new CommunityException(e);
        }
    }

    private Specification<DbProject> prepareProjectSpec(String community, String funder, String other) {
        return (Specification & Serializable)(project, query, cb) -> {
            ArrayList<Predicate> andConds = new ArrayList<Predicate>();
            andConds.add(cb.equal((Expression)project.get("community"), (Object)community));
            if (StringUtils.isNotBlank((CharSequence)funder)) {
                andConds.add(cb.equal((Expression)project.get("projectFunder"), (Object)funder));
            }
            if (StringUtils.isNotBlank((CharSequence)other)) {
                String s = other.toLowerCase().trim();
                ArrayList<Predicate> orConds = new ArrayList<Predicate>();
                orConds.add(cb.equal(cb.lower((Expression)project.get("projectId")), (Object)s));
                orConds.add(cb.equal(cb.lower((Expression)project.get("projectCode")), (Object)s));
                orConds.add(cb.equal(cb.lower((Expression)project.get("projectAcronym")), (Object)s));
                orConds.add(cb.like(cb.lower((Expression)project.get("projectName")), "%" + s + "%"));
                if (StringUtils.isBlank((CharSequence)funder)) {
                    orConds.add(cb.equal(cb.lower((Expression)project.get("projectFunder")), (Object)s));
                }
                andConds.add(cb.or(orConds.toArray(new Predicate[orConds.size()])));
            }
            return cb.and(andConds.toArray(new Predicate[andConds.size()]));
        };
    }

    @Transactional
    public CommunityProject addCommunityProject(String id, CommunityProject project) {
        DbProject p = CommunityMappingUtils.toDbProject((String)id, (CommunityProject)project);
        this.dbProjectRepository.save((Object)p);
        return project;
    }

    @Transactional
    public void addCommunityProjects(String id, CommunityProject ... projects) throws CommunityException {
        try {
            List list = Arrays.stream(projects).map(p -> CommunityMappingUtils.toDbProject((String)id, (CommunityProject)p)).collect(Collectors.toList());
            this.dbProjectRepository.saveAll(list);
        }
        catch (Throwable e) {
            log.error((Object)e);
            throw new CommunityException(e);
        }
    }

    @Transactional
    public void removeCommunityProjects(String id, String ... ids) {
        List list = Arrays.stream(ids).map(projectId -> new DbProjectPK(id, projectId)).collect(Collectors.toList());
        this.dbProjectRepository.deleteAllById(list);
    }

    public List<CommunityContentprovider> getCommunityDatasources(String id) {
        return this.dbDatasourceRepository.findByCommunity(id).stream().map(CommunityMappingUtils::toCommunityContentprovider).collect(Collectors.toList());
    }

    public List<CommunityContentprovider> getCommunityDatasourcesWithDeposit(String id, boolean deposit) {
        return this.dbDatasourceRepository.findByCommunityAndDeposit(id, deposit).stream().map(CommunityMappingUtils::toCommunityContentprovider).collect(Collectors.toList());
    }

    @Transactional
    public CommunityContentprovider updateCommunityDatasourcesDeposit(String id, String dsId, Boolean deposit, String message) {
        return this.dbDatasourceRepository.findById((Object)new DbDatasourcePK(id, dsId)).map(ds -> {
            ds.setDeposit(Boolean.valueOf(deposit != null ? deposit : false));
            ds.setMessage(message);
            return ds;
        }).map(CommunityMappingUtils::toCommunityContentprovider).orElseThrow(() -> new ResourceNotFoundException("Community and/or Datasource not found"));
    }

    @Transactional
    public void addCommunityDatasources(String id, CommunityContentprovider ... contentproviders) {
        List list = Arrays.stream(contentproviders).map(cp -> CommunityMappingUtils.toDbDatasource((String)id, (CommunityContentprovider)cp)).collect(Collectors.toList());
        this.dbDatasourceRepository.saveAll(list);
    }

    @Transactional
    public void removeCommunityDatasources(String id, String ... ids) {
        List list = Arrays.stream(ids).map(dsId -> new DbDatasourcePK(id, dsId)).collect(Collectors.toList());
        this.dbDatasourceRepository.deleteAllById(list);
    }

    @Transactional
    public void removeCommunityOrganizations(String id, String ... orgNames) {
        List list = Arrays.stream(orgNames).map(name -> new DbSupportOrgPK(id, name)).collect(Collectors.toList());
        this.dbSupportOrgRepository.deleteAllById(list);
    }

    @Transactional
    public List<CommunityOrganization> getCommunityOrganizations(String id) {
        return this.dbSupportOrgRepository.findByCommunity(id).stream().map(CommunityMappingUtils::toCommunityOrganization).collect(Collectors.toList());
    }

    @Transactional
    public void addCommunityOrganizations(String id, CommunityOrganization ... orgs) {
        List list = Arrays.stream(orgs).map(o -> CommunityMappingUtils.toDbSupportOrg((String)id, (CommunityOrganization)o)).collect(Collectors.toList());
        this.dbSupportOrgRepository.saveAll(list);
    }

    @Transactional
    public void removeSubCommunities(String id, String ... subCommunityIds) {
        this.dbSubCommunityRepository.deleteAllById(Arrays.asList(subCommunityIds));
    }

    @Transactional
    public List<SubCommunity> getSubCommunities(String id) {
        return this.dbSubCommunityRepository.findByCommunity(id).stream().map(CommunityMappingUtils::toSubCommunity).collect(Collectors.toList());
    }

    @Transactional
    public void addSubCommunities(String id, SubCommunity ... subs) {
        List list = Arrays.stream(subs).map(s -> CommunityMappingUtils.toDbSubCommunity((String)id, (SubCommunity)s)).collect(Collectors.toList());
        this.dbSubCommunityRepository.saveAll(list);
    }

    @Transactional
    public CommunityDetails addCommunitySubjects(String id, String ... subjects) {
        return this.modifyElementToArrayField(id, DbCommunity::getSubjects, DbCommunity::setSubjects, false, subjects);
    }

    public CommunityDetails removeCommunitySubjects(String id, String ... subjects) {
        return this.modifyElementToArrayField(id, DbCommunity::getSubjects, DbCommunity::setSubjects, true, subjects);
    }

    public CommunityDetails addCommunityFOS(String id, String ... foss) {
        return this.modifyElementToArrayField(id, DbCommunity::getFos, DbCommunity::setFos, false, foss);
    }

    public CommunityDetails removeCommunityFOS(String id, String ... foss) {
        return this.modifyElementToArrayField(id, DbCommunity::getFos, DbCommunity::setFos, true, foss);
    }

    public CommunityDetails addCommunitySDG(String id, String ... sdgs) {
        return this.modifyElementToArrayField(id, DbCommunity::getSdg, DbCommunity::setSdg, false, sdgs);
    }

    public CommunityDetails removeCommunitySDG(String id, String ... sdgs) {
        return this.modifyElementToArrayField(id, DbCommunity::getSdg, DbCommunity::setSdg, true, sdgs);
    }

    @Transactional
    public CommunityDetails addCommunityAdvancedConstraint(String id, SelectionCriteria advancedCosntraint) {
        DbCommunity dbEntry = (DbCommunity)this.dbCommunityRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException("Community not found: " + id));
        dbEntry.setAdvancedConstraints(advancedCosntraint);
        dbEntry.setLastUpdateDate(LocalDateTime.now());
        this.dbCommunityRepository.save((Object)dbEntry);
        return this.getCommunity(id);
    }

    @Transactional
    public CommunityDetails removeCommunityAdvancedConstraint(String id) {
        DbCommunity dbEntry = (DbCommunity)this.dbCommunityRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException("Community not found: " + id));
        dbEntry.setAdvancedConstraints(null);
        dbEntry.setLastUpdateDate(LocalDateTime.now());
        this.dbCommunityRepository.save((Object)dbEntry);
        return this.getCommunity(id);
    }

    @Transactional
    public CommunityDetails addCommunityRemoveConstraint(String id, SelectionCriteria removeConstraint) {
        DbCommunity dbEntry = (DbCommunity)this.dbCommunityRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException("Community not found: " + id));
        dbEntry.setRemoveConstraints(removeConstraint);
        dbEntry.setLastUpdateDate(LocalDateTime.now());
        this.dbCommunityRepository.save((Object)dbEntry);
        return this.getCommunity(id);
    }

    @Transactional
    public CommunityDetails removeCommunityRemoveConstraint(String id) {
        DbCommunity dbEntry = (DbCommunity)this.dbCommunityRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException("Community not found: " + id));
        dbEntry.setRemoveConstraints(null);
        dbEntry.setLastUpdateDate(LocalDateTime.now());
        this.dbCommunityRepository.save((Object)dbEntry);
        return this.getCommunity(id);
    }

    public CommunityDetails removeCommunityZenodoCommunity(String id, String zenodoCommunity, boolean isMain) {
        if (isMain) {
            return this.updateElementToSimpleField(id, DbCommunity::setMainZenodoCommunity, null);
        }
        return this.modifyElementToArrayField(id, DbCommunity::getOtherZenodoCommunities, DbCommunity::setOtherZenodoCommunities, true, new String[]{zenodoCommunity});
    }

    public CommunityDetails addCommunityZenodoCommunity(String id, String zenodoCommunity, boolean isMain) {
        if (isMain) {
            return this.updateElementToSimpleField(id, DbCommunity::setMainZenodoCommunity, zenodoCommunity);
        }
        return this.modifyElementToArrayField(id, DbCommunity::getOtherZenodoCommunities, DbCommunity::setOtherZenodoCommunities, false, new String[]{zenodoCommunity});
    }

    @Transactional
    private CommunityDetails updateElementToSimpleField(String id, BiConsumer<DbCommunity, String> setter, String value) {
        DbCommunity dbEntry = (DbCommunity)this.dbCommunityRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException("Community not found: " + id));
        setter.accept(dbEntry, value);
        dbEntry.setLastUpdateDate(LocalDateTime.now());
        this.dbCommunityRepository.save((Object)dbEntry);
        return this.getCommunity(id);
    }

    @Transactional
    private CommunityDetails modifyElementToArrayField(String id, Function<DbCommunity, String[]> getter, BiConsumer<DbCommunity, String[]> setter, boolean remove, String ... values) {
        DbCommunity dbEntry = (DbCommunity)this.dbCommunityRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException("Community not found: " + id));
        LinkedHashSet<String> tmpList = new LinkedHashSet<String>();
        String[] oldValues = getter.apply(dbEntry);
        if (oldValues != null) {
            Collections.addAll(tmpList, oldValues);
        }
        if (remove) {
            tmpList.removeAll(Arrays.asList(values));
        } else {
            tmpList.addAll(Arrays.asList(values));
        }
        setter.accept(dbEntry, tmpList.toArray(new String[tmpList.size()]));
        dbEntry.setLastUpdateDate(LocalDateTime.now());
        this.dbCommunityRepository.save((Object)dbEntry);
        return this.getCommunity(id);
    }

    @Transactional
    public List<String> getOpenAIRECommunitiesByZenodoId(String zenodoId) {
        return this.dbCommunityRepository.findByZenodoId(zenodoId);
    }

    @Transactional
    public Map<String, Set<String>> getPropagationOrganizationCommunityMap() {
        return this.dbOrganizationRepository.findAll().stream().collect(Collectors.groupingBy(DbOrganization::getOrgId, Collectors.mapping(DbOrganization::getCommunity, Collectors.toSet())));
    }

    @Transactional
    public Set<String> getPropagationOrganizationsForCommunity(String communityId) {
        return this.dbOrganizationRepository.findByCommunity(communityId).stream().map(DbOrganization::getOrgId).collect(Collectors.toSet());
    }

    @Transactional
    public Set<String> addPropagationOrganizationForCommunity(String communityId, String ... organizationIds) {
        for (String orgId : organizationIds) {
            DbOrganization o = new DbOrganization(communityId.trim(), orgId.trim());
            this.dbOrganizationRepository.save((Object)o);
        }
        return this.getPropagationOrganizationsForCommunity(communityId);
    }

    @Transactional
    public Set<String> removePropagationOrganizationForCommunity(String communityId, String ... organizationIds) {
        for (String orgId : organizationIds) {
            DbOrganization o = new DbOrganization(communityId.trim(), orgId.trim());
            this.dbOrganizationRepository.delete((Object)o);
        }
        return this.getPropagationOrganizationsForCommunity(communityId);
    }

    @Transactional
    public void deleteCommunity(String id, boolean recursive) {
        if (recursive) {
            this.dbProjectRepository.deleteByCommunity(id);
            this.dbDatasourceRepository.deleteByCommunity(id);
            this.dbOrganizationRepository.deleteByCommunity(id);
            this.dbSupportOrgRepository.deleteByCommunity(id);
            this.dbSubCommunityRepository.deleteByCommunity(id);
        }
        this.dbCommunityRepository.deleteById((Object)id);
    }

    @Transactional
    public List<IISConfigurationEntry> getIISConfiguration(String id) {
        ArrayList<IISConfigurationEntry> res = new ArrayList<IISConfigurationEntry>();
        res.add(this.dbCommunityRepository.findById((Object)id).map(CommunityMappingUtils::asIISConfigurationEntry).orElseThrow(() -> new ResourceNotFoundException("Community not found: " + id)));
        for (DbSubCommunity subc : this.dbSubCommunityRepository.findByCommunity(id)) {
            res.add(CommunityMappingUtils.asIISConfigurationEntry((DbSubCommunity)subc));
        }
        return res;
    }

    @Transactional
    public List<String> getCommunityFunders(String id) {
        return this.dbProjectRepository.findFundersByCommunity(id);
    }
}

