/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.community;

import eu.dnetlib.openaire.common.AbstractExporterController;
import eu.dnetlib.openaire.community.CommunityService;
import eu.dnetlib.openaire.community.model.DepositionInfo;
import eu.dnetlib.openaire.exporter.exceptions.CommunityException;
import eu.dnetlib.openaire.exporter.exceptions.ResourceNotFoundException;
import eu.dnetlib.openaire.exporter.model.community.CommunityContentprovider;
import eu.dnetlib.openaire.exporter.model.community.CommunityDetails;
import eu.dnetlib.openaire.exporter.model.community.CommunityOpenAIRECommunities;
import eu.dnetlib.openaire.exporter.model.community.CommunityOrganization;
import eu.dnetlib.openaire.exporter.model.community.CommunityProject;
import eu.dnetlib.openaire.exporter.model.community.CommunitySummary;
import eu.dnetlib.openaire.exporter.model.community.CommunityWritableProperties;
import eu.dnetlib.openaire.exporter.model.community.SubCommunity;
import eu.dnetlib.openaire.exporter.model.community.selectioncriteria.SelectionCriteria;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin(origins={"*"})
@ConditionalOnProperty(value={"openaire.exporter.enable.community"}, havingValue="true")
@Tag(name="OpenAIRE Communities API", description="the OpenAIRE Community API")
public class CommunityApiController
extends AbstractExporterController {
    @Autowired
    private CommunityService communityService;

    @GetMapping(value={"/community/communities"})
    @Operation(summary="get all community profiles", description="get all community profiles", tags={"Community", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="500", description="unexpected error")})
    public List<CommunitySummary> listCommunities() throws CommunityException {
        try {
            return this.communityService.listCommunities();
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/"})
    @Operation(summary="add a new community profile", description="add a new community profile", tags={"Community", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails getCommunity(@RequestBody CommunityDetails details) throws CommunityException {
        try {
            return this.communityService.newCommunity(details);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @GetMapping(value={"/community/{id}"})
    @Operation(summary="get community profile", description="get community profile", tags={"Community", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails getCommunity(@PathVariable String id) throws CommunityException {
        try {
            return this.communityService.getCommunity(id);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}"})
    @Operation(summary="update community details", description="update community details", tags={"Community", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void setCommunity(@PathVariable String id, @RequestBody CommunityWritableProperties properties) throws CommunityException {
        try {
            this.communityService.setCommunity(id, properties);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @DeleteMapping(value={"/community/{id}"})
    @Operation(summary="delete a community", description="delete a community", tags={"Community", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void deleteCommunity(@PathVariable String id, @RequestParam(required=false, defaultValue="false") boolean recursive) throws CommunityException {
        try {
            this.communityService.deleteCommunity(id, recursive);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @GetMapping(value={"/community/{id}/projects/{page}/{size}"})
    @Operation(summary="get community projects", description="get community projects", tags={"Community projects", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public Page<CommunityProject> getCommunityProjects(@PathVariable String id, @PathVariable Integer page, @PathVariable Integer size, @RequestParam(required=false) String funder, @RequestParam(required=false) String searchFilter, @RequestParam(required=false) String orderBy) throws CommunityException {
        try {
            return this.communityService.getCommunityProjects(id, funder, searchFilter, page.intValue(), size.intValue(), orderBy);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/projects"})
    @Operation(summary="associate a project to the community, provide all the fields or the method will overwrite with nulls the fields that are missing", description="associate a project to the community, provide all the fields or the method will overwrite with nulls the fields that are missing", tags={"Community projects", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityProject addCommunityProject(@PathVariable String id, @RequestBody CommunityProject project) throws CommunityException {
        try {
            return this.communityService.addCommunityProject(id, project);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @DeleteMapping(value={"/community/{id}/projects"})
    @Operation(summary="remove a project from the community", description="remove a project from the community", tags={"Community projects", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void deleteCommunityProject(@PathVariable String id, @RequestParam String projectId) throws CommunityException {
        try {
            this.communityService.removeCommunityProjects(id, new String[]{projectId});
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/projectList"})
    @Operation(summary="associate a list of project to the community", description="associate a list of project to the community", tags={"Community projects", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityProject[] addCommunityProjectList(@PathVariable String id, @RequestBody CommunityProject[] projects) throws CommunityException {
        try {
            this.communityService.addCommunityProjects(id, projects);
            return projects;
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @DeleteMapping(value={"/community/{id}/projectList"})
    @Operation(summary="remove a list of projects from the community", description="remove a list of projects from the community", tags={"Community projects", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void deleteCommunityProjectList(@PathVariable String id, @RequestBody String[] projectIdList) throws CommunityException {
        try {
            this.communityService.removeCommunityProjects(id, projectIdList);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @GetMapping(value={"/community/{id}/funders"})
    @Operation(summary="get the funders of the projects of a community", description="get the funders of the projects of a community", tags={"Community projects", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public List<String> getCommunityFunders(@PathVariable String id) throws CommunityException {
        try {
            return this.communityService.getCommunityFunders(id);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @GetMapping(value={"/community/{id}/datasources"})
    @Operation(summary="get the list of datasources associated to a given community", description="get the list of content providers associated to a given community", tags={"Community content providers", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public List<CommunityContentprovider> getCommunityDatasources(@PathVariable String id, @RequestParam(required=false) Boolean deposit) throws CommunityException {
        try {
            return deposit == null ? this.communityService.getCommunityDatasources(id) : this.communityService.getCommunityDatasourcesWithDeposit(id, deposit.booleanValue());
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/datasources"})
    @Operation(summary="associate a datasource to the community, provide all the fields or the method will overwrite with nulls the fields that are missing", description="associate a datasource to the community, provide all the fields or the method will overwrite with nulls the fields that are missing", tags={"Community content providers", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityContentprovider addCommunityDatasource(@PathVariable String id, @RequestBody CommunityContentprovider datasource) throws CommunityException {
        try {
            this.communityService.addCommunityDatasources(id, new CommunityContentprovider[]{datasource});
            return datasource;
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/datasources/deposit"})
    @Operation(summary="update the deposit and message filelds of a datasource associated to the community", description="update the deposit and message filelds of a datasource associated to the community", tags={"Community content providers", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityContentprovider addCommunityDatasourceDeposit(@PathVariable String id, @RequestBody DepositionInfo info) throws CommunityException {
        try {
            return this.communityService.updateCommunityDatasourcesDeposit(id, info.getOpenaireId(), info.getDeposit(), info.getMessage());
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @DeleteMapping(value={"/community/{id}/datasources"})
    @Operation(summary="remove the association between a datasource and the community", description="remove the association between a datasource and the community", tags={"Community content providers", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void removeCommunityDatasource(@PathVariable String id, @RequestParam String dsId) throws CommunityException {
        try {
            this.communityService.removeCommunityDatasources(id, new String[]{dsId});
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/datasourcesList"})
    @Operation(summary="associate a list of datasources to the community, provide all the fields or the method will overwrite with nulls the fields that are missing", description="associate a list of datasources to the community, provide all the fields or the method will overwrite with nulls the fields that are missing", tags={"Community content providers", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityContentprovider[] addCommunityDatasourcesList(@PathVariable String id, @RequestBody CommunityContentprovider[] dsList) throws CommunityException {
        try {
            this.communityService.addCommunityDatasources(id, dsList);
            return dsList;
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @DeleteMapping(value={"/community/{id}/datasourcesList"})
    @Operation(summary="remove a list of datasources from the community", description="remove a list of datasources from the community", tags={"Community content providers", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void deleteCommunityDatasourcesList(@PathVariable String id, @RequestBody String[] dsIdList) throws CommunityException {
        try {
            this.communityService.removeCommunityDatasources(id, dsIdList);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @Deprecated
    @GetMapping(value={"/community/{id}/contentproviders"})
    @Operation(summary="get the list of datasources associated to a given community", description="get the list of content providers associated to a given community", tags={"Community content providers", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public List<CommunityContentprovider> getCommunityContentproviders(@PathVariable String id, @RequestParam(required=false) Boolean deposit) throws CommunityException {
        return this.getCommunityDatasources(id, deposit);
    }

    @Deprecated
    @PostMapping(value={"/community/{id}/contentproviders"})
    @Operation(summary="associate a datasource to the community, provide all the fields or the method will overwrite with nulls the fields that are missing", description="associate a datasource to the community, provide all the fields or the method will overwrite with nulls the fields that are missing", tags={"Community content providers", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityContentprovider addCommunityContentprovider(@PathVariable String id, @RequestBody CommunityContentprovider contentprovider) throws CommunityException {
        return this.addCommunityDatasource(id, contentprovider);
    }

    @Deprecated
    @DeleteMapping(value={"/community/{id}/contentproviders"})
    @Operation(summary="remove the association between a datasource and the community", description="remove the association between a datasource and the community", tags={"Community content providers", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void removeCommunityContentprovider(@PathVariable String id, @RequestParam String contentproviderId) throws CommunityException {
        this.removeCommunityDatasource(id, contentproviderId);
    }

    @Deprecated
    @PostMapping(value={"/community/{id}/contentprovidersList"})
    @Operation(summary="associate a list of datasources to the community, provide all the fields or the method will overwrite with nulls the fields that are missing", description="associate a list of datasources to the community, provide all the fields or the method will overwrite with nulls the fields that are missing", tags={"Community content providers", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityContentprovider[] addCommunityContentProvidersList(@PathVariable String id, @RequestBody CommunityContentprovider[] contentprovidersList) throws CommunityException {
        return this.addCommunityDatasourcesList(id, contentprovidersList);
    }

    @Deprecated
    @DeleteMapping(value={"/community/{id}/contentprovidersList"})
    @Operation(summary="remove a list of datasources from the community", description="remove a list of datasources from the community", tags={"Community content providers", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void deleteCommunityContentProvidersList(@PathVariable String id, @RequestBody String[] contentProviderIdList) throws CommunityException {
        this.deleteCommunityDatasourcesList(id, contentProviderIdList);
    }

    @GetMapping(value={"/community/{id}/organizations"})
    @Operation(summary="get the list of organizations for a given community", description="get the list of organizations for a given community", tags={"Community Organizations", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public List<CommunityOrganization> getCommunityOrganizations(@PathVariable String id) throws CommunityException {
        try {
            return this.communityService.getCommunityOrganizations(id);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/organizations"})
    @Operation(summary="associate an organization to the community, provide all the fields or the method will overwrite with nulls the fields that are missing", description="associate an organization to the community, provide all the fields or the method will overwrite with nulls the fields that are missing", tags={"Community Organizations", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityOrganization addCommunityOrganization(@PathVariable String id, @RequestBody CommunityOrganization organization) throws CommunityException {
        try {
            this.communityService.addCommunityOrganizations(id, new CommunityOrganization[]{organization});
            return organization;
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/organizationList"})
    @Operation(summary="associate a list of organizations to the community, provide all the fields or the method will overwrite with nulls the fields that are missing", description="associate a list of organizations to the community, provide all the fields or the method will overwrite with nulls the fields that are missing", tags={"Community Organizations", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityOrganization[] addCommunityOrganizationList(@PathVariable String id, @RequestBody CommunityOrganization[] orgs) throws CommunityException {
        try {
            this.communityService.addCommunityOrganizations(id, orgs);
            return orgs;
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @DeleteMapping(value={"/community/{id}/organizations"})
    @Operation(summary="remove the association between an organization and the community", description="remove the association between an organization and the community", tags={"Community Organizations", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void removeCommunityOrganization(@PathVariable String id, @RequestParam String organizationName) throws CommunityException {
        try {
            this.communityService.removeCommunityOrganizations(id, new String[]{organizationName});
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @DeleteMapping(value={"/community/{id}/organizationList"})
    @Operation(summary="remove a list of associations between some organizations and the community", description="remove a list of associations between some organizations and the community", tags={"Community Organizations", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void removeCommunityOrganizationList(@PathVariable String id, @RequestBody String[] orgNames) throws CommunityException {
        try {
            this.communityService.removeCommunityOrganizations(id, orgNames);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/subjects"})
    @Operation(summary="associate a subject to the community", description="associate a subject to the community", tags={"Community", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails addCommunitySubjects(@PathVariable String id, @RequestBody String[] subjects) throws CommunityException {
        try {
            return this.communityService.addCommunitySubjects(id, subjects);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @DeleteMapping(value={"/community/{id}/subjects"})
    @Operation(summary="remove subjects from a community", description="remove subjects from a community", tags={"Community", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails removeCommunitySubjects(@PathVariable String id, @RequestBody String[] subjects) throws CommunityException {
        try {
            return this.communityService.removeCommunitySubjects(id, subjects);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/fos"})
    @Operation(summary="associate a fos to the community", description="associate a fos to the community", tags={"Community", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails addCommunityFOS(@PathVariable String id, @RequestBody String[] subjects) throws CommunityException {
        try {
            return this.communityService.addCommunityFOS(id, subjects);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @DeleteMapping(value={"/community/{id}/fos"})
    @Operation(summary="remove fos from a community", description="remove fos from a community", tags={"Community", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails removeCommunityFOS(@PathVariable String id, @RequestBody String[] subjects) throws CommunityException {
        try {
            return this.communityService.removeCommunityFOS(id, subjects);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/sdg"})
    @Operation(summary="associate a sdg to the community", description="associate a sdg to the community", tags={"Community", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails addCommunitySDG(@PathVariable String id, @RequestBody String[] subjects) throws CommunityException {
        try {
            return this.communityService.addCommunitySDG(id, subjects);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @DeleteMapping(value={"/community/{id}/sdg"})
    @Operation(summary="remove sdg from a community", description="remove sdg from a community", tags={"Community", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails removeCommunitySDG(@PathVariable String id, @RequestBody String[] subjects) throws CommunityException {
        try {
            return this.communityService.removeCommunitySDG(id, subjects);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/advancedConstraint"})
    @Operation(summary="the set of constraints to be used to extend the association between result and community", description="the set of constraints to be used to extend the association between result and community", tags={"Community", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails addAdvancedConstraint(@PathVariable String id, @RequestBody SelectionCriteria advancedConstraint) throws CommunityException {
        try {
            return this.communityService.addCommunityAdvancedConstraint(id, advancedConstraint);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @DeleteMapping(value={"/community/{id}/advancedConstraint"})
    @Operation(summary="remove the constraints to extend the association result community from a community", description="remove the constraints to extend the association result community from a community", tags={"Community", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails removeAdvancedConstraint(@PathVariable String id) throws CommunityException {
        try {
            return this.communityService.removeCommunityAdvancedConstraint(id);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/removeConstraint"})
    @Operation(summary="the set of constraints to be used to remove the association between result and community", description="the set of constraints to be used to remove the association between result and community", tags={"Community", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails addRemoveConstraint(@PathVariable String id, @RequestBody SelectionCriteria removeConstraint) throws CommunityException {
        try {
            return this.communityService.addCommunityRemoveConstraint(id, removeConstraint);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @DeleteMapping(value={"/community/{id}/removeConstraint"})
    @Operation(summary="remove the constraints to remove the association beetween result and community", description="remove the constraints to remove the association beetween result and community", tags={"Community", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails removeRemoveConstraint(@PathVariable String id) throws CommunityException {
        try {
            return this.communityService.removeCommunityRemoveConstraint(id);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/zenodocommunities"})
    @Operation(summary="associate a Zenodo community to the community", description="associate a Zenodo community to the community", tags={"Community Zenodo Communities", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityDetails addCommunityZenodoCommunity(@PathVariable String id, @RequestParam(required=false, defaultValue="false") boolean main, @RequestParam String zenodocommunity) throws CommunityException {
        try {
            return this.communityService.addCommunityZenodoCommunity(id, zenodocommunity, main);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @DeleteMapping(value={"/community/{id}/zenodocommunities"})
    @Operation(summary="remove a Zenodo community from a community", description="remove a Zenodo community from a community", tags={"Community Zenodo Communities", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void removeCommunityZenodoCommunity(@PathVariable String id, @RequestParam(required=false, defaultValue="false") boolean main, @RequestParam String zenodocommunity) throws CommunityException {
        try {
            this.communityService.removeCommunityZenodoCommunity(id, zenodocommunity, main);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @GetMapping(value={"/community/{zenodoId}/openairecommunities"})
    @Operation(summary="get the list of OpenAIRE communities associated to a given Zenodo community", description="get the list of OpenAIRE communities associated to a given Zenodo community", tags={"Community Zenodo Communities", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public CommunityOpenAIRECommunities getOpenAireCommunities(@PathVariable String zenodoId) throws CommunityException {
        try {
            CommunityOpenAIRECommunities res = new CommunityOpenAIRECommunities();
            res.setZenodoid(zenodoId);
            res.setOpenAirecommunitylist(this.communityService.getOpenAIRECommunitiesByZenodoId(zenodoId));
            return res;
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @GetMapping(value={"/propagationOrganizationCommunityMap"})
    @Operation(summary="Get the propagationOrganizationCommunityMap", description="propagationOrganizationCommunityMap", tags={"Community Organizations", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public Map<String, Set<String>> getPropagationOrganizationCommunityMap() throws CommunityException {
        try {
            return this.communityService.getPropagationOrganizationCommunityMap();
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @GetMapping(value={"/community/{id}/propagationOrganizations"})
    @Operation(summary="try { return the propagation organizations of a community", description="try { return the propagation organizations of a community", tags={"Community Organizations", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public Set<String> getPropagationOrganizationsForCommunity(@PathVariable String id) throws CommunityException {
        try {
            return this.communityService.getPropagationOrganizationsForCommunity(id);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/propagationOrganizations"})
    @Operation(summary="add an organization to the propagationOrganizationCommunityMap", description="add an organization to the propagationOrganizationCommunityMap", tags={"Community Organizations", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public Set<String> addPropagationOrganizationForCommunity(@PathVariable String id, @RequestParam String organizationId) throws CommunityException {
        try {
            return this.communityService.addPropagationOrganizationForCommunity(id, organizationId.split(","));
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @DeleteMapping(value={"/community/{id}/propagationOrganizations"})
    @Operation(summary="delete an organization to the propagationOrganizationCommunityMap", description="delete an organization to the propagationOrganizationCommunityMap", tags={"Community Organizations", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public Set<String> removePropagationOrganizationForCommunity(@PathVariable String id, @RequestParam String organizationId) throws CommunityException {
        try {
            return this.communityService.removePropagationOrganizationForCommunity(id, organizationId.split(","));
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @GetMapping(value={"/community/{id}/subcommunities"})
    @Operation(summary="get the list of subcommunities for a given community", description="get the list of subcommunities for a given community", tags={"Subcommunities", "Read"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public List<SubCommunity> getSubCommunities(@PathVariable String id, @RequestParam(required=false, defaultValue="false") boolean all) throws CommunityException {
        try {
            return this.communityService.getSubCommunities(id).stream().filter(sc -> all || sc.isBrowsable()).collect(Collectors.toList());
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/subcommunities"})
    @Operation(summary="associate a subcommunity to the community, provide all the fields or the method will overwrite with nulls the fields that are missing", description="associate a subcommunity to the community, provide all the fields or the method will overwrite with nulls the fields that are missing", tags={"Subcommunities", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public SubCommunity addSubCommunity(@PathVariable String id, @RequestBody SubCommunity subcommunity) throws CommunityException {
        try {
            this.communityService.addSubCommunities(id, new SubCommunity[]{subcommunity});
            return subcommunity;
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @PostMapping(value={"/community/{id}/subcommunitiesList"})
    @Operation(summary="associate a list of subcommunities to the community, provide all the fields or the method will overwrite with nulls the fields that are missing", description="associate a list of subcommunities to the community, provide all the fields or the method will overwrite with nulls the fields that are missing", tags={"Subcommunities", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public SubCommunity[] addSubCommunityList(@PathVariable String id, @RequestBody SubCommunity[] subcommunities) throws CommunityException {
        try {
            this.communityService.addSubCommunities(id, subcommunities);
            return subcommunities;
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @DeleteMapping(value={"/community/{id}/subcommunities"})
    @Operation(summary="remove the association between a subcommunity and the community", description="remove the association between a subcommunity and the community", tags={"Subcommunities", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void removeSubCommunity(@PathVariable String id, @RequestParam String subCommunityId) throws CommunityException {
        try {
            this.communityService.removeSubCommunities(id, new String[]{subCommunityId});
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }

    @DeleteMapping(value={"/community/{id}/subcommunitiesList"})
    @Operation(summary="remove a list of associations between some subcommunities and the community", description="remove a list of associations between some subcommunities and the community", tags={"Subcommunities", "Write"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="not found"), @ApiResponse(responseCode="500", description="unexpected error")})
    public void removeSubcommunities(@PathVariable String id, @RequestBody String[] subCommunityIdList) throws CommunityException {
        try {
            this.communityService.removeSubCommunities(id, subCommunityIdList);
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CommunityException(e);
        }
    }
}

