/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.community.model;

import com.vladmihalcea.hibernate.type.array.StringArrayType;
import com.vladmihalcea.hibernate.type.json.JsonBinaryType;
import com.vladmihalcea.hibernate.type.json.JsonStringType;
import eu.dnetlib.openaire.community.utils.CommunityClaimTypeConverter;
import eu.dnetlib.openaire.community.utils.CommunityMembershipTypeConverter;
import eu.dnetlib.openaire.exporter.model.community.CommunityClaimType;
import eu.dnetlib.openaire.exporter.model.community.CommunityMembershipType;
import eu.dnetlib.openaire.exporter.model.community.CommunityPlanType;
import eu.dnetlib.openaire.exporter.model.community.CommunityStatus;
import eu.dnetlib.openaire.exporter.model.community.CommunityType;
import eu.dnetlib.openaire.exporter.model.community.selectioncriteria.SelectionCriteria;
import eu.dnetlib.openaire.exporter.model.context.Param;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;
import org.hibernate.annotations.TypeDefs;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;

@Entity
@Table(name="communities")
@TypeDefs(value={@TypeDef(name="string-array", typeClass=StringArrayType.class), @TypeDef(name="json", typeClass=JsonStringType.class), @TypeDef(name="jsonb", typeClass=JsonBinaryType.class)})
public class DbCommunity
implements Serializable {
    private static final long serialVersionUID = 4315597783109726539L;
    @Id
    @Column(name="id")
    private String id;
    @Column(name="sub_c_parent")
    private String parent;
    @Column(name="name")
    private String name;
    @Column(name="shortname")
    private String shortName;
    @Column(name="displayname")
    private String displayName;
    @Column(name="displayshortname")
    private String displayShortName;
    @Column(name="description")
    private String description;
    @Column(name="status")
    @Enumerated(value=EnumType.STRING)
    private CommunityStatus status = CommunityStatus.hidden;
    @Column(name="membership")
    @Convert(converter=CommunityMembershipTypeConverter.class)
    private CommunityMembershipType membership = CommunityMembershipType.byInvitation;
    @Column(name="type")
    @Enumerated(value=EnumType.STRING)
    private CommunityType type;
    @Column(name="claim")
    @Convert(converter=CommunityClaimTypeConverter.class)
    private CommunityClaimType claim;
    @Type(type="string-array")
    @Column(name="subjects", columnDefinition="text[]")
    private String[] subjects;
    @Type(type="string-array")
    @Column(name="fos", columnDefinition="text[]")
    private String[] fos;
    @Type(type="string-array")
    @Column(name="sdg", columnDefinition="text[]")
    private String[] sdg;
    @Type(type="jsonb")
    @Column(name="adv_constraints")
    private SelectionCriteria advancedConstraints;
    @Type(type="jsonb")
    @Column(name="remove_constraints")
    private SelectionCriteria removeConstraints;
    @Column(name="main_zenodo_community")
    private String mainZenodoCommunity;
    @Type(type="string-array")
    @Column(name="other_zenodo_communities", columnDefinition="text[]")
    private String[] otherZenodoCommunities;
    @CreatedDate
    @Column(name="creation_date")
    private LocalDateTime creationDate;
    @LastModifiedDate
    @Column(name="last_update")
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private LocalDateTime lastUpdateDate;
    @Column(name="logo_url")
    private String logoUrl;
    @Type(type="string-array")
    @Column(name="suggested_acknowledgements", columnDefinition="text[]")
    private String[] suggestedAcknowledgements;
    @Column(name="plan")
    @Enumerated(value=EnumType.STRING)
    private CommunityPlanType plan;
    @Type(type="jsonb")
    @Column(name="sub_c_params")
    private List<Param> params = new ArrayList();
    @Column(name="sub_c_category")
    private String category;
    @Column(name="sub_c_claimable")
    private Boolean claimable;
    @Column(name="sub_c_browsable")
    private Boolean browsable;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayShortName() {
        return this.displayShortName;
    }

    public void setDisplayShortName(String displayShortName) {
        this.displayShortName = displayShortName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CommunityStatus getStatus() {
        return this.status;
    }

    public void setStatus(CommunityStatus status) {
        this.status = status;
    }

    public CommunityMembershipType getMembership() {
        return this.membership;
    }

    public void setMembership(CommunityMembershipType membership) {
        this.membership = membership;
    }

    public CommunityType getType() {
        return this.type;
    }

    public void setType(CommunityType type) {
        this.type = type;
    }

    public CommunityClaimType getClaim() {
        return this.claim;
    }

    public void setClaim(CommunityClaimType claim) {
        this.claim = claim;
    }

    public String[] getSubjects() {
        return this.subjects;
    }

    public void setSubjects(String[] subjects) {
        this.subjects = subjects;
    }

    public String[] getFos() {
        return this.fos;
    }

    public void setFos(String[] fos) {
        this.fos = fos;
    }

    public String[] getSdg() {
        return this.sdg;
    }

    public void setSdg(String[] sdg) {
        this.sdg = sdg;
    }

    public SelectionCriteria getAdvancedConstraints() {
        return this.advancedConstraints;
    }

    public void setAdvancedConstraints(SelectionCriteria advancedConstraints) {
        this.advancedConstraints = advancedConstraints;
    }

    public SelectionCriteria getRemoveConstraints() {
        return this.removeConstraints;
    }

    public void setRemoveConstraints(SelectionCriteria removeConstraints) {
        this.removeConstraints = removeConstraints;
    }

    public String getMainZenodoCommunity() {
        return this.mainZenodoCommunity;
    }

    public void setMainZenodoCommunity(String mainZenodoCommunity) {
        this.mainZenodoCommunity = mainZenodoCommunity;
    }

    public String[] getOtherZenodoCommunities() {
        return this.otherZenodoCommunities;
    }

    public void setOtherZenodoCommunities(String[] otherZenodoCommunities) {
        this.otherZenodoCommunities = otherZenodoCommunities;
    }

    public LocalDateTime getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(LocalDateTime creationDate) {
        this.creationDate = creationDate;
    }

    public LocalDateTime getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public void setLastUpdateDate(LocalDateTime lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate;
    }

    public String getLogoUrl() {
        return this.logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    public String[] getSuggestedAcknowledgements() {
        return this.suggestedAcknowledgements;
    }

    public void setSuggestedAcknowledgements(String[] suggestedAcknowledgements) {
        this.suggestedAcknowledgements = suggestedAcknowledgements;
    }

    public CommunityPlanType getPlan() {
        return this.plan;
    }

    public void setPlan(CommunityPlanType plan) {
        this.plan = plan;
    }

    public List<Param> getParams() {
        return this.params;
    }

    public void setParams(List<Param> params) {
        this.params = params;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public Boolean isClaimable() {
        return this.claimable;
    }

    public void setClaimable(Boolean claimable) {
        this.claimable = claimable;
    }

    public Boolean isBrowsable() {
        return this.browsable;
    }

    public void setBrowsable(Boolean browsable) {
        this.browsable = browsable;
    }
}

