/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.funders;

import eu.dnetlib.openaire.exporter.exceptions.FundersApiException;
import eu.dnetlib.openaire.funders.FunderRepository;
import eu.dnetlib.openaire.funders.domain.db.FunderDatasource;
import eu.dnetlib.openaire.funders.domain.db.FunderDbEntry;
import eu.dnetlib.openaire.funders.domain.db.FunderDbUpdate;
import eu.dnetlib.openaire.funders.domain.db.FunderPid;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"openaire.exporter.enable.funders"}, havingValue="true")
public class FunderService {
    private static final String SEPARATOR = "@=@";
    @Autowired
    private FunderRepository funderRepository;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    public List<FunderDbEntry> getFunders() {
        return StreamSupport.stream(this.funderRepository.findAll().spliterator(), false).map(arg_0 -> this.patchFunder(arg_0)).collect(Collectors.toList());
    }

    public FunderDbEntry getFunder(String id) throws FundersApiException {
        return this.funderRepository.findById((Object)id).map(arg_0 -> this.patchFunder(arg_0)).orElseThrow(() -> new FundersApiException("Missing Funder: " + id));
    }

    public boolean isValidFunder(String id) {
        return this.funderRepository.existsById((Object)id);
    }

    private FunderDbEntry patchFunder(FunderDbEntry funder) {
        List datasources = Arrays.stream(funder.getDatasourcesPostgres()).filter(Objects::nonNull).map(s -> s.split(SEPARATOR)).filter(arr -> ((String[])arr).length == 4).map(arr -> {
            FunderDatasource ds = new FunderDatasource();
            ds.setId(arr[0].trim());
            ds.setName(arr[1].trim());
            ds.setType(arr[2].trim());
            ds.setNsPrefix(arr[3].trim());
            switch (ds.getNsPrefix()) {
                case "corda_______": {
                    ds.setFundingProgram("FP7");
                    break;
                }
                case "corda__h2020": {
                    ds.setFundingProgram("H2020");
                    break;
                }
                case "corda_____he": {
                    ds.setFundingProgram(null);
                }
            }
            return ds;
        }).filter(ds -> StringUtils.isNotBlank((CharSequence)ds.getId())).collect(Collectors.toList());
        funder.setDatasources(datasources);
        List pids = Arrays.stream(funder.getPidsPostgres()).filter(Objects::nonNull).map(s -> s.split(SEPARATOR)).filter(arr -> ((String[])arr).length == 2).map(arr -> {
            FunderPid pid = new FunderPid();
            pid.setType(arr[0].trim());
            pid.setValue(arr[1].trim());
            return pid;
        }).filter(pid -> StringUtils.isNotBlank((CharSequence)pid.getValue())).collect(Collectors.toList());
        funder.setPids(pids);
        return funder;
    }

    public void updateFunder(String id, FunderDbUpdate funderUpdate) {
        String sql = "UPDATE dsm_organizations SET (  legalshortname,  legalname,  websiteurl,  logourl,  country,  registered_funder) = (  coalesce(?, legalshortname),  coalesce(?, legalname),  coalesce(?, websiteurl),  coalesce(?, logourl),  coalesce(?, country),  coalesce(?, registered_funder)) WHERE id = ?";
        this.jdbcTemplate.update("UPDATE dsm_organizations SET (  legalshortname,  legalname,  websiteurl,  logourl,  country,  registered_funder) = (  coalesce(?, legalshortname),  coalesce(?, legalname),  coalesce(?, websiteurl),  coalesce(?, logourl),  coalesce(?, country),  coalesce(?, registered_funder)) WHERE id = ?", new Object[]{funderUpdate.getLegalShortName(), funderUpdate.getLegalName(), funderUpdate.getWebsiteUrl(), funderUpdate.getLogoUrl(), funderUpdate.getCountry(), funderUpdate.getRegistered(), id});
        if (funderUpdate.getPids() != null) {
            funderUpdate.getPids().forEach(pid -> {
                if ((Integer)this.jdbcTemplate.queryForObject("SELECT count(*) FROM dsm_identities WHERE issuertype = ? AND pid = ?", Integer.class, new Object[]{pid.getType(), pid.getValue()}) == 0) {
                    this.jdbcTemplate.update("INSERT INTO dsm_identities(issuertype, pid) VALUES (?, ?)", new Object[]{pid.getType(), pid.getValue()});
                }
                if ((Integer)this.jdbcTemplate.queryForObject("SELECT count(*) FROM dsm_organizationpids WHERE organization = ? AND pid = ?", Integer.class, new Object[]{id, pid.getValue()}) == 0) {
                    this.jdbcTemplate.update("INSERT INTO dsm_organizationpids(organization, pid) VALUES (?, ?)", new Object[]{id, pid.getValue()});
                }
            });
        }
    }
}

