/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.info;

import eu.dnetlib.DnetOpenaireExporterProperties;
import eu.dnetlib.openaire.info.JdbcInfoDao;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"openaire.exporter.enable.info"}, havingValue="true")
public class JdbcInfoDaoImpl
implements JdbcInfoDao {
    private static final Log log = LogFactory.getLog(JdbcInfoDaoImpl.class);
    @Autowired
    private DnetOpenaireExporterProperties config;
    @Autowired
    private DataSource dataSource;

    @Cacheable(value={"info"})
    public LocalDate getDate(JdbcInfoDao.DATE_INFO dateInfo) {
        String sql = "SELECT value FROM info WHERE key=?";
        LocalDate date = null;
        try (Connection con = this.getConn();
             PreparedStatement stm = this.getStm("SELECT value FROM info WHERE key=?", con, dateInfo.name());
             ResultSet rs = this.getRs(stm);){
            log.info((Object)("loading info " + dateInfo + " Query: " + stm.toString()));
            if (rs.next()) {
                date = rs.getObject("value", LocalDate.class);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return date;
    }

    @CacheEvict(cacheNames={"info"}, allEntries=true)
    @Scheduled(fixedDelayString="${openaire.exporter.cache.ttl}")
    public void dropCache() {
        log.debug((Object)"dropped info cache");
    }

    private Connection getConn() throws SQLException {
        Connection connection = this.dataSource.getConnection();
        connection.setAutoCommit(false);
        return connection;
    }

    private PreparedStatement getStm(String sql, Connection con, String param) throws SQLException {
        PreparedStatement stm = con.prepareStatement(sql, 1003);
        stm.setString(1, param);
        stm.setFetchSize(this.config.getJdbc().getMaxRows());
        return stm;
    }

    private ResultSet getRs(PreparedStatement stm) throws SQLException {
        ResultSet rs = stm.executeQuery();
        rs.setFetchSize(this.config.getJdbc().getMaxRows());
        return rs;
    }
}

